/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.wordfilter;

import com.trs.dev4.jdk16.utils.CloseUtil;
import com.trs.dev4.jdk16.utils.DateUtil;
import com.trs.dev4.jdk16.utils.FileUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import com.trs.dev4.jdk16.wordfilter.Dictionary;
import com.trs.dev4.jdk16.wordfilter.IWordFilter;
import com.trs.dev4.jdk16.wordfilter.MatchResult;
import com.trs.dev4.jdk16.wordfilter.Word;
import com.trs.dev4.jdk16.wordfilter.WordVisitorSupport;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WordFilterImpl
implements IWordFilter {
    protected static final Logger LOG = Logger.getLogger(WordFilterImpl.class);
    protected Map<String, Dictionary> dicMap = new HashMap<String, Dictionary>();
    protected final Dictionary systemDic = new Dictionary(Word.WORD_SYSTEM_GROUP);
    private long reloadedTime;
    private long reloadedDuration;
    public static final String SYSTEM_GROUP_DIC_NAME = "system";
    private boolean[] ingoreChars = new boolean[65535];
    private String stopChars = "";
    private String wordMarkPrefixStartTag = "<FONT COLOR=";
    private String wordMarkPrefixEndTag = ">";
    private String wordMarkSuffix = "</FONT>";
    private String wordSeparator = ", ";
    private int defaultFilterWordLevel = 3;
    private String filterWordFileURL;
    private boolean markFilterWordInHtmlTag = false;
    private boolean recordFilterWordInHtmlTag = true;
    private String[] allGroupNames = new String[0];
    private String[] allGroupNamesWithoutSystemGroup = new String[0];

    public WordFilterImpl() {
        int i = 0;
        while (i < this.ingoreChars.length) {
            this.ingoreChars[i] = false;
            ++i;
        }
        char[] m_ingoreChars = new char[]{' ', '\u3000', '!', '\uff01', '\u201c', '\u201d', '\u2018', '\u2019', '\u300a', '\u300b', ':', '\uff1a', '(', ')', '[', ']', '\u3010', '\u3011', '\u2606', '\u2605', '{', '}', '\uff08', '\uff09', '\uff01', '\u3001', ';', ',', '.', '@', '&', '\uff0c', '\uff1b', '\u3002', '*', '\u00b7', '\u2026', '-', '_', '+', '\u00d7', '=', '#', '`', '~', '|', '/', '\\', '\n', '\t', '\r'};
        int i2 = 0;
        while (i2 < m_ingoreChars.length) {
            this.ingoreChars[m_ingoreChars[i2]] = true;
            ++i2;
        }
    }

    @Override
    public String[] getAllGroupNames(boolean incudeSystemGroup) {
        return incudeSystemGroup ? this.allGroupNames : this.allGroupNamesWithoutSystemGroup;
    }

    @Override
    public MatchResult filter(String content, String groupName, boolean markContent) {
        return this.filter(content, new String[]{groupName}, markContent, this.markFilterWordInHtmlTag, this.recordFilterWordInHtmlTag);
    }

    @Override
    public MatchResult filter(String content, String groupName, boolean markContent, boolean markFilterWordInHtmlTag, boolean recordFilterWordInHtmlTag) {
        return this.filter(content, new String[]{groupName}, markContent, markFilterWordInHtmlTag, recordFilterWordInHtmlTag);
    }

    @Override
    public MatchResult filter(String content, String[] groupNames, boolean markContent) {
        return this.filter(content, groupNames, markContent, this.markFilterWordInHtmlTag, this.recordFilterWordInHtmlTag);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public MatchResult filter(String content, String[] groupNames, boolean markContent, boolean markFilterWordInHtmlTag, boolean recordFilterWordInHtmlTag) {
        if (WordFilterImpl.isBlank(content)) {
            return null;
        }
        subDictionaries = null;
        if (groupNames == null || groupNames.length == 0) {
            subDictionaries = new Dictionary[]{};
        } else {
            if ("*".equalsIgnoreCase(groupNames[0])) {
                groupNames = this.allGroupNames;
            }
            subDictionaries = new Dictionary[groupNames.length];
            i = 0;
            while (i < groupNames.length) {
                m_groupName = groupNames[i];
                if (m_groupName != null) {
                    m_dictionary = this.dicMap.get(m_groupName);
                    if (m_dictionary == null) {
                        WordFilterImpl.LOG.error((Object)("filterword dictionary not found. dictionary name:" + m_groupName));
                    } else if (m_dictionary.isEmpty()) {
                        if (WordFilterImpl.LOG.isDebugEnabled()) {
                            WordFilterImpl.LOG.debug((Object)("empty dictionary. pass it. name:" + m_groupName));
                        }
                    } else {
                        subDictionaries[i] = m_dictionary;
                    }
                }
                ++i;
            }
        }
        dictionary = this.systemDic;
        filterWords = null;
        hitted = false;
        contentLength = content.length();
        markedContentResult = markContent != false ? new StringBuffer(contentLength + 100) : null;
        wordList = null;
        skipHtmlTag = markFilterWordInHtmlTag == false && recordFilterWordInHtmlTag == false;
        ltDeep = 0;
        inHtmlTagNow = false;
        posOfContent = 0;
        while (posOfContent < contentLength) {
            block29: {
                org_ch = content.charAt(posOfContent);
                ch = Character.toLowerCase(org_ch);
                if (ch == '<') {
                    ++ltDeep;
                    inHtmlTagNow = true;
                }
                if (inHtmlTagNow && ch == '>' && --ltDeep < 1) {
                    inHtmlTagNow = false;
                }
                fw = dictionary.getWord(ch);
                hitted = false;
                subDicIndex = 0;
                if (ch > '\ufffe' || this.ingoreChars[ch]) break block29;
                if (!inHtmlTagNow || !skipHtmlTag) ** GOTO lbl54
                continue;
                while (subDicIndex < subDictionaries.length) {
                    m_dic = subDictionaries[subDicIndex];
                    if (m_dic != null) {
                        fw = m_dic.getWord(ch);
                    }
                    ++subDicIndex;
lbl54:
                    // 2 sources

                    if (fw == null) continue;
                }
                block3: while (fw != null) {
                    hittedContent = this.getMatchedContent(fw, content, posOfContent);
                    if (hittedContent != null) {
                        if (!inHtmlTagNow || recordFilterWordInHtmlTag) {
                            if (filterWords == null) {
                                filterWords = new LinkedList<Word>();
                            }
                            filterWords.add(fw);
                            if (wordList == null) {
                                wordList = new StringBuffer(128);
                                wordList.append(hittedContent);
                            } else {
                                wordList.append(this.wordSeparator);
                                wordList.append(hittedContent);
                            }
                        }
                        if (markContent) {
                            if (!inHtmlTagNow || markFilterWordInHtmlTag) {
                                markedContentResult.append(this.wordMarkPrefixStartTag);
                                markedContentResult.append(fw.getColor());
                                markedContentResult.append(this.wordMarkPrefixEndTag);
                                markedContentResult.append(hittedContent);
                                markedContentResult.append(this.wordMarkSuffix);
                            } else {
                                markedContentResult.append(hittedContent);
                            }
                        }
                        posOfContent += hittedContent.length();
                        hitted = true;
                        break;
                    }
                    fw = fw.getNext();
                    while (fw == null) {
                        if (subDicIndex >= subDictionaries.length) continue block3;
                        m_dic = subDictionaries[subDicIndex];
                        if (m_dic != null) {
                            fw = m_dic.getWord(ch);
                        }
                        ++subDicIndex;
                    }
                }
            }
            if (hitted) continue;
            if (markContent) {
                markedContentResult.append(org_ch);
            }
            ++posOfContent;
        }
        if (filterWords != null) {
            return new MatchResult(filterWords, markedContentResult == null ? null : markedContentResult.toString(), wordList.toString(), this.wordSeparator);
        }
        return null;
    }

    protected String getMatchedContent(Word filterWord, String content, int startPosOfContent) {
        String filterWordContent = filterWord.getWord();
        int lengthOfContent = content.length();
        boolean lastChar = startPosOfContent == lengthOfContent;
        boolean m_hitted = true;
        int posOfFilterWord = 0;
        int posOfContentBasedScanPos = 0;
        int pos_of_content = startPosOfContent + posOfContentBasedScanPos;
        posOfFilterWord = 0;
        posOfContentBasedScanPos = 0;
        while (posOfFilterWord < filterWordContent.length()) {
            pos_of_content = startPosOfContent + posOfContentBasedScanPos;
            if (pos_of_content >= lengthOfContent) break;
            char m_word = Character.toLowerCase(content.charAt(pos_of_content));
            if (m_word > '\ufffe') {
                ++posOfContentBasedScanPos;
                continue;
            }
            if (this.ingoreChars[m_word]) {
                ++posOfContentBasedScanPos;
                continue;
            }
            if (filterWordContent.charAt(posOfFilterWord) != m_word) {
                m_hitted = false;
                break;
            }
            ++posOfFilterWord;
            ++posOfContentBasedScanPos;
        }
        if (m_hitted && pos_of_content == lengthOfContent && posOfFilterWord < filterWordContent.length()) {
            return null;
        }
        if (m_hitted) {
            if (startPosOfContent > pos_of_content && !lastChar) {
                LOG.error((Object)("error found! IWordFilter failed to match content!(" + startPosOfContent + "-->" + pos_of_content + ")"), (Throwable)new Exception());
                return null;
            }
            return content.substring(startPosOfContent, pos_of_content + 1);
        }
        return null;
    }

    @Override
    public boolean contains(String content, String groupName) {
        if (WordFilterImpl.isBlank(content)) {
            return false;
        }
        Dictionary dictionary = this.dicMap.get(groupName);
        if (dictionary == null) {
            LOG.error((Object)("\u672a\u627e\u5230\u6307\u5b9a\u8bcd\u5178\uff1a" + groupName));
            dictionary = this.dicMap.get(SYSTEM_GROUP_DIC_NAME);
        }
        if (dictionary == null) {
            return false;
        }
        int contentLength = content.length();
        int i = 0;
        while (i < contentLength) {
            Word fw = dictionary.getWord(content.charAt(i));
            while (fw != null) {
                String hittedContent = this.getMatchedContent(fw, content, i);
                if (hittedContent != null) {
                    return true;
                }
                fw = fw.getNext();
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean canPass(String content, String groupName, int level) {
        try {
            int m_level;
            MatchResult result = this.filter(content, groupName, false);
            return result == null || (m_level = result.getHighestLevel()) < level;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return false;
        }
    }

    @Override
    public void logMatchResult(MatchResult result, String filteredObjectName, int filteredObjectId, String description) {
    }

    @Override
    public void reloadDicMap() throws Exception {
        if (StringHelper.isEmpty(this.filterWordFileURL)) {
            LOG.error((Object)("Filterword(" + this.filterWordFileURL + ") is null."));
            return;
        }
        if (FileUtil.fileExists(this.filterWordFileURL)) {
            LOG.error((Object)("Filterword(" + this.filterWordFileURL + ") not exist."));
            return;
        }
        LOG.info((Object)("Reloading filterwords from (" + this.filterWordFileURL + ")..."));
        this.reloadedTime = DateUtil.getCurrentTimeMillis();
        this.reloadedDuration = -1L;
        this.dicMap = this.loadDicMap(this.filterWordFileURL);
        this.reloadedDuration = DateUtil.getCurrentTimeMillis() - this.reloadedTime;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Word Dictionary\uff1a" + this.dicMap + ",allGroupNames:" + StringHelper.join(this.allGroupNames)));
        }
    }

    public Map<String, Dictionary> loadDicMap(String fileUrl) throws Exception {
        Map<String, Dictionary> map;
        InputStream is = null;
        try {
            is = fileUrl.startsWith("classpath://") ? WordFilterImpl.class.getClassLoader().getResourceAsStream(fileUrl.substring("classpath://".length())) : new FileInputStream(fileUrl);
            Element root = WordFilterImpl.read(is).getRootElement();
            WordVisitorSupport visitor = new WordVisitorSupport(root, this);
            this.allGroupNames = visitor.getGroupNamesWithSystem().toArray(new String[0]);
            this.allGroupNamesWithoutSystemGroup = visitor.getGroupNames().toArray(new String[0]);
            LOG.debug((Object)("Loaded WordGroup\uff1a" + StringHelper.join((Object[])visitor.getGroupNames().toArray(new String[0]), ";")));
            map = visitor.getDicMap();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("\u52a0\u8f7d\u8bcd\u5178\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5c5e\u6027\u914d\u7f6e\u6587\u4ef6\u4ee5\u53ca\u8bcd\u5178\u6587\u4ef6\u662f\u5426\u6b63\u786e\u3002\u8fc7\u6ee4\u8bcd\u5178\u6587\u4ef6\uff1a" + fileUrl), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                CloseUtil.closeInputStream(is);
                throw throwable;
            }
        }
        CloseUtil.closeInputStream(is);
        return map;
    }

    public static Document read(InputStream fileName) throws Exception {
        SAXReader reader = null;
        Document document = null;
        reader = new SAXReader();
        document = reader.read(fileName);
        return document;
    }

    @Override
    public void reloadDicMap(List<Word> words) {
        ArrayList<String> listGroupNames = new ArrayList<String>();
        int i = 0;
        while (i < words.size()) {
            Word fw = words.get(i);
            String groupName = fw.getGroup();
            if (this.dicMap.containsKey(groupName)) {
                this.dicMap.get(groupName).addWord(fw.getWord(), fw.getLevel(), fw.getColor());
            } else {
                Dictionary dic = new Dictionary(groupName);
                dic.setGroupName(groupName);
                dic.addWord(fw.getWord(), fw.getLevel(), fw.getColor());
                this.dicMap.put(groupName, dic);
                listGroupNames.add(groupName);
            }
            ++i;
        }
        this.allGroupNames = listGroupNames.toArray(new String[listGroupNames.size()]);
        this.allGroupNamesWithoutSystemGroup = this.allGroupNames;
    }

    public void init() {
        try {
            this.reloadDicMap();
        }
        catch (Exception e) {
            LOG.error((Object)"error loading filterword.", (Throwable)e);
        }
    }

    public static boolean isBlank(String str) {
        return StringHelper.isEmpty(str);
    }

    public String getWordSeparator() {
        return this.wordSeparator;
    }

    public void setWordSeparator(String wordSeparator) {
        this.wordSeparator = wordSeparator;
    }

    @Override
    public String getFilterWordFileURL() {
        return this.filterWordFileURL;
    }

    public void setFilterWordFileURL(String filterWordFileURL) {
        this.filterWordFileURL = filterWordFileURL;
        try {
            this.reloadDicMap();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public boolean isSkipHtmlTag() {
        return !this.markFilterWordInHtmlTag && !this.recordFilterWordInHtmlTag;
    }

    @Deprecated
    public void setSkipHtmlTag(boolean skipHtmlTag) {
        this.markFilterWordInHtmlTag = !skipHtmlTag;
        this.recordFilterWordInHtmlTag = !skipHtmlTag;
    }

    public boolean isMarkFilterWordInHtmlTag() {
        return this.markFilterWordInHtmlTag;
    }

    public void setMarkFilterWordInHtmlTag(boolean markFilterWordInHtmlTag) {
        this.markFilterWordInHtmlTag = markFilterWordInHtmlTag;
    }

    public boolean isRecordFilterWordInHtmlTag() {
        return this.recordFilterWordInHtmlTag;
    }

    public void setRecordFilterWordInHtmlTag(boolean recordFilterWordInHtmlTag) {
        this.recordFilterWordInHtmlTag = recordFilterWordInHtmlTag;
    }

    public int getDefaultFilterWordLevel() {
        return this.defaultFilterWordLevel;
    }

    public void setDefaultFilterWordLevel(int defaultFilterWordLevel) {
        this.defaultFilterWordLevel = defaultFilterWordLevel;
    }

    public String getWordMarkPrefixEndTag() {
        return this.wordMarkPrefixEndTag;
    }

    public void setWordMarkPrefixEndTag(String wordMarkPrefixEndTag) {
        this.wordMarkPrefixEndTag = wordMarkPrefixEndTag;
    }

    public String getWordMarkPrefixStartTag() {
        return this.wordMarkPrefixStartTag;
    }

    public void setWordMarkPrefixStartTag(String wordMarkPrefixStartTag) {
        this.wordMarkPrefixStartTag = wordMarkPrefixStartTag;
    }

    public String getWordMarkSuffix() {
        return this.wordMarkSuffix;
    }

    public void setWordMarkSuffix(String wordMarkSuffix) {
        this.wordMarkSuffix = wordMarkSuffix;
    }

    public String getStopChars() {
        return this.stopChars;
    }

    public void setStopChars(String stopChars) {
        this.stopChars = stopChars;
        if (stopChars == null) {
            return;
        }
        int i = 0;
        while (i < stopChars.length()) {
            char ch = stopChars.charAt(i);
            if (ch < '\uffff') {
                this.ingoreChars[ch] = true;
            }
            ++i;
        }
    }

    @Override
    public Map<String, Object> getStatistic() {
        HashMap<String, Object> statistic = new HashMap<String, Object>();
        statistic.put("reloadedTime", this.reloadedTime);
        statistic.put("reloadedDuration", this.reloadedDuration);
        statistic.put("groupNames", this.getAllGroupNames(true));
        HashMap<String, String> dictionaries = new HashMap<String, String>();
        for (String key : this.dicMap.keySet()) {
            Dictionary dictionary = this.dicMap.get(key);
            dictionaries.put(key, dictionary.listWords());
        }
        statistic.put("dictionaries", dictionaries);
        return statistic;
    }

    @Override
    public Dictionary getSystemDictionary() {
        return this.systemDic;
    }

    @Override
    public boolean ingoreChar(char ch) {
        return this.ingoreChars[ch];
    }
}

