/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.object.SqlUpdate;

public class BatchSqlUpdate
extends SqlUpdate {
    public static int DEFAULT_BATCH_SIZE = 5000;
    private int batchSize = DEFAULT_BATCH_SIZE;
    private final LinkedList parameterQueue = new LinkedList();
    private final List rowsAffected = new ArrayList();

    public BatchSqlUpdate() {
    }

    public BatchSqlUpdate(DataSource ds, String sql) {
        super(ds, sql);
    }

    public BatchSqlUpdate(DataSource ds, String sql, int[] types) {
        super(ds, sql, types);
    }

    public BatchSqlUpdate(DataSource ds, String sql, int[] types, int batchSize) {
        super(ds, sql, types, batchSize);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    protected boolean supportsLobParameters() {
        return false;
    }

    public int update(Object[] args) throws DataAccessException {
        this.validateParameters(args);
        if (!this.parameterQueue.isEmpty() && args.equals(this.parameterQueue.getLast())) {
            throw new InvalidDataAccessApiUsageException("Object array containing the parameters cannot be reused -- you must create a new object arrray for each call to update");
        }
        this.parameterQueue.add(args);
        if (this.parameterQueue.size() == this.batchSize) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Triggering auto-flush because queue reached batch size of " + this.batchSize));
            }
            this.flush();
        }
        return -1;
    }

    public int[] flush() {
        int i;
        if (this.parameterQueue.isEmpty()) {
            return new int[0];
        }
        int[] rowsAffected = this.getJdbcTemplate().batchUpdate(this.getSql(), new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return BatchSqlUpdate.this.parameterQueue.size();
            }

            public void setValues(PreparedStatement ps, int index) throws SQLException {
                Object[] params = (Object[])BatchSqlUpdate.this.parameterQueue.removeFirst();
                BatchSqlUpdate.this.newPreparedStatementSetter(params).setValues(ps);
            }
        });
        for (i = 0; i < rowsAffected.length; ++i) {
            this.rowsAffected.add(new Integer(rowsAffected[i]));
        }
        for (i = 0; i < rowsAffected.length; ++i) {
            this.checkRowsAffected(rowsAffected[i]);
        }
        return rowsAffected;
    }

    public int getQueueCount() {
        return this.parameterQueue.size();
    }

    public int getExecutionCount() {
        return this.rowsAffected.size();
    }

    public int[] getRowsAffected() {
        int[] result = new int[this.rowsAffected.size()];
        int i = 0;
        Iterator it = this.rowsAffected.iterator();
        while (it.hasNext()) {
            Integer rowCount = (Integer)it.next();
            result[i] = rowCount;
            ++i;
        }
        return result;
    }

    public void reset() {
        this.parameterQueue.clear();
        this.rowsAffected.clear();
    }
}

