/*
 * Decompiled with CFR 0.152.
 */
package org.aton.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.aton.exception.ExceptionFire;
import org.aton.net.HttpReqParameters;

public class HttpRequester {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final int RETRY_INTERVAL = 200;
    public static final String CLASS_NAME;
    private String m_sHost = null;
    private String m_sParameters = null;
    private String m_sMethod = null;
    private int m_nRetryTimes = 0;
    private int m_nRetryInterval = 200;
    private HttpURLConnection m_httpConn = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.aton.net.HttpRequester");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    public HttpRequester() {
    }

    public HttpRequester(String p_sHost, String p_sParameters, String p_sMethod) {
        this.setHost(p_sHost);
        this.setParameters(p_sParameters);
        this.setMethod(p_sMethod);
    }

    public String getHost() {
        return this.m_sHost;
    }

    public void setHost(String p_sHost) {
        this.m_sHost = p_sHost == null ? null : p_sHost.trim();
    }

    public String getMethod() {
        return this.m_sMethod;
    }

    public void setMethod(String p_sMethod) {
        this.m_sMethod = p_sMethod;
    }

    public String getParameters() {
        return this.m_sParameters;
    }

    public void setParameters(String p_sParameters) {
        this.m_sParameters = p_sParameters;
    }

    public int getRetryTimes() {
        return this.m_nRetryTimes;
    }

    public void setRetryTimes(int p_nRetryTimes) {
        this.m_nRetryTimes = p_nRetryTimes <= 0 ? 0 : p_nRetryTimes;
    }

    public int getRetryInterval() {
        return this.m_nRetryInterval;
    }

    public void setRetryInterval(int p_nRetryInterval) {
        this.m_nRetryInterval = p_nRetryInterval <= 0 ? 0 : p_nRetryInterval;
    }

    public HttpURLConnection getConnection(boolean p_bOpenIfNotConnected) throws Exception {
        if (this.m_httpConn == null && p_bOpenIfNotConnected) {
            this.connect();
        }
        return this.m_httpConn;
    }

    public boolean isConnected() {
        return this.m_httpConn != null;
    }

    public void disconnect() {
        if (this.m_httpConn != null) {
            this.m_httpConn.disconnect();
            this.m_httpConn = null;
        }
    }

    public HttpURLConnection connect() throws ExceptionFire {
        URL url = null;
        URLConnection urlConn = null;
        if (this.m_sHost == null || this.m_sHost.length() == 0) {
            throw new ExceptionFire(10, "\u6ca1\u6709\u6307\u5b9a\u76ee\u6807\u670d\u52a1\u7a0b\u5e8f\u5730\u5740", String.valueOf(CLASS_NAME) + ".connect");
        }
        try {
            url = new URL(this.m_sHost);
        }
        catch (MalformedURLException ex) {
            throw new ExceptionFire(110, "\u65e0\u6548\u7684URL\u5730\u5740[" + this.m_sHost + "]", String.valueOf(CLASS_NAME) + ".connect", ex);
        }
        try {
            urlConn = url.openConnection();
            if (!(urlConn instanceof HttpURLConnection)) {
                throw new ExceptionFire(110, "\u6307\u5b9a\u8fde\u63a5\u7c7b\u578b\u4e0d\u662fHttpURLConnection", String.valueOf(CLASS_NAME) + ".connect");
            }
            this.m_httpConn = (HttpURLConnection)urlConn;
            this.m_httpConn.setUseCaches(false);
            this.m_httpConn.setDefaultUseCaches(false);
            this.m_httpConn.setRequestMethod(this.m_sMethod == null ? METHOD_GET : this.m_sMethod);
            HttpReqParameters.output(this.m_sParameters, this.m_httpConn);
            return this.m_httpConn;
        }
        catch (Exception ex) {
            if (this.m_httpConn != null) {
                this.m_httpConn.disconnect();
                this.m_httpConn = null;
            }
            throw new ExceptionFire(1, "\u53d1\u9001\u7f51\u7edc\u8bf7\u6c42\u5230[" + this.m_sHost + "]\u5931\u8d25", String.valueOf(CLASS_NAME) + ".connect", ex);
        }
    }

    public String getHeaderField(String p_sName) throws Exception {
        if (p_sName == null) {
            return null;
        }
        try {
            if (!this.isConnected()) {
                this.connect();
            }
            return this.m_httpConn.getHeaderField(p_sName);
        }
        catch (Exception ex) {
            throw new ExceptionFire(1, "\u63d0\u53d6\u5934\u90e8\u5b57\u6bb5\uff08" + p_sName + "\uff09\u5931\u8d25", String.valueOf(CLASS_NAME) + ".getHeaderField", ex);
        }
    }

    public Hashtable getAllHeaderFields() throws Exception {
        Hashtable<String, String> hFields = null;
        String sValue = null;
        String sKey = null;
        int i = 1;
        try {
            if (!this.isConnected()) {
                this.connect();
            }
            hFields = new Hashtable<String, String>();
            while ((sValue = this.m_httpConn.getHeaderField(i)) != null) {
                sKey = this.m_httpConn.getHeaderFieldKey(i);
                if (sKey == null) {
                    sKey = "[" + i + "]";
                }
                hFields.put(sKey, sValue);
                ++i;
            }
            return hFields;
        }
        catch (Exception ex) {
            throw new ExceptionFire(1, "\u63d0\u53d6\u6240\u6709\u5934\u90e8\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25", String.valueOf(CLASS_NAME) + ".getAllHeaderFields", ex);
        }
    }

    public String getContent(String p_sEncoding) throws Exception {
        int i = this.m_nRetryTimes;
        while (i >= 0) {
            block6: {
                try {
                    if (!this.isConnected()) {
                        this.connect();
                    }
                    return HttpRequester.readAsText(this.m_httpConn, p_sEncoding);
                }
                catch (ExceptionFire ex) {
                    if (i == 0 || ex.getErrNo() == 10) {
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    if (i != 0) break block6;
                    throw ex;
                }
            }
            Thread.currentThread();
            Thread.sleep(this.m_nRetryInterval);
            --i;
        }
        return null;
    }

    public String getContent() throws Exception {
        return this.getContent(null);
    }

    public void getFile(String p_sFilePathName) throws Exception {
        int i = this.m_nRetryTimes;
        while (i >= 0) {
            block6: {
                try {
                    if (this.m_httpConn == null) {
                        this.connect();
                    }
                    HttpRequester.readToFile(this.m_httpConn, p_sFilePathName);
                    return;
                }
                catch (ExceptionFire ex) {
                    if (i == 0 || ex.getErrNo() == 10) {
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    if (i != 0) break block6;
                    throw ex;
                }
            }
            Thread.currentThread();
            Thread.sleep(this.m_nRetryInterval);
            --i;
        }
    }

    public void getStream(OutputStream p_out) throws Exception {
        int i = this.m_nRetryTimes;
        while (i >= 0) {
            block6: {
                try {
                    if (!this.isConnected()) {
                        this.connect();
                    }
                    HttpRequester.readToStream(this.m_httpConn, p_out);
                    return;
                }
                catch (ExceptionFire ex) {
                    if (i == 0 || ex.getErrNo() == 10) {
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    if (i != 0) break block6;
                    throw ex;
                }
            }
            Thread.currentThread();
            Thread.sleep(this.m_nRetryInterval);
            --i;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readAsText(URLConnection p_urlConnection, String p_sEncoding) throws ExceptionFire {
        String string;
        BufferedReader srcReader;
        InputStream srcStream;
        block17: {
            String sLine;
            srcStream = null;
            srcReader = null;
            StringBuffer buffer = null;
            try {
                srcStream = p_urlConnection.getInputStream();
            }
            catch (Exception ex) {
                if (srcStream == null) throw new ExceptionFire(111, "\u6253\u5f00\u6570\u636e\u8f93\u5165\u6d41\u5931\u8d25", String.valueOf(CLASS_NAME) + ".readAsText", ex);
                try {
                    srcStream.close();
                    throw new ExceptionFire(111, "\u6253\u5f00\u6570\u636e\u8f93\u5165\u6d41\u5931\u8d25", String.valueOf(CLASS_NAME) + ".readAsText", ex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ExceptionFire(111, "\u6253\u5f00\u6570\u636e\u8f93\u5165\u6d41\u5931\u8d25", String.valueOf(CLASS_NAME) + ".readAsText", ex);
            }
            srcReader = new BufferedReader(new InputStreamReader(srcStream));
            buffer = new StringBuffer();
            while ((sLine = srcReader.readLine()) != null) {
                sLine = p_sEncoding != null ? new String(sLine.getBytes(), p_sEncoding) : new String(sLine.getBytes());
                buffer.append(sLine);
                buffer.append('\n');
            }
            string = buffer.toString();
            Object var7_8 = null;
            if (srcReader == null) break block17;
            try {
                srcReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (srcStream == null) return string;
        try {
            srcStream.close();
            return string;
        }
        catch (Exception ex2) {
            // empty catch block
        }
        return string;
        catch (Exception ex) {
            throw new ExceptionFire(53, "\u8bfb\u53d6\u5e76\u4fdd\u5b58\u6570\u636e\u5931\u8d25", String.valueOf(CLASS_NAME) + ".readAsText", ex);
            {
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (srcReader != null) {
                        try {
                            srcReader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (srcStream == null) throw throwable;
                    try {
                        srcStream.close();
                        throw throwable;
                    }
                    catch (Exception ex2) {}
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readToFile(URLConnection p_urlConnection, String p_sFilePathName) throws ExceptionFire {
        FileOutputStream osFile = null;
        if (p_sFilePathName == null) throw new ExceptionFire(10, "\u6ca1\u6709\u6307\u5b9a\u6587\u4ef6\u4fdd\u5b58\u4f4d\u7f6e", String.valueOf(CLASS_NAME) + ".readToFile");
        if ((p_sFilePathName = p_sFilePathName.trim()).length() == 0) {
            throw new ExceptionFire(10, "\u6ca1\u6709\u6307\u5b9a\u6587\u4ef6\u4fdd\u5b58\u4f4d\u7f6e", String.valueOf(CLASS_NAME) + ".readToFile");
        }
        try {
            osFile = new FileOutputStream(p_sFilePathName);
        }
        catch (Exception ex) {
            if (osFile == null) throw new ExceptionFire(111, "\u6253\u5f00\u6587\u4ef6\u8f93\u51fa\u6d41\u5931\u8d25", String.valueOf(CLASS_NAME) + ".readToFile", ex);
            try {
                osFile.close();
                throw new ExceptionFire(111, "\u6253\u5f00\u6587\u4ef6\u8f93\u51fa\u6d41\u5931\u8d25", String.valueOf(CLASS_NAME) + ".readToFile", ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ExceptionFire(111, "\u6253\u5f00\u6587\u4ef6\u8f93\u51fa\u6d41\u5931\u8d25", String.valueOf(CLASS_NAME) + ".readToFile", ex);
        }
        try {
            try {
                HttpRequester.readToStream(p_urlConnection, osFile);
            }
            catch (ExceptionFire ex) {
                throw new ExceptionFire(ex.getErrNo(), "\u83b7\u53d6\u6570\u636e\u6d41\u5e76\u4fdd\u5b58\u5230\u6587\u4ef6[" + p_sFilePathName + "]\u5931\u8d25", String.valueOf(CLASS_NAME) + ".readToFile", ex);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                osFile.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        try {}
        catch (Exception ex) {
            return;
        }
        osFile.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readToStream(URLConnection p_urlConnection, OutputStream p_out) throws ExceptionFire {
        block26: {
            block25: {
                isSource = null;
                bis = null;
                bos = null;
                buff = null;
                if (p_out == null) {
                    throw new ExceptionFire(10, "\u6ca1\u6709\u6307\u5b9a\u76ee\u6807\u8f93\u51fa\u6d41", String.valueOf(HttpRequester.CLASS_NAME) + ".readToStream");
                }
                try {
                    isSource = p_urlConnection.getInputStream();
                }
                catch (Exception ex) {
                    if (isSource == null) throw new ExceptionFire(111, "\u6253\u5f00\u6570\u636e\u8f93\u5165\u6d41\u5931\u8d25", String.valueOf(HttpRequester.CLASS_NAME) + ".readToStream", ex);
                    try {
                        isSource.close();
                        throw new ExceptionFire(111, "\u6253\u5f00\u6570\u636e\u8f93\u5165\u6d41\u5931\u8d25", String.valueOf(HttpRequester.CLASS_NAME) + ".readToStream", ex);
                    }
                    catch (Exception var8_8) {
                        // empty catch block
                    }
                    throw new ExceptionFire(111, "\u6253\u5f00\u6570\u636e\u8f93\u5165\u6d41\u5931\u8d25", String.valueOf(HttpRequester.CLASS_NAME) + ".readToStream", ex);
                }
                try {
                    try {
                        bis = new BufferedInputStream(isSource);
                        bos = new BufferedOutputStream(p_out);
                        buff = new byte[2048];
                        while ((nLen = bis.read(buff, 0, buff.length)) != -1) {
                            bos.write(buff, 0, nLen);
                        }
                    }
                    catch (Exception ex) {
                        throw new ExceptionFire(50, "\u8bfb\u53d6\u5e76\u8f93\u51fa\u6570\u636e\u6d41\u5931\u8d25", String.valueOf(HttpRequester.CLASS_NAME) + ".readToStream", ex);
                    }
                }
                catch (Throwable var9_12) {
                    var8_9 = null;
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (Exception var10_13) {
                            // empty catch block
                        }
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Exception var10_13) {
                            // empty catch block
                        }
                    }
                    try {
                        isSource.close();
                        throw var9_12;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw var9_12;
                }
                {
                    var8_10 = null;
                    if (bos == null) break block25;
                }
                ** try [egrp 4[TRYBLOCK] [5 : 225->233)] { 
lbl55:
                // 1 sources

                bos.close();
                break block25;
lbl57:
                // 1 sources

                catch (Exception var10_14) {
                    // empty catch block
                }
            }
            if (bis != null) {
                ** try [egrp 5[TRYBLOCK] [6 : 239->246)] { 
lbl62:
                // 1 sources

                bis.close();
                break block26;
lbl64:
                // 1 sources

                catch (Exception var10_14) {
                    // empty catch block
                }
            }
        }
        try {}
        catch (Exception ex) {
            return;
        }
        isSource.close();
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 148->152)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

