/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ckm.soap;

import com.trs.ckm.soap.ObjectPool;
import com.trs.ckm.soap.TrsCkmSoapClient;

public class ConnectionPool {
    private ObjectPool objPool;
    private int nPoolSize;
    private String sHost;
    private String sUserName;
    private String sPassword;

    public ConnectionPool() {
        this(null, null, null, 8);
    }

    public ConnectionPool(String _sHost, String _sUserName, String _sPassword, int _nPoolSize) {
        this.nPoolSize = _nPoolSize;
        this.sHost = _sHost;
        this.sUserName = _sUserName;
        this.sPassword = _sPassword;
        if (this.nPoolSize <= 0 || this.nPoolSize > 64) {
            this.nPoolSize = 8;
        }
        try {
            this.objPool = new ObjectPool("com.trs.ckm.soap.TrsCkmSoapClient", 4, this.nPoolSize);
        }
        catch (Exception ex) {
            this.objPool = null;
        }
    }

    public synchronized TrsCkmSoapClient GetConnection() {
        TrsCkmSoapClient _objClient = null;
        if (this.objPool == null) {
            return null;
        }
        try {
            _objClient = (TrsCkmSoapClient)this.objPool.GetObject();
            _objClient.SetServer(this.sHost, this.sUserName, this.sPassword);
            _objClient.SetKeepAlive(true);
        }
        catch (Exception ex) {
            _objClient = null;
        }
        return _objClient;
    }

    public synchronized void ReturnConnection(TrsCkmSoapClient _objClient) {
        this.objPool.FreeObject(_objClient);
    }

    public synchronized int GetConnectionCount() {
        return this.objPool.GetBusyObjectsCount();
    }
}

