/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.tools;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlmiddleware.db.JDBC1DataSource;
import org.xmlmiddleware.db.JDBC2DataSource;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.DBMSDelete;
import org.xmlmiddleware.xmldbms.DBMSToDOM;
import org.xmlmiddleware.xmldbms.DOMToDBMS;
import org.xmlmiddleware.xmldbms.TransferInfo;
import org.xmlmiddleware.xmldbms.actions.ActionCompiler;
import org.xmlmiddleware.xmldbms.actions.Actions;
import org.xmlmiddleware.xmldbms.datahandlers.DataHandler;
import org.xmlmiddleware.xmldbms.filters.FilterCompiler;
import org.xmlmiddleware.xmldbms.filters.FilterSerializer;
import org.xmlmiddleware.xmldbms.filters.FilterSet;
import org.xmlmiddleware.xmldbms.keygenerators.KeyGenerator;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmldbms.maps.factories.MapCompiler;
import org.xmlmiddleware.xmldbms.tools.PropertyProcessor;
import org.xmlmiddleware.xmldbms.tools.XMLDBMSProps;
import org.xmlmiddleware.xmlutils.ParserUtils;

public class Transfer
extends PropertyProcessor {
    ParserUtils utils;
    Hashtable fileObjects = new Hashtable();
    Hashtable keyGenerators = new Hashtable();
    Hashtable transferInfos = new Hashtable();
    Hashtable dbInfos = new Hashtable();
    Hashtable dataHandlers = new Hashtable();
    Vector conns = new Vector();
    DOMToDBMS domToDBMS;
    DBMSToDOM dbmsToDOM;
    DBMSDelete dbmsDelete;
    private static String GENERICHANDLER = "org.xmlmiddleware.xmldbms.datahandlers.GenericHandler";
    private static String JDBC1DATASOURCE = "org.xmlmiddleware.db.JDBC1DataSource";
    private static String JDBC2DATASOURCE = "org.xmlmiddleware.db.JDBC2DataSource";
    private static String DEFAULT = "Default";
    private static String YES = "YES";

    private Transfer() {
        this.setFinalizers();
    }

    public Transfer(Properties properties) throws XMLMiddlewareException {
        this.setParserUtils(properties);
        this.setFinalizers();
    }

    public Transfer(ParserUtils parserUtils) {
        if (parserUtils == null) {
            throw new IllegalArgumentException("utils argument must not be null.");
        }
        this.utils = parserUtils;
        this.setFinalizers();
    }

    public static void main(String[] stringArray) {
        Transfer transfer = new Transfer();
        Properties properties = new Properties();
        if (stringArray.length < 1) {
            System.out.println("Usage: java Transfer <property>=<value> [<property>=<value>...]\n\nSee the documentation for a list of valid properties.");
            return;
        }
        try {
            transfer.addPropertiesFromArray(properties, stringArray, 0, true);
            transfer.setParserUtils(properties);
            transfer.dispatch(properties);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setDatabaseProperties(Properties properties) throws XMLMiddlewareException, SQLException {
        this.transferInfos.clear();
        this.dbInfos.clear();
        this.dataHandlers.clear();
        this.conns.removeAllElements();
        System.gc();
        if (properties.getProperty(XMLDBMSProps.DATASOURCECLASS) != null) {
            this.configSingleDatabase(properties);
            return;
        }
        this.configMultipleDatabases(properties);
    }

    public void dispatch(Properties properties) throws XMLMiddlewareException, SQLException {
        this.setDatabaseProperties(properties);
        String string = properties.getProperty(XMLDBMSProps.METHOD);
        if (string == null) {
            throw new IllegalArgumentException(String.valueOf(XMLDBMSProps.METHOD) + " property not specified.");
        }
        if (string.equals(XMLDBMSProps.STOREDOCUMENT)) {
            this.dispatchStoreDocument(properties);
            return;
        }
        if (string.equals(XMLDBMSProps.RETRIEVEDOCUMENTBYSQL)) {
            this.dispatchRetrieveDocumentBySQL(properties);
            return;
        }
        if (string.equals(XMLDBMSProps.RETRIEVEDOCUMENTBYFILTER)) {
            this.dispatchRetrieveDocumentByFilter(properties);
            return;
        }
        if (string.equals(XMLDBMSProps.DELETEDOCUMENT)) {
            this.dispatchDeleteDocument(properties);
            return;
        }
        throw new IllegalArgumentException("Unknown value of the " + XMLDBMSProps.METHOD + " property: " + string);
    }

    public FilterSet storeDocument(Properties properties, String string, String string2, String string3) throws XMLMiddlewareException, SQLException {
        InputSource inputSource;
        try {
            inputSource = new InputSource(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new XMLMiddlewareException(fileNotFoundException);
        }
        return this.storeDocumentInternal(properties, string2, string3, inputSource);
    }

    public FilterSet storeDocument(String string, Properties properties, String string2, String string3) throws XMLMiddlewareException, SQLException {
        InputSource inputSource = new InputSource(new StringReader(string));
        return this.storeDocumentInternal(properties, string2, string3, inputSource);
    }

    public FilterSet storeDocument(Properties properties, String string, String string2, InputStream inputStream) throws XMLMiddlewareException, SQLException {
        InputSource inputSource = new InputSource(inputStream);
        return this.storeDocumentInternal(properties, string, string2, inputSource);
    }

    public String retrieveDocument(Properties properties, String string, String string2, Hashtable hashtable) throws XMLMiddlewareException, SQLException {
        Document document = this.retrieveDocumentInternal(properties, string, string2, hashtable);
        return this.utils.writeDocument(document);
    }

    public void retrieveDocument(Properties properties, String string, String string2, Hashtable hashtable, String string3) throws XMLMiddlewareException, SQLException {
        String string4 = null;
        if (properties != null) {
            string4 = properties.getProperty(XMLDBMSProps.ENCODING);
        }
        Document document = this.retrieveDocumentInternal(properties, string, string2, hashtable);
        this.utils.writeDocument(document, string3, string4);
    }

    public String retrieveDocument(Properties properties, String string, Properties properties2, String string2, Hashtable hashtable) throws XMLMiddlewareException, SQLException {
        Document document = this.retrieveDocumentInternal(properties, string, properties2, string2, hashtable);
        return this.utils.writeDocument(document);
    }

    public void retrieveDocument(Properties properties, String string, Properties properties2, String string2, Hashtable hashtable, String string3) throws XMLMiddlewareException, SQLException {
        String string4 = null;
        if (properties != null) {
            string4 = properties.getProperty(XMLDBMSProps.ENCODING);
        }
        Document document = this.retrieveDocumentInternal(properties, string, properties2, string2, hashtable);
        this.utils.writeDocument(document, string3, string4);
    }

    public void deleteDocument(Properties properties, String string, String string2, String string3, Hashtable hashtable) throws XMLMiddlewareException, SQLException {
        String string4 = " " + properties.getProperty(XMLDBMSProps.VALIDATE) + " ";
        XMLDBMSMap xMLDBMSMap = this.createMap(string, string4.indexOf(XMLDBMSProps.MAPTOKEN) != -1);
        TransferInfo transferInfo = this.createTransferInfo(xMLDBMSMap);
        Actions actions = this.createActions(xMLDBMSMap, string2, string4.indexOf(XMLDBMSProps.ACTIONTOKEN) != -1);
        FilterSet filterSet = this.createFilterSet(xMLDBMSMap, string3, string4.indexOf(XMLDBMSProps.FILTERTOKEN) != -1);
        this.configDBMSDelete(properties);
        this.dbmsDelete.deleteDocument(transferInfo, filterSet, hashtable, actions);
    }

    private void dispatchStoreDocument(Properties properties) throws XMLMiddlewareException, SQLException {
        String string = this.getProperty(properties, XMLDBMSProps.MAPFILE);
        String string2 = this.getProperty(properties, XMLDBMSProps.ACTIONFILE);
        String string3 = this.getProperty(properties, XMLDBMSProps.XMLFILE);
        FilterSet filterSet = this.storeDocument(properties, string3, string, string2);
        if (filterSet != null) {
            this.writeFilterSet(properties, filterSet);
        }
    }

    private void writeFilterSet(Properties properties, FilterSet filterSet) throws XMLMiddlewareException {
        try {
            OutputStreamWriter outputStreamWriter;
            String string = properties.getProperty(XMLDBMSProps.FILTERFILE);
            if (string == null) {
                return;
            }
            String string2 = properties.getProperty(XMLDBMSProps.ENCODING);
            if (string2 == null) {
                outputStreamWriter = new FileWriter(string);
            } else {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            }
            String string3 = properties.getProperty(XMLDBMSProps.SYSTEMID);
            String string4 = properties.getProperty(XMLDBMSProps.PUBLICID);
            FilterSerializer filterSerializer = new FilterSerializer(outputStreamWriter);
            filterSerializer.setPrettyPrinting(true, 3);
            if (string3 == null) {
                filterSerializer.serialize(filterSet);
            } else {
                filterSerializer.serialize(filterSet, string3, string4);
            }
            ((Writer)outputStreamWriter).close();
            return;
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(exception);
        }
    }

    private void dispatchRetrieveDocumentByFilter(Properties properties) throws XMLMiddlewareException, SQLException {
        Properties properties2 = properties;
        Properties properties3 = properties;
        String string = this.getProperty(properties, XMLDBMSProps.MAPFILE);
        String string2 = this.getProperty(properties, XMLDBMSProps.FILTERFILE);
        String string3 = this.getProperty(properties, XMLDBMSProps.XMLFILE);
        this.retrieveDocument(properties2, string, string2, properties3, string3);
    }

    private void dispatchRetrieveDocumentBySQL(Properties properties) throws XMLMiddlewareException, SQLException {
        Properties properties2 = properties;
        Properties properties3 = properties;
        Properties properties4 = properties;
        String string = this.getProperty(properties, XMLDBMSProps.MAPFILE);
        String string2 = this.getProperty(properties, XMLDBMSProps.FILTERFILE);
        String string3 = this.getProperty(properties, XMLDBMSProps.XMLFILE);
        this.retrieveDocument(properties2, string, properties3, string2, properties4, string3);
    }

    private void dispatchDeleteDocument(Properties properties) throws XMLMiddlewareException, SQLException {
        String string = this.getProperty(properties, XMLDBMSProps.MAPFILE);
        String string2 = this.getProperty(properties, XMLDBMSProps.ACTIONFILE);
        String string3 = this.getProperty(properties, XMLDBMSProps.FILTERFILE);
        this.deleteDocument(properties, string, string2, string3, properties);
    }

    private FilterSet storeDocumentInternal(Properties properties, String string, String string2, InputSource inputSource) throws XMLMiddlewareException, SQLException {
        String string3 = " " + properties.getProperty(XMLDBMSProps.VALIDATE) + " ";
        XMLDBMSMap xMLDBMSMap = this.createMap(string, string3.indexOf(XMLDBMSProps.MAPTOKEN) != -1);
        TransferInfo transferInfo = this.createTransferInfo(xMLDBMSMap);
        Actions actions = this.createActions(xMLDBMSMap, string2, string3.indexOf(XMLDBMSProps.ACTIONTOKEN) != -1);
        this.configDOMToDBMS(properties);
        Document document = this.utils.openDocument(inputSource, string3.indexOf(XMLDBMSProps.XMLTOKEN) != -1);
        return this.domToDBMS.storeDocument(transferInfo, document, actions);
    }

    private Document retrieveDocumentInternal(Properties properties, String string, String string2, Hashtable hashtable) throws XMLMiddlewareException, SQLException {
        String string3 = " " + properties.getProperty(XMLDBMSProps.VALIDATE) + " ";
        XMLDBMSMap xMLDBMSMap = this.createMap(string, string3.indexOf(XMLDBMSProps.MAPTOKEN) != -1);
        TransferInfo transferInfo = this.createTransferInfo(xMLDBMSMap);
        FilterSet filterSet = this.createFilterSet(xMLDBMSMap, string2, string3.indexOf(XMLDBMSProps.FILTERTOKEN) != -1);
        this.configDBMSToDOM(properties);
        return this.dbmsToDOM.retrieveDocument(transferInfo, filterSet, hashtable, null);
    }

    private Document retrieveDocumentInternal(Properties properties, String string, Properties properties2, String string2, Hashtable hashtable) throws XMLMiddlewareException, SQLException {
        String string3 = " " + properties.getProperty(XMLDBMSProps.VALIDATE) + " ";
        XMLDBMSMap xMLDBMSMap = this.createMap(string, string3.indexOf(XMLDBMSProps.MAPTOKEN) != -1);
        Hashtable hashtable2 = this.createResultSets(properties2);
        TransferInfo transferInfo = this.createTransferInfo(xMLDBMSMap);
        FilterSet filterSet = this.createFilterSet(xMLDBMSMap, string2, string3.indexOf(XMLDBMSProps.FILTERTOKEN) != -1);
        this.configDBMSToDOM(properties);
        Document document = this.dbmsToDOM.retrieveDocument(transferInfo, hashtable2, filterSet, hashtable, null);
        this.closeResultSets(hashtable2);
        this.closeConnections();
        return document;
    }

    private void setParserUtils(Properties properties) throws XMLMiddlewareException {
        String string = properties.getProperty(XMLDBMSProps.PARSERUTILSCLASS);
        if (string == null) {
            throw new IllegalArgumentException("Properties object must contain " + XMLDBMSProps.PARSERUTILSCLASS + " property.");
        }
        this.utils = (ParserUtils)this.instantiateObject(string);
    }

    private void configSingleDatabase(Properties properties) throws XMLMiddlewareException, SQLException {
        String string = properties.getProperty(XMLDBMSProps.DBNAME);
        if (string == null) {
            string = DEFAULT;
        }
        DBInfo dBInfo = new DBInfo();
        this.dbInfos.put(string, dBInfo);
        String string2 = properties.getProperty(XMLDBMSProps.DATASOURCECLASS);
        dBInfo.dataSource = this.createDataSource(string, string2, properties, 0);
        dBInfo.user = properties.getProperty(XMLDBMSProps.USER);
        dBInfo.password = properties.getProperty(XMLDBMSProps.PASSWORD);
        String string3 = properties.getProperty(XMLDBMSProps.DATAHANDLERCLASS);
        this.createDataHandler(string, string3, dBInfo);
    }

    private void configMultipleDatabases(Properties properties) throws XMLMiddlewareException, SQLException {
        String[] stringArray = this.getNumberedProps(XMLDBMSProps.DBNAME, properties);
        String[] stringArray2 = this.getNumberedProps(XMLDBMSProps.DATASOURCECLASS, properties);
        String[] stringArray3 = this.getNumberedProps(XMLDBMSProps.DATAHANDLERCLASS, properties);
        String[] stringArray4 = this.getNumberedProps(XMLDBMSProps.USER, properties);
        String[] stringArray5 = this.getNumberedProps(XMLDBMSProps.PASSWORD, properties);
        if (stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("You must specify a single DataSourceClass property, or one or more DBName1 (2, 3, ...) and DataSourceClass1 (2, 3, ...) properties.");
        }
        try {
            int n = 0;
            while (n < stringArray2.length) {
                DBInfo dBInfo = new DBInfo();
                this.dbInfos.put(stringArray[n], dBInfo);
                dBInfo.dataSource = this.createDataSource(stringArray[n], stringArray2[n], properties, n);
                dBInfo.user = stringArray4 == null ? null : stringArray4[n];
                dBInfo.password = stringArray5 == null ? null : stringArray5[n];
                String string = stringArray3 == null ? null : stringArray3[n];
                this.createDataHandler(stringArray[n], string, dBInfo);
                ++n;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XMLMiddlewareException("If you specify them, you must have the same number of " + XMLDBMSProps.DBNAME + ", " + XMLDBMSProps.DATASOURCECLASS + ", " + XMLDBMSProps.DATAHANDLERCLASS + ", " + XMLDBMSProps.USER + ", and " + XMLDBMSProps.PASSWORD + " properties.");
        }
    }

    private void configDBMSToDOM(Properties properties) throws XMLMiddlewareException {
        String string = null;
        String string2 = null;
        try {
            if (this.dbmsToDOM == null) {
                this.dbmsToDOM = new DBMSToDOM(this.utils);
            }
        }
        catch (SAXException sAXException) {
            this.processSAXException(sAXException);
        }
        if (properties != null) {
            string = properties.getProperty(XMLDBMSProps.SYSTEMID);
            string2 = properties.getProperty(XMLDBMSProps.PUBLICID);
        }
        this.dbmsToDOM.setDTDInfo(string, string2);
    }

    private void configDOMToDBMS(Properties properties) throws XMLMiddlewareException {
        int n = 1;
        boolean bl = true;
        boolean bl2 = false;
        if (this.domToDBMS == null) {
            this.domToDBMS = new DOMToDBMS();
        }
        this.addKeyGenerators(properties);
        if (properties != null) {
            String string = properties.getProperty(XMLDBMSProps.COMMITMODE);
            if (string != null) {
                n = this.getCommitMode(string);
            }
            if ((string = properties.getProperty(XMLDBMSProps.STOPONERROR)) != null) {
                bl = this.isYes(string);
            }
            if ((string = properties.getProperty(XMLDBMSProps.RETURNFILTER)) != null) {
                bl2 = this.isYes(string);
            }
        }
        this.domToDBMS.setCommitMode(n);
        this.domToDBMS.stopOnException(bl);
        this.domToDBMS.setFilterSetReturned(bl2);
    }

    private void configDBMSDelete(Properties properties) {
        String string;
        int n = 1;
        if (this.dbmsDelete == null) {
            this.dbmsDelete = new DBMSDelete();
        }
        if (properties != null && (string = properties.getProperty(XMLDBMSProps.COMMITMODE)) != null) {
            n = this.getCommitMode(string);
        }
        this.dbmsDelete.setCommitMode(n);
    }

    private void addKeyGenerators(Properties properties) throws XMLMiddlewareException {
        this.domToDBMS.removeAllKeyGenerators();
        if (properties == null) {
            return;
        }
        if (properties.getProperty(XMLDBMSProps.KEYGENERATORNAME) != null) {
            this.addSingleKeyGenerator(properties);
            return;
        }
        this.addMultipleKeyGenerators(properties);
    }

    private void addSingleKeyGenerator(Properties properties) throws XMLMiddlewareException {
        String string = properties.getProperty(XMLDBMSProps.KEYGENERATORNAME);
        String string2 = properties.getProperty(XMLDBMSProps.KEYGENERATORCLASS);
        KeyGenerator keyGenerator = this.createKeyGenerator(string, string2, properties);
        this.domToDBMS.addKeyGenerator(string, keyGenerator);
    }

    private void addMultipleKeyGenerators(Properties properties) throws XMLMiddlewareException {
        String[] stringArray = this.getNumberedProps(XMLDBMSProps.KEYGENERATORNAME, properties);
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = this.getNumberedProps(XMLDBMSProps.KEYGENERATORCLASS, properties);
        try {
            if (stringArray2 == null) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n = 0;
            while (n < stringArray.length) {
                KeyGenerator keyGenerator = this.createKeyGenerator(stringArray[n], stringArray2[n], properties);
                this.domToDBMS.addKeyGenerator(stringArray[n], keyGenerator);
                ++n;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XMLMiddlewareException("The number of " + XMLDBMSProps.KEYGENERATORNAME + " properties must match the number of " + XMLDBMSProps.KEYGENERATORCLASS + " properties.");
        }
    }

    private DataSource createDataSource(String string, String string2, Properties properties, int n) {
        if (string2 == null) {
            throw new IllegalArgumentException("You must specify a DataSourceClass property");
        }
        DBInfo dBInfo = (DBInfo)this.dbInfos.get(string);
        DataSource dataSource = dBInfo.dataSource;
        if (dataSource == null) {
            if (string2.equals(JDBC1DATASOURCE)) {
                dataSource = this.createJDBC1DataSource(properties, n);
            } else if (string2.equals(JDBC2DATASOURCE)) {
                dataSource = this.createJDBC2DataSource(properties, n);
            } else {
                throw new IllegalArgumentException("The data source class must be org.xmlmiddleware.db.JDBC1DataSource or org.xmlmiddleware.db.JDBC2DataSource.");
            }
        }
        return dataSource;
    }

    private DataSource createJDBC1DataSource(Properties properties, int n) {
        String string = n == 0 ? XMLDBMSProps.DRIVER : String.valueOf(XMLDBMSProps.DRIVER) + n;
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            throw new IllegalArgumentException("You must specify the driver when using a JDBC1DataSource.");
        }
        string = n == 0 ? XMLDBMSProps.URL : String.valueOf(XMLDBMSProps.URL) + n;
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            throw new IllegalArgumentException("You must specify the URL when using a JDBC1DataSource.");
        }
        return new JDBC1DataSource(string2, string3);
    }

    private DataSource createJDBC2DataSource(Properties properties, int n) {
        String string = n == 0 ? XMLDBMSProps.JNDICONTEXT : String.valueOf(XMLDBMSProps.JNDICONTEXT) + n;
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            throw new IllegalArgumentException("You must specify the JNDI context when using a JDBC2DataSource.");
        }
        string = n == 0 ? XMLDBMSProps.JNDILOOKUPNAME : String.valueOf(XMLDBMSProps.JNDILOOKUPNAME) + n;
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            throw new IllegalArgumentException("You must specify the JNDI lookup name of the data source when using a JDBC2DataSource.");
        }
        return new JDBC2DataSource(string2, string3);
    }

    private void createDataHandler(String string, String string2, DBInfo dBInfo) throws XMLMiddlewareException, SQLException {
        if (string2 == null) {
            string2 = GENERICHANDLER;
        }
        DataHandler dataHandler = (DataHandler)this.instantiateObject(string2);
        dataHandler.initialize(dBInfo.dataSource, dBInfo.user, dBInfo.password);
        this.dataHandlers.put(string, dataHandler);
    }

    private Hashtable createResultSets(Properties properties) throws XMLMiddlewareException, SQLException {
        if (properties == null) {
            throw new IllegalArgumentException("You must specify one or more Select properties when retrieving data from a result set.");
        }
        if (properties.getProperty(XMLDBMSProps.SELECT) != null) {
            return this.createSingleResultSet(properties);
        }
        return this.createMultipleResultSets(properties);
    }

    private Hashtable createSingleResultSet(Properties properties) throws XMLMiddlewareException, SQLException {
        DBInfo dBInfo;
        String string;
        Hashtable<String, ResultSet> hashtable = new Hashtable<String, ResultSet>();
        String string2 = properties.getProperty(XMLDBMSProps.SELECT);
        String string3 = properties.getProperty(XMLDBMSProps.SELECTRESULTSETNAME);
        if (string3 == null) {
            string3 = DEFAULT;
        }
        if ((string = properties.getProperty(XMLDBMSProps.SELECTDBNAME)) == null) {
            string = DEFAULT;
        }
        if ((dBInfo = (DBInfo)this.dbInfos.get(string)) == null) {
            throw new IllegalArgumentException("No data source information specified for the " + string + " database.");
        }
        Connection connection = dBInfo.dataSource.getConnection(dBInfo.user, dBInfo.password);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        hashtable.put(string3, resultSet);
        this.conns.addElement(connection);
        return hashtable;
    }

    private Hashtable createMultipleResultSets(Properties properties) throws XMLMiddlewareException, SQLException {
        Hashtable<String, ResultSet> hashtable = new Hashtable<String, ResultSet>();
        String[] stringArray = this.getNumberedProps(XMLDBMSProps.SELECT, properties);
        if (stringArray == null) {
            throw new IllegalArgumentException("You must specify one or more SELECT statements when retrieving data from a result set.");
        }
        String[] stringArray2 = this.getNumberedProps(XMLDBMSProps.SELECTRESULTSETNAME, properties);
        if (stringArray2 == null) {
            throw new IllegalArgumentException("You must specify the names of the result sets created from the SELECT statements. These must match the names of the result sets in the filter document.");
        }
        if (stringArray2.length != stringArray.length) {
            throw new IllegalArgumentException("There must be the same number of " + XMLDBMSProps.SELECTRESULTSETNAME + " properties as " + XMLDBMSProps.SELECT + " properties.");
        }
        String[] stringArray3 = this.getNumberedProps(XMLDBMSProps.SELECTDBNAME, properties);
        if (stringArray3 != null && stringArray3.length != stringArray.length) {
            throw new IllegalArgumentException("There must be the same number of " + XMLDBMSProps.SELECTDBNAME + " properties as " + XMLDBMSProps.SELECT + " properties.");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray3 == null ? DEFAULT : stringArray3[n];
            DBInfo dBInfo = (DBInfo)this.dbInfos.get(string);
            if (dBInfo == null) {
                throw new IllegalArgumentException("No data source information specified for the " + string + " database.");
            }
            Connection connection = dBInfo.dataSource.getConnection(dBInfo.user, dBInfo.password);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(stringArray[n]);
            hashtable.put(stringArray2[n], resultSet);
            this.conns.addElement(connection);
            ++n;
        }
        return hashtable;
    }

    private void closeResultSets(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ResultSet resultSet = (ResultSet)enumeration.nextElement();
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private void closeConnections() {
        int n = 0;
        while (n < this.conns.size()) {
            Connection connection = (Connection)this.conns.elementAt(n);
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
            ++n;
        }
    }

    private TransferInfo createTransferInfo(XMLDBMSMap xMLDBMSMap) {
        TransferInfo transferInfo = (TransferInfo)this.transferInfos.get(xMLDBMSMap);
        if (transferInfo == null) {
            transferInfo = new TransferInfo(xMLDBMSMap);
            this.transferInfos.put(xMLDBMSMap, transferInfo);
            Enumeration enumeration = this.dataHandlers.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                DataHandler dataHandler = (DataHandler)this.dataHandlers.get(string);
                transferInfo.addDataHandler(string, dataHandler);
            }
        }
        return transferInfo;
    }

    private KeyGenerator createKeyGenerator(String string, String string2, Properties properties) throws XMLMiddlewareException {
        KeyGenerator keyGenerator = (KeyGenerator)this.keyGenerators.get(string);
        if (keyGenerator == null) {
            keyGenerator = (KeyGenerator)this.instantiateObject(string2);
            keyGenerator.initialize(properties);
            this.keyGenerators.put(string, keyGenerator);
        }
        return keyGenerator;
    }

    private XMLDBMSMap createMap(String string, boolean bl) throws XMLMiddlewareException {
        MapCompiler mapCompiler = null;
        XMLDBMSMap xMLDBMSMap = (XMLDBMSMap)this.fileObjects.get(string);
        if (xMLDBMSMap == null) {
            try {
                mapCompiler = new MapCompiler(this.utils.getXMLReader(bl));
                xMLDBMSMap = mapCompiler.compile(new InputSource(new FileReader(string)));
            }
            catch (SAXException sAXException) {
                this.processSAXException(sAXException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLMiddlewareException(fileNotFoundException);
            }
            this.fileObjects.put(string, xMLDBMSMap);
        }
        return xMLDBMSMap;
    }

    private Actions createActions(XMLDBMSMap xMLDBMSMap, String string, boolean bl) throws XMLMiddlewareException {
        ActionCompiler actionCompiler = null;
        Actions actions = (Actions)this.fileObjects.get(string);
        if (actions == null) {
            try {
                actionCompiler = new ActionCompiler(this.utils.getXMLReader(bl));
                actions = actionCompiler.compile(xMLDBMSMap, new InputSource(new FileReader(string)));
            }
            catch (SAXException sAXException) {
                this.processSAXException(sAXException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLMiddlewareException(fileNotFoundException);
            }
            this.fileObjects.put(string, actions);
        }
        return actions;
    }

    private FilterSet createFilterSet(XMLDBMSMap xMLDBMSMap, String string, boolean bl) throws XMLMiddlewareException {
        FilterCompiler filterCompiler = null;
        FilterSet filterSet = (FilterSet)this.fileObjects.get(string);
        if (filterSet == null) {
            try {
                filterCompiler = new FilterCompiler(this.utils.getXMLReader(bl));
                filterSet = filterCompiler.compile(xMLDBMSMap, new InputSource(new FileReader(string)));
            }
            catch (SAXException sAXException) {
                this.processSAXException(sAXException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLMiddlewareException(fileNotFoundException);
            }
            this.fileObjects.put(string, filterSet);
        }
        return filterSet;
    }

    private String getProperty(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Invalid call. The " + string + " property must be set when executing the " + properties.getProperty(XMLDBMSProps.METHOD) + " method.");
        }
        return string2;
    }

    private int getCommitMode(String string) {
        if (string.equals(XMLDBMSProps.AFTERSTATEMENT)) {
            return 1;
        }
        if (string.equals(XMLDBMSProps.AFTERDOCUMENT)) {
            return 2;
        }
        if (string.equals(XMLDBMSProps.NONE)) {
            return 3;
        }
        if (string.equals(XMLDBMSProps.NOTRANSACTIONS)) {
            return 4;
        }
        throw new IllegalArgumentException("Invalid commit mode value: " + string);
    }

    private boolean isYes(String string) {
        return string.toUpperCase().equals(YES);
    }

    private void setFinalizers() {
        System.runFinalizersOnExit((boolean)true);
    }

    private Object instantiateObject(String string) throws XMLMiddlewareException {
        try {
            return Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
        }
    }

    private void processSAXException(SAXException sAXException) throws XMLMiddlewareException {
        Exception exception = sAXException.getException();
        if (exception != null) {
            if (exception instanceof XMLMiddlewareException) {
                throw (XMLMiddlewareException)exception;
            }
            throw new XMLMiddlewareException(exception);
        }
        throw new XMLMiddlewareException(sAXException);
    }

    private class DBInfo {
        DataSource dataSource;
        String user;
        String password;

        DBInfo() {
            Transfer.this = Transfer.this;
        }
    }
}

