/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.DebugTimer;
import com.trsupdate.InheritInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WCM52InheritRight2WCM65Updater {
    private RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
    private List m_listInheritInfo = null;
    private static Logger logger = Logger.getLogger(WCM52InheritRight2WCM65Updater.class);
    private User m_oUser = null;
    private boolean m_bInsertDB = true;

    public WCM52InheritRight2WCM65Updater(List _listInheritInfo) {
        this.m_listInheritInfo = _listInheritInfo;
    }

    public List update() throws WCMException {
        logger.warn((Object)"The system begin to create rights.....");
        this.m_oUser = User.findByName("admin");
        ArrayList arNewRightList = new ArrayList();
        DebugTimer allTimer = new DebugTimer();
        allTimer.start();
        DebugTimer timer = new DebugTimer();
        int nSize = this.m_listInheritInfo.size();
        for (int i = 0; i < nSize; ++i) {
            InheritInfo oInheritInfo = (InheritInfo)this.m_listInheritInfo.get(i);
            Users users = oInheritInfo.getUsers();
            timer.start();
            Roles oCurrRelateRoles = new Roles(null);
            Groups oCurrRelateGroups = new Groups(null);
            int nUserCount = users.size();
            for (int nUserIndex = 0; nUserIndex < nUserCount; ++nUserIndex) {
                User user = (User)users.getAt(nUserIndex);
                this.makeInheritRights(user, oInheritInfo.getChannel(), arNewRightList, oCurrRelateRoles, oCurrRelateGroups);
            }
            timer.stop();
        }
        allTimer.stop();
        logger.warn((Object)("The system end to create rights!use[" + allTimer.getTime() + "]ms"));
        return arNewRightList;
    }

    private List makeInheritRights(User _currUser, Channel _currChannel, List _arNewRights, Roles _oRelateRolesOnCurrChannel, Groups _oRelateGroupsOnCurrChannel) throws WCMException {
        Groups groups = _currUser.getGroups();
        Roles roles = _currUser.getRoles();
        boolean bFindInherintRight = false;
        for (BaseChannel parent = _currChannel.getHost(); parent != null; parent = parent.getHost()) {
            Right right;
            long lRightValue = this.makeRightValue(parent, _currUser);
            if (lRightValue != -1L) {
                Right right2 = new Right();
                right2.setValue(lRightValue);
                right2.setOperator(_currUser);
                this.saveRight(right2, _currChannel);
                _arNewRights.add(right2);
                return _arNewRights;
            }
            int nGroupSize = groups.size();
            for (int nGroupIndex = 0; nGroupIndex < nGroupSize; ++nGroupIndex) {
                Group group = (Group)groups.getAt(nGroupIndex);
                lRightValue = this.makeRightValue(parent, group);
                if (lRightValue == -1L) continue;
                bFindInherintRight = true;
                if (_oRelateGroupsOnCurrChannel.indexOf(group) >= 0) continue;
                _oRelateGroupsOnCurrChannel.addElement(group);
                right = new Right();
                right.setValue(lRightValue);
                right.setOperator(group);
                this.saveRight(right, _currChannel);
                _arNewRights.add(right);
            }
            int nRoleSize = roles.size();
            for (int nRoleIndex = 0; nRoleIndex < nRoleSize; ++nRoleIndex) {
                Role role = (Role)roles.getAt(nRoleIndex);
                lRightValue = this.makeRightValue(parent, role);
                if (lRightValue == -1L) continue;
                bFindInherintRight = true;
                if (_oRelateRolesOnCurrChannel.indexOf(role) >= 0) continue;
                _oRelateRolesOnCurrChannel.addElement(role);
                right = new Right();
                right.setValue(lRightValue);
                right.setOperator(role);
                this.saveRight(right, _currChannel);
                _arNewRights.add(right);
            }
            if (!bFindInherintRight) continue;
            return _arNewRights;
        }
        throw new WCMException("\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0d\u53ef\u80fd\u6ca1\u6709\u4efb\u4f55\u7ee7\u627f\u7684\u6743\u9650\uff01User=[" + _currUser + "] Channel=[" + _currChannel + "]");
    }

    private void saveRight(Right _right, Channel _currChannel) throws WCMException {
        if (this.m_bInsertDB) {
            try {
                _right.setObject(101, _currChannel.getId());
                _right.insert(this.m_oUser);
            }
            catch (Exception e) {
                logger.error((Object)("Error to save right![ChannelId=" + _currChannel.getId() + "][OprType" + _right.getOperatorType() + ", OprId=" + _right.getOperatorId() + "]"), (Throwable)e);
            }
        }
    }

    private long makeRightValue(BaseChannel _parent, CMSObj _currOperator) throws WCMException {
        long lRightValue = this.rightCacheMgr.getRightValue(_parent.getWCMType(), _parent.getId(), _currOperator.getWCMType(), _currOperator.getId(), -1L);
        if (lRightValue == -1L) {
            return lRightValue;
        }
        CMyBitsValue oBitsValue = new CMyBitsValue(lRightValue);
        for (int i = 0; i < 11; ++i) {
            oBitsValue.setBit(i, false);
        }
        long lValue = oBitsValue.getValue();
        if (lValue == 0L) {
            return -1L;
        }
        return lValue;
    }
}

