/*
 * Decompiled with CFR 0.152.
 */
package com.trs.weblet.util.verfiycode;

import com.trs.infra.util.store.FileService;
import com.trs.weblet.util.verfiycode.VerifyCode;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VerifyCodeServlet
extends HttpServlet {
    private static final String SYS_VERIFY_DIGIT = "/digit.24x32.bmp";
    private static final long serialVersionUID = 1L;
    private VerifyCode m_oVerifyCode;
    private Random m_oRandomMake;
    private int m_iDigitLimit;

    public void init() throws ServletException {
        String sFileName = this.getDigitImagePath();
        if (sFileName == null) {
            return;
        }
        FileService oImagFile = new FileService(sFileName);
        if (!oImagFile.exists()) {
            return;
        }
        sFileName = oImagFile.getAbsolutePath();
        int iDigitCount = 4;
        int iNoiseLevel = 3;
        this.m_oVerifyCode = new VerifyCode(sFileName, iDigitCount);
        this.m_oVerifyCode.setNoiseLevel(iNoiseLevel);
        if (this.m_oVerifyCode.getErrMessage() != null) {
            this.m_oVerifyCode = null;
            return;
        }
        this.m_iDigitLimit = 1;
        for (int i = 0; i < iDigitCount; ++i) {
            this.m_iDigitLimit *= 10;
        }
        this.m_oRandomMake = new Random(System.currentTimeMillis());
    }

    private String getDigitImagePath() {
        Class<?> clz = ((Object)((Object)this)).getClass();
        URL digit = clz.getResource(SYS_VERIFY_DIGIT);
        if (digit == null) {
            throw new RuntimeException("\u9a8c\u8bc1\u7801\u6240\u9700\u56fe\u7247\u6e90[/digit.24x32.bmp]\u5728\u5f53\u524d\u5e94\u7528\u73af\u5883\u4e0b\u6ca1\u6709\u627e\u5230\uff01");
        }
        String result = digit.getPath();
        return result;
    }

    public void destroy() {
        this.m_iDigitLimit = 10000;
        this.m_oVerifyCode = null;
        this.m_oRandomMake = null;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("P3P", "CP=CAO PSA OUR");
        if (this.m_oVerifyCode == null) {
            resp.setStatus(404);
            return;
        }
        int iVerifyCode = this.makeVerifyNumber();
        req.getSession(true).setAttribute("rand", (Object)String.valueOf(iVerifyCode));
        resp.setContentType("image/bmp");
        resp.setContentLength(this.m_oVerifyCode.getCommonSize());
        resp.setHeader("Cache-control", "no-cache");
        this.m_oVerifyCode.writeImageTo(iVerifyCode, (OutputStream)resp.getOutputStream());
    }

    private int makeVerifyNumber() {
        int iVerifyCode = (this.m_oRandomMake.nextInt() & Integer.MAX_VALUE) % this.m_iDigitLimit;
        if (iVerifyCode < 0) {
            iVerifyCode = 1;
        }
        if (iVerifyCode * 10 < this.m_iDigitLimit) {
            iVerifyCode = this.m_iDigitLimit / 10 + iVerifyCode;
        }
        return iVerifyCode;
    }
}

