/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class WCM61AutoList {
    HashMap mapConfig = new HashMap();
    HashMap mapFilteredConfig = new HashMap();
    String m_sRootPath = "";
    List m_newFiles = new ArrayList();

    public WCM61AutoList(String _sRootPath) {
        this.m_sRootPath = _sRootPath;
    }

    public void loadConfig() {
        String sCfgFileName = this.m_sRootPath + File.separator + "config.txt";
        FileService fileCfg = new FileService(sCfgFileName);
        this.mapConfig = WCM61AutoList.loadProps(fileCfg.getAbsolutePath(), "GBK");
        this.filterConfig();
    }

    private void filterConfig() {
        String sObjClsName = (String)this.mapConfig.get("ObjectClassName");
        String sLongObjClsName = (String)this.mapConfig.get("LongObjectClassName");
        String sObjDesc = (String)this.mapConfig.get("ObjectDesc");
        String sServiceProvider = (String)this.mapConfig.get("ServiceProvider");
        String sOpersUrl = (String)this.mapConfig.get("opersUrl");
        String sTabOrder = this.mapConfig.containsKey("TabOrder") ? (String)this.mapConfig.get("TabOrder") : "100";
        String sMenuOrder = this.mapConfig.containsKey("MenuOrder") ? (String)this.mapConfig.get("MenuOrder") : "100";
        Object listCols = this.mapConfig.get("list_col");
        this.filterItem("xxx", sObjClsName.toLowerCase());
        this.filterItem("$xxx$", sObjClsName.toLowerCase());
        this.filterItem("$Xxx$", sObjClsName);
        this.filterItem("$XXX$", sObjClsName.toUpperCase());
        this.filterItem("$xxxName$", sObjDesc);
        this.filterItem("$xxxObj$", sObjClsName);
        this.filterItem("$xxxObjClass$", sLongObjClsName);
        this.filterItem("$XxxProvider$", sServiceProvider);
        this.filterItem("$taborder$", sTabOrder);
        this.filterItem("$menuorder$", sMenuOrder);
        this.filterItem("opersUrl", sOpersUrl);
        ArrayList list = null;
        if (listCols instanceof String) {
            list = new ArrayList();
            list.add(listCols);
        } else {
            list = (ArrayList)listCols;
        }
        this.mapFilteredConfig.put("list_cols", list);
        for (String key : this.mapConfig.keySet()) {
            this.mapFilteredConfig.put('$' + key + '$', this.mapConfig.get(key));
        }
    }

    private void filterItem(String sKey, String sObjClsName) {
        if (!this.mapConfig.containsKey(sKey)) {
            this.mapFilteredConfig.put(sKey, sObjClsName);
        } else {
            this.mapFilteredConfig.put(sKey, this.mapConfig.get(sKey));
        }
    }

    public static void main(String[] args) {
        String sRootPath = args[0];
        if (args.length > 1) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("-root=")) continue;
                sRootPath = args[i].substring("-root=".length());
                break;
            }
        }
        WCM61AutoList oWCM61AutoList = new WCM61AutoList(sRootPath);
        oWCM61AutoList.loadConfig();
        oWCM61AutoList.makeNewFiles();
        oWCM61AutoList.doOpersJs();
        oWCM61AutoList.replaceStrs();
        boolean bDoQueryJsp = true;
        for (int i = 0; i < args.length; ++i) {
            if (!"-doqueryjsp=false".equalsIgnoreCase(args[i])) continue;
            bDoQueryJsp = false;
            break;
        }
        if (bDoQueryJsp) {
            oWCM61AutoList.doQueryJsp();
        }
    }

    public void makeNewFiles() {
        String sContextPath = this.m_sRootPath + File.separator + "context";
        FileService fileContext = new FileService(sContextPath);
        if (!fileContext.exists() || fileContext.isFile()) {
            return;
        }
        String newContextPath = this.m_sRootPath + File.separator + "build";
        FileStore[] files = fileContext.listFiles();
        FileService buildPath = new FileService(newContextPath);
        for (int i = 0; i < files.length; ++i) {
            this.makeNewFiles(files[i], buildPath);
        }
    }

    private void makeNewFiles(FileStore fileContext, FileStore newPath) {
        if ("CVS".equals(fileContext.getName()) && fileContext.isDirectory()) {
            return;
        }
        String sDestFile = null;
        sDestFile = newPath.getAbsolutePath() + File.separator + fileContext.getName().replaceAll("xxx", (String)this.mapFilteredConfig.get("xxx"));
        if (fileContext.isFile()) {
            WCM61AutoList.copyFile(fileContext.getAbsolutePath(), sDestFile);
            this.m_newFiles.add(sDestFile);
            return;
        }
        FileService destPath = new FileService(sDestFile);
        if (!destPath.exists()) {
            destPath.mkdirs();
        }
        FileStore[] files = fileContext.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.makeNewFiles(files[i], destPath);
        }
    }

    public void doOpersJs() {
        String sOpersUrl = (String)this.mapFilteredConfig.get("opersUrl");
        if (sOpersUrl == null || sOpersUrl.length() == 0) {
            return;
        }
        try {
            this.validUrl(sOpersUrl);
            HttpClient oHttpClient = new HttpClient();
            GetMethod httpMethod = new GetMethod(sOpersUrl);
            oHttpClient.executeMethod((HttpMethod)httpMethod);
            String sResult = httpMethod.getResponseBodyAsString();
            this.mapFilteredConfig.put("/*$opersdata$*/", sResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void validUrl(String _sPostUri) throws Exception {
        try {
            new URL(_sPostUri);
        }
        catch (MalformedURLException ex) {
            throw new Exception(I18NMessage.get(WCM61AutoList.class, "WCM61AutoList.label1", I18NMessage.get(WCM61AutoList.class, "WCM61AutoList.label1", "\u4e0d\u662f\u5408\u6cd5\u7684HTTP\u8bf7\u6c42\u7684\u76ee\u6807\u5730\u5740[")) + _sPostUri + "]", ex);
        }
    }

    public void doQueryJsp() {
        String queryFileName = null;
        for (String fileName : this.m_newFiles) {
            String shortFileName = new FileService(fileName).getName();
            if (!shortFileName.endsWith("_query.jsp")) continue;
            queryFileName = fileName;
            break;
        }
        if (queryFileName == null) {
            return;
        }
        String sContent = null;
        try {
            String encoding = "GBK";
            sContent = WCM61AutoList.readFile(queryFileName, encoding);
            sContent = this.replaceQueryContent(sContent);
            sContent = sContent.replaceAll("\r", "");
            WCM61AutoList.writeFile(queryFileName, sContent, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String replaceQueryContent(String content) {
        HashMap map = this.prepareQuery(content);
        content = content.replaceAll("(?m)<\\!\\-\\-REMOVE(.|\n|\r)*?REMOVE\\-\\->", "");
        ArrayList list = (ArrayList)this.mapFilteredConfig.get("list_cols");
        StringBuffer sbHead = new StringBuffer();
        StringBuffer sbData = new StringBuffer();
        for (String item : list) {
            String[] arr = item.split(",");
            this.doHead(map, arr, sbHead);
            this.doData(map, arr, sbData);
        }
        int idx = content.indexOf("<!--$forhead$-->");
        content = content.substring(0, idx) + sbHead.toString() + content.substring(idx + "<!--$forhead$-->".length());
        idx = content.indexOf("<!--$fordata$-->");
        content = content.substring(0, idx) + sbData.toString() + content.substring(idx + "<!--$fordata$-->".length());
        return content;
    }

    private void doData(HashMap map, String[] arr, StringBuffer sbData) {
        if (arr.length < 6) {
            return;
        }
        String sReplace = null;
        if ("1".equals(arr[0].trim())) {
            sReplace = (String)map.get("data4");
        } else if ("0".equals(arr[4].trim())) {
            sReplace = (String)map.get("data3");
        } else if ("1".equals(arr[4].trim())) {
            sReplace = (String)map.get("data1");
        } else if ("2".equals(arr[4].trim())) {
            sReplace = (String)map.get("data2");
        }
        sbData.append(sReplace.replaceAll("\\$0\\$", arr[1].trim()).replaceAll("\\$1\\$", arr[2].trim()));
        sbData.append("\n");
    }

    private void doHead(HashMap map, String[] arr, StringBuffer sbHead) {
        if (arr.length < 6) {
            return;
        }
        String sReplace = null;
        sReplace = "1".equals(arr[3].trim()) ? (String)map.get("head2") : (String)map.get("head1");
        sbHead.append(sReplace.replaceAll("\\$0\\$", arr[1].trim()).replaceAll("\\$1\\$", arr[2].trim()).replaceAll("\\$2\\$", arr[5].trim()));
        sbHead.append("\n");
    }

    private HashMap prepareQuery(String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        int idx1 = content.indexOf("$head1start$");
        int idx2 = content.indexOf("$head1end$", idx1);
        map.put("head1", content.substring(idx1 + "$head1start$".length(), idx2));
        idx1 = content.indexOf("$head2start$");
        idx2 = content.indexOf("$head2end$", idx1);
        map.put("head2", content.substring(idx1 + "$head2start$".length(), idx2));
        idx1 = content.indexOf("$data1start$");
        idx2 = content.indexOf("$data1end$", idx1);
        map.put("data1", content.substring(idx1 + "$data1start$".length(), idx2));
        idx1 = content.indexOf("$data2start$");
        idx2 = content.indexOf("$data2end$", idx1);
        map.put("data2", content.substring(idx1 + "$data2start$".length(), idx2));
        idx1 = content.indexOf("$data3start$");
        idx2 = content.indexOf("$data3end$", idx1);
        map.put("data3", content.substring(idx1 + "$data3start$".length(), idx2));
        idx1 = content.indexOf("$data4start$");
        idx2 = content.indexOf("$data4end$", idx1);
        map.put("data4", content.substring(idx1 + "$data4start$".length(), idx2));
        return map;
    }

    public void replaceStrs() {
        for (String fileName : this.m_newFiles) {
            String encoding = fileName.endsWith(".jsp") ? "GBK" : (fileName.endsWith(".xml") ? "GB2312" : "utf-8");
            String sContent = null;
            try {
                sContent = WCM61AutoList.readFile(fileName, encoding);
                sContent = this.replaceContent(sContent);
                sContent = sContent.replaceAll("\r", "");
                WCM61AutoList.writeFile(fileName, sContent, encoding);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String replaceContent(String content) {
        for (String sKey : this.mapFilteredConfig.keySet()) {
            Object oValue = this.mapFilteredConfig.get(sKey);
            if (!(oValue instanceof String) || sKey.indexOf(36) == -1) continue;
            sKey = sKey.replaceAll("(\\$)", "\\\\$1").replaceAll("(\\*)", "\\\\$1").replaceAll("(\\!)", "\\\\$1");
            content = content.replaceAll(sKey, (String)oValue);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String _sSrcFile, String _sDstFile) {
        FileService fileTarget = new FileService(_sDstFile);
        FileService fParent = new FileService(fileTarget.getParent());
        if (!fParent.exists()) {
            fParent.mkdirs();
        }
        InputStream fis = null;
        OutputStream fos = null;
        try {
            int bytes;
            fis = new FileService(_sSrcFile).getInputStream();
            fos = new FileService(_sDstFile).getOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytes = fis.read(buffer, 0, 4096)) > 0) {
                fos.write(buffer, 0, bytes);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public static String readFile(String _sFileName, String _sEncoding) throws Exception {
        InputStreamReader fileReader = null;
        StringBuffer buffContent = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        if (_sEncoding == null) {
            _sEncoding = "utf-8";
        }
        try {
            String sLine;
            fis = new FileService(_sFileName).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, _sEncoding));
            while ((sLine = buffReader.readLine()) != null) {
                if (buffContent == null) {
                    buffContent = new StringBuffer();
                } else {
                    buffContent.append("\n");
                }
                buffContent.append(sLine);
            }
            String string = buffContent == null ? "" : buffContent.toString();
            return string;
        }
        catch (FileNotFoundException ex) {
            throw new Exception(I18NMessage.get(WCM61AutoList.class, "WCM61AutoList.label2", I18NMessage.get(WCM61AutoList.class, "WCM61AutoList.label2", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230(readFile)")), ex);
        }
        catch (IOException ex) {
            throw new Exception(I18NMessage.get(WCM61AutoList.class, "WCM61AutoList.label3", I18NMessage.get(WCM61AutoList.class, "WCM61AutoList.label3", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef(CMyFile.readFile)")), ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean writeFile(String _sFileName, String _sFileContent, String sFileEncoding) throws Exception {
        FileService fileTarget = new FileService(_sFileName);
        FileService fParent = new FileService(fileTarget.getParent());
        if (!fParent.exists()) {
            fParent.mkdirs();
        }
        boolean bRet = false;
        OutputStream fos = null;
        Writer outWriter = null;
        try {
            fos = new FileService(_sFileName).getOutputStream();
            outWriter = new OutputStreamWriter(fos, sFileEncoding);
            outWriter.write(_sFileContent);
            bRet = true;
        }
        catch (Exception ex) {
            throw new Exception(I18NMessage.get(WCM61AutoList.class, "WCM61AutoList.label4", I18NMessage.get(WCM61AutoList.class, "WCM61AutoList.label4", "\u5199\u6587\u4ef6\u9519\u8bef(writeFile)")), ex);
        }
        finally {
            try {
                if (outWriter != null) {
                    outWriter.flush();
                    outWriter.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        return bRet;
    }

    public static HashMap loadProps(String _sFileName, String _sEncoding) {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        String sLine = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        if (_sEncoding == null) {
            _sEncoding = "GBK";
        }
        try {
            fis = new FileService(_sFileName).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, _sEncoding));
            while ((sLine = buffReader.readLine()) != null) {
                int nPos;
                char firstChar;
                int len = (sLine = sLine.trim()).length();
                if (len == 0 || (firstChar = sLine.charAt(0)) == '#' || firstChar == '!' || firstChar == '=' || (nPos = sLine.indexOf("=")) == -1) continue;
                String key = sLine.substring(0, nPos);
                String val = sLine.substring(nPos + 1, len);
                String trimKey = key.trim();
                if (mapResult.containsKey(trimKey)) {
                    Object obj = mapResult.get(trimKey);
                    ArrayList list = null;
                    if (obj instanceof String) {
                        list = new ArrayList();
                        list.add(obj);
                    } else if (obj instanceof ArrayList) {
                        list = (ArrayList)obj;
                    }
                    list.add(val.trim());
                    mapResult.put(trimKey, list);
                    continue;
                }
                mapResult.put(trimKey, val.trim());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapResult;
    }
}

