/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.regex.Pattern;

public class SymbolC2E {
    public static char[][] resourceSymbols = new char[][]{{'\u3002', '.'}, {'\uff1f', '?'}, {'\uff01', '!'}, {'\uff0c', ','}, {'\u3001', ','}, {'\uff1b', ';'}, {'\uff1a', ':'}, {'\u201c', '\"'}, {'\u201d', '\"'}, {'\u300e', '['}, {'\u300f', ']'}, {'\u2018', '\''}, {'\u2019', '\''}, {'\u300c', '['}, {'\u300d', ']'}, {'\uff08', '('}, {'\uff09', ')'}, {'\uff08', '('}, {'\uff09', ')'}, {'\uff3b', '['}, {'\uff3d', ']'}, {'\u3014', '('}, {'\u3015', ')'}, {'\u3010', '['}, {'\u3011', ']'}, {'\uff5e', '~'}, {'\u300a', '<'}, {'\u300b', '>'}, {'\u3008', '<'}, {'\u3009', '>'}};
    public static char[][] pageSymbols = new char[][]{{'\u3002', '.'}, {'\uff1f', '?'}, {'\uff01', '!'}, {'\uff0c', ','}, {'\u3001', ','}, {'\uff1b', ';'}, {'\uff1a', ':'}, {'\u300e', '['}, {'\u300f', ']'}, {'\u300c', '['}, {'\u300d', ']'}, {'\uff08', '('}, {'\uff09', ')'}, {'\uff08', '('}, {'\uff09', ')'}, {'\uff3b', '['}, {'\uff3d', ']'}, {'\u3014', '('}, {'\u3015', ')'}, {'\u3010', '['}, {'\u3011', ']'}, {'\uff5e', '~'}, {'\u300a', '<'}, {'\u300b', '>'}, {'\u3008', '<'}, {'\u3009', '>'}};
    public static char[][] runtimeSymbols = pageSymbols;
    public static Pattern normalPattern = Pattern.compile("\\.(html|htm|jsp|js|properties)$");
    public static Pattern resourcePattern = Pattern.compile("\\.(js|properties)$");
    public static Pattern pagePattern = Pattern.compile("\\.(html|htm|jsp|js|)$");
    public static Pattern runtimePattern = normalPattern;
    private static boolean bJsFile = false;

    public static char replace(char cnChar) {
        for (int i = 0; i < runtimeSymbols.length; ++i) {
            if (runtimeSymbols[i][0] != cnChar) continue;
            return runtimeSymbols[i][1];
        }
        return cnChar;
    }

    public static String replace(String cnStr) {
        if (cnStr == null || cnStr.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(cnStr.length());
        int length = cnStr.length();
        for (int i = 0; i < length; ++i) {
            char cOldTemp = cnStr.charAt(i);
            char cNewTemp = SymbolC2E.replace(cOldTemp);
            String sTemp = String.valueOf(cNewTemp);
            if (bJsFile && cOldTemp != cNewTemp) {
                if (cNewTemp == '\"') {
                    sTemp = "\\" + cNewTemp;
                } else if (cNewTemp == '\'') {
                    sTemp = "\\" + cNewTemp;
                }
            }
            sb.append(sTemp);
        }
        return sb.toString();
    }

    public static boolean isExcludeDir(String sDir) {
        if (runtimePattern != pagePattern) {
            return false;
        }
        return sDir.indexOf("app/js/data/locale") >= 0;
    }

    public static void replaceDir(String sSourceDir, String sDestDir) throws Exception {
        FileService sourceFile = new FileService(sSourceDir);
        if (!sourceFile.exists()) {
            return;
        }
        if (SymbolC2E.isExcludeDir(sSourceDir)) {
            return;
        }
        if (!CMyFile.fileExists(sDestDir)) {
            CMyFile.makeDir(sDestDir, true);
        }
        FileStore[] files = sourceFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String sSourcePath = files[i].getPath();
            String sDestPath = sDestDir + File.separator + files[i].getName();
            if (files[i].isFile()) {
                SymbolC2E.replaceFile(sSourcePath, sDestPath);
                continue;
            }
            SymbolC2E.replaceDir(sSourcePath, sDestPath);
        }
    }

    public static boolean isExcludeFile(String sFileName) {
        return !runtimePattern.matcher(sFileName).find();
    }

    public static void replaceFile(String sSourceFile, String sDestFile) throws Exception {
        if (!CMyFile.fileExists(sSourceFile)) {
            return;
        }
        if (SymbolC2E.isExcludeFile(sSourceFile)) {
            return;
        }
        bJsFile = sSourceFile.endsWith(".js");
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        System.out.println(sSourceFile);
        String sEncoding = CharsetDetector.detect(sSourceFile);
        String sSourceContent = CMyFile.readFile(sSourceFile, sEncoding);
        CMyFile.writeFile(sDestFile, SymbolC2E.replace(sSourceContent), sEncoding);
    }

    public static void main(String[] args) throws Exception {
        String sSourceDir = "E:\\MyWorkspace\\TRS.WCM.V6.1.Std\\runtime\\en\\wcm\\WEB-INF\\classes\\locale\\";
        String sDestDir = "d:\\WCMV61-sym";
        if (args.length >= 2) {
            sSourceDir = args[0];
            sDestDir = args[1];
        }
        if (args.length >= 3) {
            if (args[2].equalsIgnoreCase("page")) {
                SymbolC2E.replacePages(sSourceDir, sDestDir);
            } else {
                SymbolC2E.replaceResources(sSourceDir, sDestDir);
            }
        } else {
            SymbolC2E.replaceDir(sSourceDir, sDestDir);
        }
    }

    public static void replaceResources(String sSrcRootPath, String sDestRootPath) throws Exception {
        runtimePattern = resourcePattern;
        runtimeSymbols = resourceSymbols;
        String[][] dirs = new String[][]{{"app/js/data/locale/"}, {"WEB-INF/classes/locale/"}, {"WEB-INF/classes/wcm6-locale/"}, {"WEB-INF/classes/i18nmessage/"}};
        if (CMyString.isEmpty(sDestRootPath)) {
            sDestRootPath = sSrcRootPath;
        }
        for (int i = 0; i < dirs.length; ++i) {
            String[] twoDir = dirs[i];
            String srcDir = sSrcRootPath + File.separator + twoDir[0];
            String destDir = sDestRootPath + File.separator + (twoDir.length > 1 ? twoDir[1] : twoDir[0]);
            SymbolC2E.replaceDir(srcDir, destDir);
        }
    }

    public static void replacePages(String sSrcRootPath, String sDestRootPath) throws Exception {
        runtimePattern = pagePattern;
        runtimeSymbols = pageSymbols;
        SymbolC2E.replaceDir(sSrcRootPath, sDestRootPath);
    }
}

