/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.JavaScriptVARProcessor;
import com.trs.infra.util.PropertiesVARProcessor;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreFilter;
import com.trs.tools.LocaleServerCollector;
import com.trs.tools.Localizer2;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MediaBuilder {
    private static Logger logger = Logger.getLogger(MediaBuilder.class);
    private static String root;
    private static String releaseDir;
    private static String runtimeDir;
    private static String baseDir;
    private static String basePath4CNAndEN;
    private static List jsResources;
    private static List propertiesResources;

    public static void init(String sRoot, String sOutputDir) {
        root = new FileService(sRoot.replace('/', File.separatorChar).replace('\\', File.separatorChar)).getAbsolutePath();
        root = CMyString.setStrEndWith(root, File.separatorChar);
        baseDir = root + "wcm_locales\\en\\";
        basePath4CNAndEN = root + "app";
        releaseDir = sOutputDir;
        runtimeDir = new FileService(sOutputDir).getParentFileStore().getAbsolutePath();
    }

    public static void processJavaScript() throws Exception {
        JavaScriptVARProcessor processer = null;
        int length = jsResources.size();
        for (int i = 0; i < length; ++i) {
            String[] resouce = (String[])jsResources.get(i);
            processer = new JavaScriptVARProcessor(root + resouce[0], root + resouce[1], releaseDir, resouce.length == 3 ? resouce[2] : baseDir);
            if (resouce[0].endsWith(".js")) {
                processer.process(root + resouce[0], root + resouce[1]);
                continue;
            }
            processer.process();
        }
        logger.info((Object)"\u5f00\u59cb\u5904\u7406_cn.js\u4e0e_en.js\u540e\u7f00\u6587\u4ef6\u7684\u5bf9\u6bd4");
        new FileService(basePath4CNAndEN).listFiles(new FileStoreFilter(){

            @Override
            public boolean accept(FileStore oFile) {
                if (oFile.isDirectory()) {
                    oFile.listFiles(this);
                    return false;
                }
                String sFileName = oFile.getName();
                if (!sFileName.endsWith("_cn.js")) {
                    return false;
                }
                String sFilePath = oFile.getAbsolutePath();
                String sDestPath = sFilePath.substring(0, sFilePath.length() - "_cn.js".length()) + "_en.js";
                JavaScriptVARProcessor processer = new JavaScriptVARProcessor(sFilePath, sFilePath, releaseDir, root);
                try {
                    processer.process(sFilePath, sDestPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        });
    }

    public static void processProperties() throws Exception {
        PropertiesVARProcessor processer = null;
        int length = propertiesResources.size();
        for (int i = 0; i < length; ++i) {
            String[] resouce = (String[])propertiesResources.get(i);
            processer = new PropertiesVARProcessor(root + resouce[0], root + resouce[1], releaseDir, baseDir);
            if (resouce[0].endsWith(".properties")) {
                processer.process(root + resouce[0], root + resouce[1]);
                continue;
            }
            processer.process();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            StringBuffer sbInfo = new StringBuffer(200);
            sbInfo.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u9700\u8981\u4e24\u4e2a\u53c2\u6570\n");
            sbInfo.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684\u5de5\u7a0bWebApp\u76ee\u5f55\uff1a\n");
            sbInfo.append("\u5982\uff1a\n");
            sbInfo.append("E:/MyWorkspace/TRS.WCM.V6.1.Std/SourceCode/WebApp/");
            sbInfo.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u4e2d\u82f1\u6587\u8d44\u6e90\u6587\u4ef6\u6bd4\u8f83\u540e\uff0c\u6709\u4e2d\u6587\u7684\u82f1\u6587\u8d44\u6e90\u6587\u4ef6\u8f93\u51fa\u6839\u76ee\u5f55\uff1a\n");
            sbInfo.append("\u5982\uff1a\n");
            sbInfo.append("E:\\wcm65\\increase\\\n");
            logger.error((Object)sbInfo);
            return;
        }
        MediaBuilder.init(args[0], args[1]);
        Localizer2.main(new String[]{root, runtimeDir, "en", "true"});
        String sLocalePath = root + "WEB-INF/classes/locale/";
        LocaleServerCollector.main(new String[]{root + "app", sLocalePath + "zh_CN.properties"});
        new PropertiesVARProcessor(sLocalePath, sLocalePath, releaseDir, root).process(sLocalePath + "zh_CN.properties", sLocalePath + "presentation_zh_CN.properties");
        CMyFile.deleteFile(sLocalePath + "zh_CN.properties");
        CMyFile.copyFile(sLocalePath + "presentation_zh_CN.properties", sLocalePath + "presentation_en.properties");
        MediaBuilder.processProperties();
    }

    static {
        jsResources = new ArrayList();
        jsResources.add(new String[]{"app\\js\\data\\locale\\", "wcm_locales\\en\\app\\js\\data\\locale\\"});
        jsResources.add(new String[]{"app\\editor\\editor\\lang\\cn.js", "app\\editor\\editor\\lang\\en.js", root});
        propertiesResources = new ArrayList();
        propertiesResources.add(new String[]{"WEB-INF\\classes\\i18nmessage\\", "wcm_locales\\en\\WEB-INF\\classes\\i18nmessage\\"});
        propertiesResources.add(new String[]{"WEB-INF\\classes\\locale\\", "wcm_locales\\en\\WEB-INF\\classes\\locale\\"});
        propertiesResources.add(new String[]{"WEB-INF\\classes\\wcm6-locale\\", "wcm_locales\\en\\WEB-INF\\classes\\wcm6-locale\\"});
    }
}

