/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Localizer {
    private static final String WEB_INF_CLASSES_LOCALE = "/WEB-INF/classes/wcm6-locale/";
    String m_sLang = "cn";
    static Pattern m_pBlockWhere = Pattern.compile("(?i)<(title|span|div|td|option|a|legend|button|label|noscript)[^>]* WCMAnt:param=[\"']([^\"']*)[\"'][^>]*>");
    static Pattern m_pAttrTrans = Pattern.compile("(?i)(<[^>]* WCMAnt:paramattr=[\"']([^\"':]*):([^\"':]*?)[\"']( [^>]*)?)>");
    Hashtable m_htTranslates = new Hashtable();
    String m_sRootPath = "/wcm";
    String[] m_arrToTransPaths = new String[]{"app", "console"};
    static Pattern m_pScriptLocale = Pattern.compile("(?i)(<script(?: [^>]*)? WCMAnt:locale=[\"']([^\"']*)[\"'](?: [^>]*)?)>");
    Writer m_localePropsWriter = null;
    static boolean m_recordLocaleProps = false;
    private Map m_tmpTranParams = null;

    public Localizer(String sRootPath, String sLang) {
        this.m_sRootPath = new FileService(sRootPath.replace('/', File.separatorChar).replace('\\', File.separatorChar)).getAbsolutePath();
        this.m_sLang = sLang;
        if (!m_recordLocaleProps) {
            this.loadTranslates();
        }
    }

    public String[] getToTransPaths() {
        return this.m_arrToTransPaths;
    }

    public void setToTransPaths(String[] toTransPaths) {
        this.m_arrToTransPaths = toTransPaths;
    }

    private void loadTranslates() {
        try {
            String sLocaleFile = this.m_sRootPath + WEB_INF_CLASSES_LOCALE + this.m_sLang + ".properties";
            sLocaleFile = sLocaleFile.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            if (!new FileService(sLocaleFile).exists()) {
                return;
            }
            String sContent = CMyFile.readFile(sLocaleFile, "GBK");
            String[] arrLines = sContent.split("\n(\r)?");
            for (int i = 0; i < arrLines.length; ++i) {
                String sLine = arrLines[i].trim();
                if (sLine.length() == 0 || sLine.startsWith("#") || sLine.indexOf("=") == -1) continue;
                int nIndex = sLine.indexOf(61);
                this.m_htTranslates.put(sLine.substring(0, nIndex).toUpperCase(), sLine.substring(nIndex + 1));
            }
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
    }

    public void localize() throws CMyException {
        try {
            if (m_recordLocaleProps) {
                this.getLocalePropsWriter();
            }
            this.localize1();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (m_recordLocaleProps) {
                try {
                    this.closeLocalePropsWriter();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void localizeNew(Date date) throws CMyException {
        try {
            if (m_recordLocaleProps) {
                this.getLocalePropsWriter();
            }
            this.localizeNew1(date);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (m_recordLocaleProps) {
                try {
                    this.closeLocalePropsWriter();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void localize1() throws CMyException {
        for (int i = 0; i < this.m_arrToTransPaths.length; ++i) {
            FileService toTrans = new FileService(this.m_sRootPath + File.separatorChar + this.m_arrToTransPaths[i]);
            this.localizePath(toTrans);
        }
    }

    public void localizeNew1(Date date) throws CMyException {
        for (int i = 0; i < this.m_arrToTransPaths.length; ++i) {
            FileService toTrans = new FileService(this.m_sRootPath + File.separatorChar + this.m_arrToTransPaths[i]);
            this.localizePathNew(toTrans, date);
        }
    }

    public void localizePath(FileStore oPath) throws CMyException {
        if (oPath.isDirectory()) {
            FileStore[] arrFiles = oPath.listFiles();
            for (int i = 0; i < arrFiles.length; ++i) {
                this.localizePath(arrFiles[i]);
            }
            return;
        }
        this.localizeFile(oPath, this.getToFileName(oPath));
    }

    private void localizePathNew(FileStore oPath, Date date) throws CMyException {
        if (date == null) {
            this.localizePath(oPath);
            return;
        }
        if (oPath.isDirectory()) {
            FileStore[] arrFiles = oPath.listFiles();
            for (int i = 0; i < arrFiles.length; ++i) {
                this.localizePathNew(arrFiles[i], date);
            }
            return;
        }
        if (oPath.lastModified() >= date.getTime()) {
            this.localizeFile(oPath, this.getToFileName(oPath));
        }
    }

    public void localizeFile(FileStore oFile, String _toFileName) throws CMyException {
        String sOldFileName = oFile.getAbsolutePath();
        System.out.println("----------From :" + sOldFileName);
        System.out.println(">>>>>>>>>>>>To :" + _toFileName);
        if (this.isBinaryFile(sOldFileName)) {
            CMyFile.copyFile(sOldFileName, _toFileName);
            return;
        }
        if (!this.isPageFile(sOldFileName)) {
            String sFileEncoding = this.genFileEncoding(sOldFileName);
            String sContent = CMyFile.readFile(sOldFileName, sFileEncoding);
            sContent = this.replacePaths(sContent);
            sContent = sContent.replaceAll("wcm61_", "wcm61_" + this.m_sLang + "_");
            CMyFile.writeFile(_toFileName, sContent, sFileEncoding);
            return;
        }
        String sFileEncoding = this.genFileEncoding(sOldFileName);
        String sHtml = CMyFile.readFile(sOldFileName, sFileEncoding);
        sHtml = sHtml.replaceAll("\\%>", "%_!_%");
        sHtml = this.replacePaths(sHtml);
        sHtml = this.blockTrans(sHtml);
        sHtml = this.attrTrans(sHtml);
        sHtml = this.scriptLocalize(sHtml);
        sHtml = sHtml.replaceAll("\\%_\\!_\\%", "%>");
        CMyFile.writeFile(_toFileName, sHtml, sFileEncoding);
    }

    private String scriptLocalize(String html) {
        Matcher oMatcher = m_pScriptLocale.matcher(html);
        StringBuffer sbResult = new StringBuffer();
        int nIndex = 0;
        while (oMatcher.find()) {
            int nStartIndex = oMatcher.start();
            sbResult.append(html.substring(nIndex, nStartIndex));
            String strSrc = oMatcher.group(2).replaceAll("(?i)\\$locale\\$", this.m_sLang);
            sbResult.append(oMatcher.group(1).replaceAll("(?i) src=[\"'][^\"']*[\"']", ""));
            sbResult.append(" src=\"");
            sbResult.append(strSrc);
            sbResult.append("\">");
            nIndex = oMatcher.end();
        }
        if (nIndex != html.length() - 1) {
            sbResult.append(html.substring(nIndex));
        }
        return sbResult.toString();
    }

    private String replacePaths(String content) {
        if (this.m_arrToTransPaths == null || this.m_arrToTransPaths.length == 0) {
            return content;
        }
        String sForReplace = "/(" + CMyString.join(this.m_arrToTransPaths, "|") + ")/";
        return content.replaceAll(sForReplace, "/$1_" + this.m_sLang + "/");
    }

    private boolean isTxtFile(String sFileName) {
        String strExt = sFileName.replaceFirst("^.*\\.([^\\.]*)", "$1").toLowerCase();
        return "jsp".equals(strExt) || "html".equals(strExt) || "htm".equals(strExt) || "js".equals(strExt) || "css".equals(strExt) || "xml".equals(strExt);
    }

    private boolean isBinaryFile(String sFileName) {
        return !this.isTxtFile(sFileName);
    }

    private boolean isPageFile(String sFileName) {
        String strExt = sFileName.replaceFirst("^.*\\.([^\\.]*)", "$1").toLowerCase();
        return "jsp".equals(strExt) || "html".equals(strExt) || "htm".equals(strExt);
    }

    private String attrTrans(String html) {
        Matcher oMatcher = m_pAttrTrans.matcher(html);
        StringBuffer sbResult = new StringBuffer();
        int nIndex = 0;
        while (oMatcher.find()) {
            int nStartIndex = oMatcher.start();
            sbResult.append(html.substring(nIndex, nStartIndex));
            String sAttrName = oMatcher.group(2);
            String sTranParam = oMatcher.group(3);
            String sTranValue = this.getTranslate(sTranParam, m_recordLocaleProps ? this.getAttrValue(oMatcher.group(1), sAttrName) : "");
            if (sTranValue != null) {
                sbResult.append(oMatcher.group(1).replaceAll("(?i) " + sAttrName + "=[\"'][^\"']*[\"']", ""));
                sbResult.append(" ");
                sbResult.append(sAttrName);
                sbResult.append("=\"");
                sbResult.append(sTranValue);
                sbResult.append("\">");
            } else {
                sbResult.append(oMatcher.group(0));
            }
            nIndex = oMatcher.end();
        }
        if (nIndex != html.length() - 1) {
            sbResult.append(html.substring(nIndex));
        }
        return sbResult.toString();
    }

    private int getNextQuoteIndex(String nodeAttrs, char quoteChar, int nStartIndex) {
        int nNextIndex = nodeAttrs.indexOf(quoteChar, nStartIndex);
        while (nNextIndex > 0 && nodeAttrs.charAt(nNextIndex - 1) == '\\') {
            nNextIndex = nodeAttrs.indexOf(quoteChar, nNextIndex + 1);
        }
        return nNextIndex;
    }

    private String getAttrValue(String nodeAttrs, String attrName) {
        int nLastJspEnd;
        String attrPattern = " " + attrName.toLowerCase() + "=";
        int nIndex = nodeAttrs.toLowerCase().indexOf(attrPattern);
        if (nIndex < 0) {
            return "";
        }
        char quoteChar = nodeAttrs.charAt(nIndex += attrPattern.length());
        int nNextIndex = this.getNextQuoteIndex(nodeAttrs = nodeAttrs.substring(nIndex + 1), quoteChar, 0);
        if (nNextIndex < 0) {
            return "";
        }
        String strJspStart = "<%";
        String strJspEnd = "%_!_%";
        String tmpValue = nodeAttrs.substring(0, nNextIndex);
        if (tmpValue.indexOf(strJspStart) == -1) {
            return tmpValue;
        }
        int nLastJspStart = tmpValue.lastIndexOf(strJspStart);
        if (nLastJspStart < (nLastJspEnd = tmpValue.lastIndexOf(strJspEnd))) {
            return tmpValue;
        }
        int nTmpIndex = nodeAttrs.indexOf(strJspEnd, nNextIndex);
        while (nNextIndex > 0 && nTmpIndex > 0) {
            nNextIndex = this.getNextQuoteIndex(nodeAttrs, quoteChar, nTmpIndex);
            if (nNextIndex < 0) {
                return "";
            }
            tmpValue = nodeAttrs.substring(nTmpIndex, nNextIndex);
            if (tmpValue.indexOf(strJspStart) == -1) {
                return nodeAttrs.substring(0, nNextIndex);
            }
            nTmpIndex = nodeAttrs.indexOf(strJspEnd, nNextIndex);
        }
        return "";
    }

    private String blockTrans(String html) {
        Matcher oMatcher = m_pBlockWhere.matcher(html);
        StringBuffer sbResult = new StringBuffer();
        int nIndex = 0;
        while (oMatcher.find()) {
            int nStartIndex = oMatcher.start();
            if (nStartIndex < nIndex) continue;
            sbResult.append(html.substring(nIndex, nStartIndex));
            String sBlockTagName = oMatcher.group(1);
            nIndex = this.doBlock(oMatcher, html, sBlockTagName, sbResult);
        }
        if (nIndex != html.length() - 1) {
            sbResult.append(html.substring(nIndex));
        }
        return sbResult.toString();
    }

    private int doBlock(Matcher matcher, String html, String blockTagName, StringBuffer sbResult) {
        String sStartTag = "<" + blockTagName;
        String sEndTag = "</" + blockTagName + ">";
        int nMatchEnd = matcher.end();
        String endHtml = html.substring(nMatchEnd);
        int nNextStart = endHtml.indexOf(sStartTag);
        int nNextEnd = endHtml.indexOf(sEndTag);
        if (nNextEnd < 0) {
            sbResult.append(matcher.group(0));
            return nMatchEnd;
        }
        if (nNextStart < 0 || nNextEnd < nNextStart) {
            String sTranParam = matcher.group(2);
            String sTranValue = this.getTranslate(sTranParam, endHtml.substring(0, nNextEnd));
            sbResult.append(matcher.group(0));
            sbResult.append(sTranValue);
            sbResult.append(sEndTag);
            return nMatchEnd + nNextEnd + sEndTag.length();
        }
        int nNestNum = 2;
        int nMinIndex = nNextStart + sStartTag.length();
        String tmpHtml = null;
        while (nNestNum > 0 && nMinIndex >= 0) {
            tmpHtml = endHtml.substring(nMinIndex);
            int nTmpNextStart = tmpHtml.indexOf(sStartTag);
            int nTmpNextEnd = tmpHtml.indexOf(sEndTag);
            if (nTmpNextEnd < 0) {
                nMinIndex = -1;
                break;
            }
            if (nTmpNextStart < 0 || nTmpNextEnd < nTmpNextStart) {
                --nNestNum;
                nMinIndex += nTmpNextEnd + sEndTag.length();
                continue;
            }
            ++nNestNum;
            nMinIndex += nTmpNextStart + sStartTag.length();
        }
        if (nMinIndex > 0) {
            String sTranParam = matcher.group(2);
            String sTranValue = this.getTranslate(sTranParam, endHtml.substring(0, nMinIndex - sEndTag.length()));
            sbResult.append(matcher.group(0));
            sbResult.append(sTranValue);
            sbResult.append(sEndTag);
            return nMatchEnd + nMinIndex;
        }
        sbResult.append(matcher.group(0));
        return nMatchEnd;
    }

    private Writer getLocalePropsWriter() throws IOException {
        String sLocaleFile = this.m_sRootPath + WEB_INF_CLASSES_LOCALE + this.m_sLang + ".properties";
        if (this.m_localePropsWriter == null) {
            if (!new FileService(sLocaleFile).exists()) {
                CMyFile.makeDir(this.m_sRootPath + WEB_INF_CLASSES_LOCALE, true);
            }
            this.m_tmpTranParams = new HashMap();
            OutputStream fileos = new FileService(sLocaleFile).getOutputStream();
            this.m_localePropsWriter = new OutputStreamWriter(fileos, "GBK");
        }
        return this.m_localePropsWriter;
    }

    private void closeLocalePropsWriter() throws IOException {
        if (this.m_localePropsWriter != null) {
            this.m_localePropsWriter.close();
        }
    }

    private String getTranslate(String tranParam, String currValue) {
        currValue = CMyString.showEmpty(currValue).trim().replaceAll("\\%_\\!_\\%", "%>");
        if (m_recordLocaleProps) {
            try {
                Writer writer = this.getLocalePropsWriter();
                String lastValue = (String)this.m_tmpTranParams.get(tranParam.toUpperCase());
                if (lastValue != null) {
                    System.out.println(I18NMessage.get(Localizer.class, "Localizer.label1", "\u91cd\u590d\u4f7f\u7528\u540c\u4e00\u4e2a\u53d8\u91cf:") + tranParam + I18NMessage.get(Localizer.class, "Localizer.label2", ",\u65e7\u503c:") + lastValue + I18NMessage.get(Localizer.class, "Localizer.label3", ",\u65b0\u503c:") + currValue);
                } else {
                    writer.write(tranParam);
                    writer.write("=");
                    writer.write(currValue);
                    writer.write("\n");
                    this.m_tmpTranParams.put(tranParam.toUpperCase(), currValue);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return CMyString.showNull((String)this.m_htTranslates.get(tranParam.toUpperCase()), currValue);
    }

    private String genFileEncoding(String sAbsFilePath) {
        String sFileEncoding = "GBK";
        if ((sAbsFilePath = sAbsFilePath.replace('\\', '/')).indexOf("/metadata/application/") != -1) {
            return "utf-8";
        }
        if (sAbsFilePath.indexOf("/ext/") != -1 && sAbsFilePath.indexOf("/locale/") == -1 && sAbsFilePath.indexOf("wcm") == -1) {
            return "GBK";
        }
        if (sAbsFilePath.endsWith(".xml")) {
            return "GBK";
        }
        if (!sAbsFilePath.endsWith(".jsp")) {
            return "utf-8";
        }
        return sFileEncoding;
    }

    private String getToFileName(FileStore toTrans) {
        String sFileName = toTrans.getAbsolutePath();
        return this.m_sRootPath + sFileName.substring(this.m_sRootPath.length()).replace('\\', '/').replaceAll("/(app|WCMV6|console|wcm61)/", "/$1_" + this.m_sLang + "/").replace('/', File.separatorChar);
    }

    public static void mainTest(String sRootPath, String locale) {
        if (CMyString.isEmpty(locale)) {
            return;
        }
        Localizer oLocalizer = new Localizer(sRootPath, locale);
        oLocalizer.setToTransPaths(new String[]{"app", "console", "WEB-INF/classes/trsconfig/service/wcm61"});
        try {
            oLocalizer.localize();
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String sRootPath = "D:\\workspace\\TRS.WCM.V6.1\\media\\rc1\\runtime\\";
        String sLocales = "en";
        if (args.length > 0) {
            sRootPath = args[0];
            sLocales = args[1];
        }
        boolean bl = m_recordLocaleProps = args.length > 2 ? "true".equalsIgnoreCase(args[2]) : false;
        if (CMyString.isEmpty(sLocales)) {
            return;
        }
        String[] arrLocales = sLocales.split(",");
        for (int i = 0; i < arrLocales.length; ++i) {
            Localizer.mainTest(sRootPath, arrLocales[i]);
        }
    }
}

