/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.publish.domain;

import com.trs.DreamFactory;
import com.trs.cluster.ClusterConfigHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.scm.domain.ISCMGroupMgr;
import com.trs.scm.domain.ISCMMicroContentMgr;
import com.trs.scm.domain.SCMAuthServer;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.persistent.SCMGroups;
import com.trs.scm.persistent.SCMMicroContent;
import com.trs.scm.persistent.SCMMicroContents;
import com.trs.scm.publish.persistent.SCMMCPublishTask;
import com.trs.scm.publish.persistent.SCMMCPublishTasks;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class SCMMCPublishTaskCacheMgr
implements ICacheMgr,
Runnable,
IClearable {
    private static final Logger logger = Logger.getLogger((String)SCMMCPublishTaskCacheMgr.class.getName());
    private static HashMap<Integer, SCMMCPublishTask> m_oPublishTaskCache;
    private static HashMap<Integer, SCMMCPublishTasks> m_oPublishingSCMMicroContentsCache;
    private static boolean m_bIsInited;
    private static boolean m_bIsInitiating;
    private ISCMMicroContentMgr m_oSCMMicroContentMgr = (ISCMMicroContentMgr)DreamFactory.createObjectById("ISCMMicroContentMgr");
    private static SCMMicroContent m_taskContent;
    private static SCMMCPublishTask m_task;
    private static SCMMCPublishTask m_locker_task;
    private CMyDateTime m_dtStart = null;
    private CMyDateTime m_dtEnd = null;
    private int m_nResult = 10;
    private boolean m_bHasWarnings = false;
    private String m_sException = null;
    private static boolean m_bIsRunning;
    private static final int RUN_INTERVAL = 30000;
    private static long wait_interval;
    private static int nRetryTimes;
    private boolean m_zStarted;

    private boolean isSlaveNode() {
        ClusterConfig config = ClusterConfigHelper.getConfig();
        return config.isEnabled() && !config.isMaster();
    }

    public static SCMMCPublishTaskCacheMgr getInstance() {
        SCMMCPublishTaskCacheMgr oCacheMgr = (SCMMCPublishTaskCacheMgr)DreamFactory.createObjectById("SCMMCPublishTaskCacheMgr");
        if (!oCacheMgr.isInited()) {
            oCacheMgr.init();
        }
        return oCacheMgr;
    }

    public SCMMicroContents queryUnpublishedSCMMCs() throws Exception {
        if (this.isInitiating()) {
            logger.error((Object)"The SCM MicroContent publish Task Cache is initiating, please wait a minute!");
        }
        Integer[] oSCMMicroContentIds = new Integer[m_oPublishingSCMMicroContentsCache.size()];
        m_oPublishingSCMMicroContentsCache.keySet().toArray(oSCMMicroContentIds);
        if (oSCMMicroContentIds.length == 0) {
            logger.error((Object)"\u83b7\u53d6\u5fae\u535am_oPublishingSCMMicroContentsCache\u4e3a\u7a7a!");
            return null;
        }
        String Ids = "";
        SCMMCPublishTasks oTempTasks = null;
        for (int i = oSCMMicroContentIds.length - 1; i >= 0; --i) {
            oTempTasks = m_oPublishingSCMMicroContentsCache.get(oSCMMicroContentIds[i]);
            if (oTempTasks == null || oTempTasks.size() == 0) {
                m_oPublishingSCMMicroContentsCache.remove(oSCMMicroContentIds[i]);
                continue;
            }
            Ids = Ids + oSCMMicroContentIds[i].toString() + ",";
        }
        if (Ids.length() == 0 || Ids.split(",").length == 0) {
            logger.error((Object)"\u83b7\u53d6\u5fae\u535aIDS\u4e3a\u7a7a!");
            return null;
        }
        SCMMicroContents oResult = SCMMicroContents.findByIds(User.getSystem(), Ids.substring(0, Ids.length() - 1));
        if (oResult == null || oResult.size() == 0) {
            logger.error((Object)"\u83b7\u53d6\u5fae\u535aoResult\u4e3a\u7a7a!");
            return null;
        }
        User oCurrUser = ContextHelper.getLoginUser();
        if (SCMAuthServer.isAdminOfSCM(oCurrUser)) {
            return oResult;
        }
        SCMMicroContent oTempMC = null;
        ISCMGroupMgr oSCMGroupMgr = (ISCMGroupMgr)DreamFactory.createObjectById("ISCMGroupMgr");
        SCMGroups oManagedGroups = oSCMGroupMgr.getAllUserCanMgrGroups(oCurrUser);
        for (int i = oResult.size() - 1; i >= 0; --i) {
            oTempMC = (SCMMicroContent)oResult.getAt(i);
            if (oManagedGroups.indexOf(oTempMC.getGroupId()) >= 0) continue;
            oResult.remove(oTempMC, false);
        }
        return oResult;
    }

    public SCMMCPublishTasks queryPublishTasksForSCMMC(int _nSCMMicroContentId) throws WCMException {
        if (this.isInitiating()) {
            logger.error((Object)"The SCM MicroContent publish Task Cache is initiating, please wait a minute!");
        }
        return m_oPublishingSCMMicroContentsCache.get(_nSCMMicroContentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean init() {
        if (this.isInited()) {
            logger.debug((Object)"\u5fae\u535a\u53d1\u5e03\u961f\u5217\u7f13\u5b58\u5df2\u7ecf\u521d\u59cb\u5316\u4e86\uff01");
            return true;
        }
        if (this.isInitiating()) {
            logger.debug((Object)"\u5fae\u535a\u53d1\u5e03\u961f\u5217\u7f13\u5b58\u6b63\u5728\u521d\u59cb\u5316!");
            return true;
        }
        SCMMCPublishTaskCacheMgr sCMMCPublishTaskCacheMgr = this;
        synchronized (sCMMCPublishTaskCacheMgr) {
            if (this.isInited()) {
                logger.debug((Object)"\u53d1\u5e03\u961f\u5217\u5fae\u535a\u7f13\u5b58\u5df2\u7ecf\u521d\u59cb\u5316\u4e86\uff01");
                return true;
            }
            logger.debug((Object)"begin to initiating the publish task cache...");
            this.setInitiating(true);
            try {
                m_oPublishTaskCache = new HashMap();
                m_oPublishingSCMMicroContentsCache = new LinkedHashMap<Integer, SCMMCPublishTasks>();
                WCMFilter oFilter = new WCMFilter("", "", "CRTIME ASC");
                SCMMCPublishTasks oPublishTasks = null;
                try {
                    oPublishTasks = SCMMCPublishTasks.openWCMObjs(null, oFilter);
                }
                catch (WCMException e) {
                    logger.error((Object)"\u67e5\u8be2\u5fae\u535a\u53d1\u5e03\u4efb\u52a1\u961f\u5217\u5931\u8d25\uff01", (Throwable)e);
                    oPublishTasks = new SCMMCPublishTasks(null);
                    e.printStackTrace();
                }
                if (oPublishTasks != null && oPublishTasks.size() > 0) {
                    for (int i = 0; i < oPublishTasks.size(); ++i) {
                        SCMMCPublishTask oCurrTask = (SCMMCPublishTask)oPublishTasks.getAt(i);
                        if (oCurrTask == null) continue;
                        logger.debug((Object)("got the " + (i + 1) + "th task..."));
                        try {
                            m_oPublishTaskCache.put(oCurrTask.getId(), oCurrTask);
                            int scmmcid = oCurrTask.getSCMMCID();
                            SCMMCPublishTasks oCurrTasks = m_oPublishingSCMMicroContentsCache.get(scmmcid);
                            if (oCurrTasks == null) {
                                oCurrTasks = new SCMMCPublishTasks(User.getSystem());
                            }
                            oCurrTasks.addElement(oCurrTask);
                            m_oPublishingSCMMicroContentsCache.put(scmmcid, oCurrTasks);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error((Object)("\u5fae\u535a\u53d1\u5e03\u961f\u5217\u7f13\u5b58\u521d\u59cb\u5316\u6dfb\u52a0\u4efb\u52a1[" + oCurrTask.getId() + "]\u5931\u8d25"), (Throwable)e);
                            e.printStackTrace();
                        }
                    }
                }
                logger.debug((Object)"put all the tasks into the cache...");
                this.setInitiating(false);
            }
            catch (Throwable ex) {
                try {
                    logger.error((Object)"\u5fae\u535a\u53d1\u5e03\u961f\u5217\u7f13\u5b58\u521d\u59cb\u5316\u5931\u8d25\uff01", ex);
                    this.setInited(false);
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.setInitiating(false);
                }
            }
            try {
                nRetryTimes = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("RETRYTIMES_FOR_SCM_PUBLISHTASK", "5"));
            }
            catch (WCMException e) {
                logger.error((Object)"\u83b7\u53d6\u53c2\u6570PUBLISHTASK_RETRYTIMES_FOR_SCM\u51fa\u73b0\u9519\u8bef\uff01", (Throwable)e);
            }
            this.setInited(true);
            logger.debug((Object)"publish task cache is inited...");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reinit() throws WCMException {
        if (this.isInitiating()) {
            logger.error((Object)"The SCM MicroContent publish Task Queue is initiating, it cannot be reinited at this moment!");
        }
        if (this.isSlaveNode()) {
            SCMMCPublishTask sCMMCPublishTask = m_locker_task;
            synchronized (sCMMCPublishTask) {
                m_locker_task.notifyAll();
            }
        }
        this.clearCache();
        this.init();
        return true;
    }

    public void clearCache() {
        m_oPublishTaskCache = null;
        m_oPublishingSCMMicroContentsCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!this.isListenning(_oObjAdded)) {
            return;
        }
        if (this.isInitiating()) {
            logger.error((Object)"the SCM MicroContent Publish Cache is initiating, it could not be added yet.");
        }
        Object object = this;
        synchronized (object) {
            logger.debug((Object)"put into the m_oPublishTaskCache...");
            m_oPublishTaskCache.put(_oObjAdded.getId(), (SCMMCPublishTask)_oObjAdded);
            logger.debug((Object)"put into the m_oPublishingSCMMicroContentsCache...");
            int scmmcid = ((SCMMCPublishTask)_oObjAdded).getSCMMCID();
            SCMMCPublishTasks oCurrTasks = null;
            oCurrTasks = m_oPublishingSCMMicroContentsCache.containsKey(scmmcid) ? m_oPublishingSCMMicroContentsCache.get(scmmcid) : new SCMMCPublishTasks(User.getSystem());
            oCurrTasks.addElement((SCMMCPublishTask)_oObjAdded);
            m_oPublishingSCMMicroContentsCache.put(scmmcid, oCurrTasks);
        }
        object = m_locker_task;
        synchronized (object) {
            m_locker_task.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!this.isListenning(_oObjDeleted)) {
            return;
        }
        if (this.isInitiating()) {
            logger.error((Object)"the SCM MicroContent Publish Cache is initiating, it could not be deleted yet.");
        }
        SCMMCPublishTaskCacheMgr sCMMCPublishTaskCacheMgr = this;
        synchronized (sCMMCPublishTaskCacheMgr) {
            m_oPublishTaskCache.remove(_oObjDeleted.getId());
            int scmmcid = ((SCMMCPublishTask)_oObjDeleted).getSCMMCID();
            SCMMCPublishTasks oCurrTasks = m_oPublishingSCMMicroContentsCache.get(scmmcid);
            if (oCurrTasks != null && oCurrTasks.size() > 0) {
                SCMMCPublishTasks oTempTasks = SCMMCPublishTasks.createNewInstance(User.getSystem());
                SCMMCPublishTask oTempTask = null;
                for (int i = 0; i < oCurrTasks.size(); ++i) {
                    oTempTask = (SCMMCPublishTask)oCurrTasks.getAt(i);
                    if (oTempTask == null || oTempTask.getId() == _oObjDeleted.getId()) continue;
                    oTempTasks.addElement(oTempTask);
                }
                m_oPublishingSCMMicroContentsCache.put(scmmcid, oTempTasks);
            } else {
                m_oPublishingSCMMicroContentsCache.remove(scmmcid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!this.isListenning(_oObjModified)) {
            return;
        }
        if (this.isInitiating()) {
            logger.error((Object)"the SCM MicroContent Publish Cache is initiating, it could not be modified yet.");
        }
        if (SCMMCPublishTaskCacheMgr.getRunningTask() != null && SCMMCPublishTaskCacheMgr.getRunningTask().getId() == _oObjModified.getId()) {
            logger.error((Object)"\u4fee\u6539\u7684\u53d1\u5e03\u4efb\u52a1\u6b63\u5728\u53d1\u5e03\u4e2d\uff0c\u65e0\u6cd5\u4fee\u6539\uff01");
        }
        Object object = this;
        synchronized (object) {
            int nIndex;
            m_oPublishTaskCache.put(((SCMMCPublishTask)_oObjModified).getId(), (SCMMCPublishTask)_oObjModified);
            int scmmcid = ((SCMMCPublishTask)_oObjModified).getSCMMCID();
            SCMMCPublishTasks oCurrTasks = m_oPublishingSCMMicroContentsCache.get(scmmcid);
            if (oCurrTasks != null && (nIndex = oCurrTasks.indexOf(_oObjModified.getId())) >= 0) {
                SCMMCPublishTask oRemovingTask = (SCMMCPublishTask)oCurrTasks.getAt(nIndex);
                oCurrTasks.remove(oRemovingTask, false);
                oCurrTasks.addElement((SCMMCPublishTask)_oObjModified);
                m_oPublishingSCMMicroContentsCache.put(scmmcid, oCurrTasks);
            }
        }
        object = m_locker_task;
        synchronized (object) {
            m_locker_task.notifyAll();
        }
    }

    private boolean isInited() {
        return m_bIsInited;
    }

    private boolean isInitiating() {
        return m_bIsInitiating;
    }

    private void setInitiating(boolean b) {
        m_bIsInitiating = b;
    }

    private void setInited(boolean b) {
        m_bIsInited = b;
    }

    private boolean isListenning(BaseObj _oObjAdded) {
        return _oObjAdded instanceof SCMMCPublishTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    SCMMCPublishTask sCMMCPublishTask = m_locker_task;
                    synchronized (sCMMCPublishTask) {
                        try {
                            m_task = this.getNextTask();
                        }
                        catch (WCMException e) {
                            e.printStackTrace();
                            logger.error((Object)"\u83b7\u53d6\u4e0b\u4e00\u4e2a\u5fae\u535a\u53d1\u5e03\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
                        }
                        if (m_task == null) {
                            try {
                                if (wait_interval == -1L) {
                                    m_locker_task.wait();
                                } else {
                                    logger.debug((Object)("next task is null, wait for " + wait_interval + " ms ...."));
                                    m_locker_task.wait(wait_interval);
                                }
                            }
                            catch (InterruptedException e) {
                                try {
                                    Thread.sleep(30000L);
                                }
                                catch (InterruptedException e1) {
                                    logger.debug((Object)"\u5fae\u535a\u53d1\u5e03\u961f\u5217\u7ebf\u7a0b\u4f11\u7720\u5931\u8d25\uff01");
                                    e1.printStackTrace();
                                }
                                e.printStackTrace();
                            }
                            wait_interval = -1L;
                        }
                        if (m_task == null) continue;
                    }
                    int nPriority = m_task.getPriority();
                    if (nPriority == 0) {
                        if (m_task.isScheduledTask()) {
                            Thread.currentThread().setPriority(9);
                        } else {
                            Thread.currentThread().setPriority(5);
                        }
                    } else {
                        Thread.currentThread().setPriority(nPriority);
                    }
                    SCMMCPublishTaskCacheMgr sCMMCPublishTaskCacheMgr = this;
                    synchronized (sCMMCPublishTaskCacheMgr) {
                        boolean bIsHasRight;
                        User oPublishOwner;
                        Account oCurrentAccount;
                        block66: {
                            m_bIsRunning = true;
                            oCurrentAccount = null;
                            try {
                                oCurrentAccount = m_task.getAccount();
                            }
                            catch (WCMException e) {
                                logger.error((Object)("\u83b7\u53d6\u5f53\u524d\u53d1\u5e03\u4efb\u52a1\u7684\u5fae\u535a\u8d26\u53f7\u51fa\u73b0\u5f02\u5e38\uff01\u5ffd\u7565\u5f53\u524d\u4efb\u52a1[" + m_task.getId() + "]..."), (Throwable)e);
                                m_bIsRunning = false;
                                this.reSetRunningParemeters();
                                continue;
                            }
                            logger.debug((Object)("got the publishing account[" + oCurrentAccount.getAccountName() + "]"));
                            try {
                                m_taskContent = m_task.getSCMMicroContent();
                            }
                            catch (WCMException e) {
                                logger.error((Object)("\u83b7\u53d6\u5f53\u524d\u53d1\u5e03\u4efb\u52a1\u7684\u5fae\u535a\u51fa\u73b0\u5f02\u5e38\uff01\u5ffd\u7565\u5f53\u524d\u4efb\u52a1[" + m_task.getId() + "]..."), (Throwable)e);
                                m_bIsRunning = false;
                                this.reSetRunningParemeters();
                                continue;
                            }
                            logger.debug((Object)("got the publishing scmmc[" + m_taskContent.getContent() + "]"));
                            oPublishOwner = null;
                            if (m_taskContent != null) {
                                oPublishOwner = m_taskContent.getCrUser();
                            }
                            bIsHasRight = false;
                            try {
                                ContextHelper.initContext(oPublishOwner);
                                if (oCurrentAccount == null || oPublishOwner == null) break block66;
                                bIsHasRight = SCMAuthServer.hasRightInAccount(oPublishOwner, oCurrentAccount, 44);
                            }
                            catch (Exception e) {
                                logger.debug((Object)("\u53d1\u5e03\u5fae\u535a\u5931\u8d25\uff01\u53d1\u5e03\u5fae\u535a\u7528\u6237\u5df2\u5931\u53bb\u5bf9\u5fae\u535a\u8d26\u53f7\u7684\u6743\u9650\uff01\u5ffd\u7565\u5f53\u524d\u4efb\u52a1[" + m_task.getId() + "]..."), (Throwable)e);
                                this.m_bHasWarnings = true;
                                this.m_sException = oPublishOwner.getName() + "\u5df2\u65e0\u5fae\u535a\u8d26\u53f7[" + oCurrentAccount.getAccountName() + "]\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u53d1\u5e03\u5fae\u535a\uff01";
                                try {
                                    m_task.validCanEditAndLock(oPublishOwner);
                                    m_task.setErrorMsg(this.m_sException);
                                    m_task.save(oPublishOwner);
                                }
                                catch (WCMException e1) {
                                    logger.error((Object)"\u4fee\u6539\u53d1\u5e03\u4efb\u52a1\u5c5e\u6027\u5931\u8d25...", (Throwable)e1);
                                }
                                finally {
                                    m_task.unlock();
                                }
                                m_bIsRunning = false;
                                this.reSetRunningParemeters();
                                continue;
                            }
                        }
                        Accounts oAccounts = new Accounts(oPublishOwner);
                        try {
                            oAccounts.addElement(oCurrentAccount);
                        }
                        catch (WCMException e) {
                            logger.debug((Object)"\u6784\u9020Accounts\u96c6\u5408\u5bf9\u8c61\u629b\u9519\uff01", (Throwable)e);
                            this.m_bHasWarnings = true;
                            this.m_sException = "\u6784\u9020Accounts\u96c6\u5408\u5bf9\u8c61\u629b\u9519\uff01";
                            try {
                                m_task.validCanEditAndLock(oPublishOwner);
                                m_task.setErrorMsg(this.m_sException);
                                m_task.save(oPublishOwner);
                            }
                            catch (WCMException e1) {
                                logger.error((Object)"\u4fee\u6539\u53d1\u5e03\u4efb\u52a1\u5c5e\u6027\u5931\u8d25...", (Throwable)e1);
                            }
                            finally {
                                m_task.unlock();
                            }
                            m_bIsRunning = false;
                            this.reSetRunningParemeters();
                            continue;
                        }
                        if (bIsHasRight && !this.m_bHasWarnings) {
                            boolean isRetweeted = m_taskContent.isRetweeted();
                            this.m_dtStart = CMyDateTime.now();
                            try {
                                if (isRetweeted) {
                                    logger.debug((Object)"forwading the publishing task...");
                                    HashMap<String, Integer> oParamter = new HashMap<String, Integer>();
                                    oParamter.put("SCMMicroContentID", m_taskContent.getId());
                                    this.m_oSCMMicroContentMgr.forwardMicroContent(oAccounts, m_taskContent.getContent(), m_taskContent.getRetweetedID(), oParamter);
                                } else {
                                    logger.debug((Object)"creating the publishin task...");
                                    this.m_oSCMMicroContentMgr.createMicroContent(oAccounts, m_taskContent, new HashMap());
                                }
                            }
                            catch (Exception e) {
                                logger.error((Object)"\u53d1\u5e03\u5fae\u535a\u5230\u5fae\u535a\u5e73\u53f0\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
                                this.m_bHasWarnings = true;
                                this.m_sException = e.getMessage();
                                if (this.m_sException.indexOf("<--") >= 0) {
                                    this.m_sException = this.m_sException.substring(0, this.m_sException.indexOf("<--"));
                                }
                                this.m_nResult = 9;
                                e.printStackTrace();
                            }
                            this.m_dtEnd = CMyDateTime.now();
                        }
                        m_bIsRunning = false;
                        if (this.m_bHasWarnings) {
                            logger.debug((Object)("task failed [" + this.m_sException + "]..."));
                            try {
                                m_task.validCanEditAndLock(oPublishOwner);
                                m_task.setStartTime(this.m_dtStart);
                                m_task.setEndTime(this.m_dtEnd);
                                if (this.m_sException.indexOf("[ERR-") >= 0 && this.m_sException.indexOf("<--") >= 0) {
                                    this.m_sException = this.m_sException.substring(this.m_sException.indexOf("[ERR-"), this.m_sException.indexOf("<--"));
                                }
                                m_task.setErrorMsg(this.m_sException);
                                m_task.setPublishStatus(this.m_nResult);
                                m_task.setAttempts(m_task.getAttempts() + 1);
                                m_task.save(oPublishOwner);
                            }
                            catch (Exception e) {
                                logger.error((Object)"\u4fdd\u5b58\u5f53\u524d\u4efb\u52a1\u7684\u5f02\u5e38\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
                                e.printStackTrace();
                            }
                            finally {
                                m_task.unlock();
                            }
                        } else {
                            try {
                                m_taskContent.validCanEditAndLock(oPublishOwner);
                                m_taskContent.setStatus(10);
                                m_taskContent.save(oPublishOwner);
                            }
                            catch (WCMException e) {
                                logger.error((Object)"\u4fee\u6539\u5fae\u535a\u7684\u53d1\u5e03\u72b6\u6001\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
                                e.printStackTrace();
                            }
                            finally {
                                if (m_taskContent.isLocked()) {
                                    m_taskContent.unlock();
                                }
                            }
                            logger.debug((Object)"task finished, delete it...");
                            try {
                                m_task.delete(oPublishOwner);
                            }
                            catch (WCMException e) {
                                logger.error((Object)"\u5220\u9664\u5f53\u524d\u4efb\u52a1\u7684\u5f02\u5e38\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
                                e.printStackTrace();
                            }
                        }
                        this.reSetRunningParemeters();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            logger.error((Object)"\u6267\u884c\u4e0b\u4e00\u6b21\u4efb\u52a1\u524d\u95f4\u9699\u88ab\u610f\u5916\u4e2d\u65ad\uff01", (Throwable)e);
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.debug((Object)"\u5fae\u535a\u53d1\u5e03\u961f\u5217\u53d1\u5e03\u5931\u8d25\uff01");
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.isSlaveNode() && m_bIsRunning) {
            SCMMCPublishTask sCMMCPublishTask = m_locker_task;
            synchronized (sCMMCPublishTask) {
                m_locker_task.notifyAll();
            }
        }
        this.m_zStarted = false;
    }

    public static SCMMCPublishTask getRunningTask() {
        return m_bIsRunning ? m_task : null;
    }

    public static SCMMicroContent getRunningPublishContent() {
        return m_bIsRunning ? m_taskContent : null;
    }

    public void start() {
        if (this.m_zStarted) {
            logger.debug((Object)"\u5fae\u535a\u53d1\u5e03\u961f\u5217\u7ebf\u7a0b\u5df2\u7ecf\u542f\u52a8\uff0c\u8fd4\u56de\u4e0d\u518d\u542f\u52a8\uff01");
            return;
        }
        if (this.isSlaveNode()) {
            logger.debug((Object)"\u6b64\u8282\u70b9\u975e\u4e3b\u8282\u70b9\u56e0\u6b64\u7ebf\u7a0b\u4e0d\u518d\u542f\u52a8\uff0c\u8fd4\u56de\u4e0d\u518d\u542f\u52a8\uff01");
            return;
        }
        logger.debug((Object)"start the worker thread...");
        new Thread(this).start();
        this.m_zStarted = true;
        logger.debug((Object)"the tread is started...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.clearCache();
        if (this.isSlaveNode()) {
            logger.debug((Object)"\u6b64\u8282\u70b9\u975e\u4e3b\u8282\u70b9\u56e0\u6b64\u7ebf\u7a0b\u4e0d\u518d\u542f\u52a8\uff0c\u8fd4\u56de\u4e0d\u8fdb\u884c\u6e05\u7406\u64cd\u4f5c\uff01");
            return;
        }
        if (m_bIsRunning) {
            SCMMCPublishTask sCMMCPublishTask = m_locker_task;
            synchronized (sCMMCPublishTask) {
                m_locker_task.notifyAll();
            }
        }
        m_bIsRunning = false;
        this.reSetRunningParemeters();
        this.m_oSCMMicroContentMgr = null;
    }

    private void reSetRunningParemeters() {
        m_taskContent = null;
        m_task = null;
        this.m_dtEnd = null;
        this.m_dtStart = null;
        this.m_nResult = 10;
        this.m_bHasWarnings = false;
        this.m_sException = "";
    }

    /*
     * Enabled aggressive block sorting
     */
    private SCMMCPublishTask getNextTask() throws WCMException {
        SCMMCPublishTask oResult = null;
        User oSysUser = User.getSystem();
        if (m_oPublishTaskCache.isEmpty()) return oResult;
        LinkedList<SCMMCPublishTask> oPublishingTasks = new LinkedList<SCMMCPublishTask>(m_oPublishTaskCache.values());
        do {
            SCMMCPublishTask oNextTask;
            if ((oNextTask = (SCMMCPublishTask)oPublishingTasks.poll()) == null) {
                return oResult;
            }
            int nTaskPublishStatus = oNextTask.getPublishStatus();
            if (nTaskPublishStatus == 8) {
                logger.debug((Object)"the first task is expried, ingoring this task...");
                continue;
            }
            if (nTaskPublishStatus == 9 && oNextTask.getAttempts() >= nRetryTimes) {
                logger.debug((Object)("the first task failed for more than " + nRetryTimes + " times, ingoring this task..."));
                continue;
            }
            if (nTaskPublishStatus == 20) {
                SCMMicroContent oTaskSCMMC = oNextTask.getSCMMicroContent();
                if (oTaskSCMMC == null) {
                    logger.debug((Object)"the scm microcontent of task is null....");
                    continue;
                }
                int nSCMMCPublishSatus = oTaskSCMMC.getStatusId();
                if (nSCMMCPublishSatus == 30 || nSCMMCPublishSatus == 10) {
                    logger.debug((Object)"the auditor gave this task a pass, it could be published...");
                    oNextTask.validCanEditAndLock(oSysUser);
                    if (oNextTask.isScheduledTask()) {
                        oNextTask.setPublishStatus(1);
                        nTaskPublishStatus = 1;
                    } else {
                        oNextTask.setPublishStatus(30);
                        nTaskPublishStatus = 30;
                    }
                    oNextTask.save(oSysUser);
                } else {
                    logger.debug((Object)"the first task is under audition, ingoring this task...");
                    continue;
                }
            }
            if (oNextTask.isScheduledTask() && nTaskPublishStatus == 1) {
                CMyDateTime oScheduledTime = oNextTask.getScheduleTime();
                long nDiffTime = oScheduledTime.compareTo(CMyDateTime.now());
                if (nDiffTime >= 0L && nDiffTime <= 60000L) {
                    logger.debug((Object)"the scheduled task is to the publishing point...");
                    oNextTask.validCanEditAndLock(oSysUser);
                    oNextTask.setPublishStatus(30);
                    oNextTask.setPriority(10);
                    oNextTask.save(oSysUser);
                    nTaskPublishStatus = 30;
                } else {
                    if (nDiffTime < 0L) {
                        logger.debug((Object)"the scheduled task is expried, ingnoring this task...");
                        oNextTask.validCanEditAndLock(oSysUser);
                        oNextTask.setPublishStatus(8);
                        oNextTask.setErrorMsg("\u5b9a\u65f6\u53d1\u5e03\u5df2\u5931\u6548\uff01\u60a8\u53ef\u7acb\u5373\u91cd\u65b0\u53d1\u5e03\u8be5\u5fae\u535a\u3002");
                        oNextTask.save(oSysUser);
                        nTaskPublishStatus = 8;
                        continue;
                    }
                    if (wait_interval != -1L && nDiffTime >= wait_interval) continue;
                    wait_interval = nDiffTime - 20000L;
                    continue;
                }
            }
            if (nTaskPublishStatus != 30 && (nTaskPublishStatus != 9 || oNextTask.getAttempts() >= nRetryTimes)) continue;
            logger.debug((Object)"got the right task, return it right now...");
            oResult = oNextTask;
        } while (oResult == null);
        return oResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOnMCStateChange(BaseObj _oChangedSCMMC) {
        SCMMCPublishTask sCMMCPublishTask = m_locker_task;
        synchronized (sCMMCPublishTask) {
            m_locker_task.notifyAll();
        }
    }

    static {
        m_taskContent = null;
        m_task = null;
        m_locker_task = new SCMMCPublishTask();
        m_bIsRunning = false;
        wait_interval = -1L;
        nRetryTimes = 0;
    }
}

