/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.ids;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.UserMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class ActorHelper {
    private static Logger logger = Logger.getLogger(ActorHelper.class);

    public static UserMgr getUserMgr() {
        return (UserMgr)DreamFactory.createObjectById("UserMgr");
    }

    public static GroupMgr getGroupMgr() {
        return (GroupMgr)DreamFactory.createObjectById("GroupMgr");
    }

    public static String[][] getGroupInfos(String groupPath) {
        if (groupPath == null) {
            return new String[0][0];
        }
        String[] paths = groupPath.split("/");
        String[][] names = new String[2][paths.length];
        for (int i = 0; i < paths.length; ++i) {
            names[0][i] = paths[i].split("#")[0];
            names[1][i] = paths[i].split("#")[1];
        }
        return names;
    }

    public static Group saveGroup(SSOGroup _group, Group currGroup, int parentId) throws WCMException {
        ContextHelper.initContext(User.getSystem());
        if (currGroup == null) {
            currGroup = Group.createNewInstance();
            currGroup.setParent(parentId);
            currGroup.setCrUser(ContextHelper.getLoginUser());
        }
        currGroup.setName(_group.getGroupDisplayName());
        currGroup.setDesc(_group.getGroupDisplayName());
        currGroup.setGroupOrder(Integer.parseInt(_group.getProperty("displayOrder")));
        currGroup.setProperty("IdsGroupId", _group.getGroupId());
        ActorHelper.getGroupMgr().save(currGroup);
        return currGroup;
    }

    public static Group getGroupFromSSOGroup(SSOGroup _group) {
        String sSSOGroupId = _group.getGroupId();
        String sWhere = "NAMEINIDS='" + sSSOGroupId + "'";
        try {
            WCMFilter filter = new WCMFilter("", sWhere, "");
            Groups groups = Groups.openWCMObjs(User.getSystem(), filter);
            if (groups.size() > 0) {
                return (Group)groups.getAt(0);
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u7ec4\u7ec7\u5931\u8d25\uff0c", (Throwable)e);
            return null;
        }
    }

    public static User getUserFromSSOUser(SSOUser _user) {
        return User.findByName(_user.getUserName());
    }
}

