/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.store.impl;

import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreParser;
import com.trs.infra.util.store.RandomAccessFileStore;
import com.trs.infra.util.store.RandomAccessFileStoreParser;
import com.trs.infra.util.store.impl.OSSFileStore;
import com.trs.infra.util.store.impl.OSSRandomAccessFileStore;

public class OSSFileStoreParser
implements FileStoreParser,
RandomAccessFileStoreParser {
    @Override
    public String getProtocol() {
        return "oss:";
    }

    @Override
    public FileStore getFileStore(String path) {
        return new OSSFileStore(path);
    }

    @Override
    public FileStore getFileStore(String parent, String child) {
        String path = "";
        path = parent.endsWith("/") ? parent + child : parent + "/" + child;
        return new OSSFileStore(path);
    }

    @Override
    public RandomAccessFileStore getRandomAccessFileStore(String pathname, String mode) {
        return new OSSRandomAccessFileStore(pathname, mode);
    }
}

