/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.SybaseASEText;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SybaseASE
extends DBType {
    public static final DataType BIT = new DataType("BIT", -7, 1);
    public static final DataType TINYINT = new DataType("TINYINT", -6, 1);
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, 2);
    public static final DataType INT = new DataType("INT", 4, 4);
    public static final DataType NUMERIC = new DataType("NUMERIC", 2, 9);
    public static final DataType REAL = new DataType("REAL", 7, 4);
    public static final DataType FLOAT = new DataType("FLOAT", 6, 8);
    public static final DataType DECIMAL = new DataType("DECIMAL", 3, 9);
    public static final DataType MONEY = new DataType("MONEY", 3, 8);
    public static final DataType SMALLMONEY = new DataType("SMALLMONEY", 3, 4);
    public static final DataType BINARY = new DataType("BINARY", -2);
    public static final DataType VARBINARY = new DataType("VARBINARY", -3);
    public static final DataType IMAGE = new DataType("IMAGE", -4, 16);
    public static final DataType CHAR = new DataType("CHAR", 1, -8000);
    public static final DataType NCHAR = new DataType("NCHAR", 1, -4000);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -8000);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -4000);
    public static final DataType TEXT = new DataType("TEXT", -1, 16);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93, 8);
    public static final DataType DATETIME = new DataType("DATETIME", 93, 8);
    public static final DataType SMALLDATETIME = new DataType("SMALLDATETIME", 93, 4);
    static final DataType[] m_allDataTypes = new DataType[]{BINARY, BIT, CHAR, DATETIME, DECIMAL, FLOAT, IMAGE, INT, MONEY, NCHAR, NUMERIC, NVARCHAR, REAL, SMALLDATETIME, SMALLINT, SMALLMONEY, TEXT, TIMESTAMP, TINYINT, VARBINARY, VARCHAR};
    static final DataType[] m_supportedDataTypes = new DataType[]{SMALLINT, TINYINT, INT, NUMERIC, NVARCHAR, DATETIME, FLOAT, NUMERIC};

    public SybaseASE() {
        super("Sybase ASE", "com.sybase.jdbc2.jdbc.SybDriver", true);
    }

    public SybaseASE(String _sName, String _sDriverClass, boolean _bSupportStoredProc) {
        super(_sName, _sDriverClass, true);
    }

    @Override
    protected void registerDBInfo() {
        this.registerColumnType(-7, "tinyint");
        this.registerColumnType(-5, "numeric(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "datetime");
        this.registerColumnType(92, "datetime");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "image");
        this.registerColumnType(2005, "text");
    }

    @Override
    public String sqlFilterForClob(String _sFieldName, String _sValue) {
        return " patindex('%" + CMyString.filterForSQL(_sValue) + "%'," + _sFieldName + ")>0 ";
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2) {
        return _strSQL1 + "+" + _strSQL2;
    }

    @Override
    public String sqlAddField(String _sTableName, String _sFieldName, String _sFieldType, int _nMaxLength, boolean _bNullable, String _sDefaultValue, int _nScale) {
        String strSQL = "ALTER TABLE " + _sTableName + " ADD " + _sFieldName + " " + _sFieldType;
        DataType dataType = this.getDataType(_sFieldType);
        if (dataType == null) {
            return null;
        }
        if (dataType.isLengthDefinedByUser()) {
            strSQL = _nScale > 0 ? strSQL + "(" + _nMaxLength + ", " + _nScale + ")" : strSQL + "(" + _nMaxLength + ")";
        }
        if (_bNullable) {
            strSQL = strSQL + " NULL";
        } else {
            if (_sDefaultValue != null) {
                strSQL = strSQL + " DEFAULT ";
                strSQL = dataType.isCharData() ? strSQL + "'" + CMyString.filterForSQL(_sDefaultValue) + "'" : strSQL + _sDefaultValue;
            }
            strSQL = strSQL + " NOT NULL ";
        }
        return strSQL;
    }

    @Override
    public String sqlConcatStr(String[] _strSQLs) {
        String sRet = _strSQLs[0];
        for (int i = 1; i < _strSQLs.length; ++i) {
            sRet = sRet + "+" + _strSQLs[i];
        }
        return sRet;
    }

    @Override
    public boolean canWriteTextDirectly() {
        return true;
    }

    @Override
    public String sqlDateField(String _sDateField) {
        return _sDateField;
    }

    @Override
    public String sqlFilterOneDay(String _sFieldName, String _sDateTime, String _sFormat) {
        return "DateDiff(day," + _sFieldName + ",'" + _sDateTime + "')=0";
    }

    @Override
    public String sqlDateTime(String _sDateTime, String _sFormat) {
        return "'" + _sDateTime + "'";
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2, String _strSQL3) {
        return _strSQL1 + "+" + _strSQL2 + "+" + _strSQL3;
    }

    @Override
    public String sqlDate(String _sDate) {
        return "'" + _sDate + "'";
    }

    @Override
    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    @Override
    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    @Override
    public String sqlGetSysDate() {
        return "GETDATE()";
    }

    @Override
    public String sqlDropField(String _sTableName, String _sFieldNames) throws Exception {
        return "ALTER TABLE " + _sTableName + " DROP " + _sFieldNames;
    }

    @Override
    public String encodeStrToWrite(String _strSrc) {
        return _strSrc;
    }

    @Override
    public String initQuerySQL(String _strSql, int _nStartIndex, int _nSize) {
        return _strSql;
    }

    @Override
    public String sqlQueryTableInfos(String _sOwnerUser) {
        String strSQL = "SELECT * FROM WCM_ViewCOLUMNS ORDER BY TABLE_NAME, COLUMN_ID";
        return strSQL;
    }

    @Override
    public String sqlQueryTableInfo(String _sOwnerUser, String _sTableName) {
        String strSQL = "SELECT * FROM WCM_ViewCOLUMNS WHERE TABLE_NAME='" + _sTableName.toUpperCase() + "' ORDER BY TABLE_NAME, COLUMN_ID";
        return strSQL;
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, int p_nFieldIndex) throws CMyException {
        return SybaseASEText.getClob(p_rsData, p_bJdbcIs2, p_nFieldIndex);
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, String p_sFieldName) throws CMyException {
        return SybaseASEText.getClob(p_rsData, p_bJdbcIs2, p_sFieldName);
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        return SybaseASEText.setClob(p_oConn, p_sTableName, p_sWhere, p_sIdFieldName, p_sClobFieldName, p_sValue);
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        return SybaseASEText.setClob(p_oConn, p_sTableName, p_sWhere, p_sIdFieldName, p_asFieldsAndValues);
    }

    @Override
    public String sqlGetNextId() {
        return "{call sp_getNextId(?,?,?)}";
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public boolean canDropField() {
        return false;
    }

    @Override
    public void setStringFieldValue(PreparedStatement _oPreStmt, int _nIndex, String _sValue) throws Exception {
        if ("".equals(_sValue)) {
            _oPreStmt.setString(_nIndex, null);
        } else {
            _oPreStmt.setString(_nIndex, _sValue);
        }
    }
}

