/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.store.FileService;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlDocWithDom4j {
    private static final String DEFAUTL_ENCODING = "utf-8";

    public static Document parse(String _sXmlFile) throws DocumentException {
        SAXReader reader = new SAXReader();
        reader.setValidation(false);
        Document result = reader.read(_sXmlFile);
        return result;
    }

    public static Document parse(String _sXmlFile, String _sXslFile) throws DocumentException, TransformerException {
        Document result = XmlDocWithDom4j.parse(_sXmlFile);
        return XmlDocWithDom4j.styleDocument(result, _sXslFile);
    }

    public static void write(Document _document, String _sTargetFile) throws FileNotFoundException {
        try {
            XmlDocWithDom4j.write(_document, DEFAUTL_ENCODING, _sTargetFile);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Document _document, String _encoding, String _sTargetFile) throws UnsupportedEncodingException, FileNotFoundException {
        BufferedOutputStream os = new BufferedOutputStream(new FileService(_sTargetFile).getOutputStream());
        OutputFormat format = OutputFormat.createPrettyPrint();
        if (!XmlDocWithDom4j.isEmpty(_encoding)) {
            format.setEncoding(_encoding);
        }
        XMLWriter writer = null;
        try {
            writer = new XMLWriter((OutputStream)os, format);
            writer.write(_document);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                ((OutputStream)os).close();
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void write(Document _document, String _xslFile, String _encoding, String _result) throws TransformerException, UnsupportedEncodingException, FileNotFoundException {
        Document resultdoc = XmlDocWithDom4j.styleDocument(_document, _xslFile);
        XmlDocWithDom4j.write(resultdoc, _encoding, _result);
    }

    public static Document styleDocument(Document _document, String _stylesheet) throws TransformerException {
        if (XmlDocWithDom4j.isEmpty(_stylesheet)) {
            return _document;
        }
        StreamSource style = new StreamSource(_stylesheet);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(style);
        DocumentSource source = new DocumentSource(_document);
        DocumentResult result = new DocumentResult();
        transformer.transform((Source)source, (Result)result);
        Document transformedDoc = result.getDocument();
        return transformedDoc;
    }

    public static void transform(String _sSourceXml, String _sSourceXsl, String _sTarget) throws TransformerException, FileNotFoundException, DocumentException {
        try {
            XmlDocWithDom4j.transform(_sSourceXml, _sSourceXsl, DEFAUTL_ENCODING, _sTarget);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void transform(String _sSourceXml, String _sSourceXsl, String _encoding, String _sTarget) throws FileNotFoundException, DocumentException, TransformerException, UnsupportedEncodingException {
        Document source = XmlDocWithDom4j.parse(_sSourceXml);
        Document result = XmlDocWithDom4j.styleDocument(source, _sSourceXsl);
        XmlDocWithDom4j.write(result, _encoding, _sTarget);
    }

    public static void main(String[] args) {
        try {
            String fn = "e:\\dom4j.xml";
            Document doc = XmlDocWithDom4j.parse(fn);
            System.out.println(doc.nodeCount());
            System.out.println(doc.getRootElement().getName());
            List list = doc.getRootElement().element("properties").elements();
            for (int i = 0; i < list.size(); ++i) {
                Element ele = (Element)list.get(i);
                if (ele == null) continue;
                System.out.println(ele.getName() + ":" + ele.getText() + " hascon:" + ele.hasContent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

