/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.common;

public class ContextParameters {
    private static final int MAX_PARAMETERS = 10;
    public static final int SAVED_OBJID = 6;
    public static final int SCHEDULE_PUBTASK = 7;
    public static final int NESTED_TEMPLATE = 8;
    public static final int FILE_ENCODING = 9;
    private static final ThreadLocal s_tls = new ThreadLocal(){

        protected Object initialValue() {
            return new Object[10];
        }
    };

    private static final Object[] getTLS() {
        return (Object[])s_tls.get();
    }

    private static final void assertIndex(int index) {
        if (index < 0 || index >= 10) {
            String s = index + " out of 0-" + 10 + "]";
            throw new ArrayIndexOutOfBoundsException(s);
        }
    }

    public static final int getMaxIndex() {
        return 10;
    }

    public static final Object get(int index) {
        return ContextParameters.get(index, false);
    }

    public static final Object get(int index, boolean keep) {
        ContextParameters.assertIndex(index);
        Object[] tls = ContextParameters.getTLS();
        Object obj = tls[index];
        if (!keep) {
            tls[index] = null;
        }
        return obj;
    }

    public static final Object set(int index, Object parameter) {
        ContextParameters.assertIndex(index);
        Object[] tls = ContextParameters.getTLS();
        Object obj = tls[index];
        tls[index] = parameter;
        return obj;
    }

    public static final Object get0() {
        return ContextParameters.get(0);
    }

    public static final void set0(Object parameter) {
        ContextParameters.set(0, parameter);
    }

    public static final Object get1() {
        return ContextParameters.get(1);
    }

    public static final void set1(Object parameter) {
        ContextParameters.set(1, parameter);
    }

    public static final Object get2() {
        return ContextParameters.get(1);
    }

    public static final void set2(Object parameter) {
        ContextParameters.set(1, parameter);
    }
}

