/*
 * Decompiled with CFR 0.152.
 */
package com.trs.index.config;

import com.trs.index.config.TableDesc;
import com.trs.index.config.TableFieldDesc;
import com.trs.index.util.IndexUtil;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Sort;

public class IndexConfig {
    private String indexPath;
    private String relative;
    private String where;
    private Sort sortFile;
    private Map<String, TableDesc> tableDescMap = null;
    private List<TableDesc> tableDescList = new ArrayList<TableDesc>();
    private Map<String, TableFieldDesc> tableFieldDescMap = null;
    private List<TableFieldDesc> allTableFieldDescList = null;
    private List<String> quickSearchFieldList = null;
    private String status;
    private String sql;
    private String countSql;
    private WCMFilter filter;

    private void iniSql() {
        StringBuilder from = new StringBuilder();
        StringBuilder select = new StringBuilder();
        StringBuilder where = new StringBuilder();
        where.append(this.getRelative());
        if (!CMyString.isEmpty(this.getWhere())) {
            where.append(" AND ");
            where.append(this.getWhere());
        }
        WCMFilter _filter = new WCMFilter();
        List<TableDesc> tableDescList = this.getTableDescList();
        for (int i = 0; i < tableDescList.size(); ++i) {
            TableDesc tableDesc = tableDescList.get(i);
            from.append(tableDesc.getTableName() + ",");
            List<TableFieldDesc> tableFieldDescList = tableDesc.getTableFieldDescList();
            for (int j = 0; j < tableFieldDescList.size(); ++j) {
                TableFieldDesc tableField = tableFieldDescList.get(j);
                select.append(tableDesc.getTableName() + "." + tableField.getFieldName() + ",");
            }
        }
        select.deleteCharAt(select.length() - 1);
        from.deleteCharAt(from.length() - 1);
        _filter.setFrom(from.toString());
        _filter.setSelect("COUNT(RECID)");
        _filter.setWhere(where.toString());
        this.setCountSql(_filter.toSQL());
        _filter.setSelect(select.toString());
        this.setSql(_filter.toSQL());
        this.setFilter(_filter);
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getStatus() {
        if (CMyString.isEmpty(this.status)) {
            this.status = IndexUtil.getAllStatus();
        }
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Map<String, TableFieldDesc> getAllFieldMap() {
        return this.tableFieldDescMap;
    }

    public Sort getSortFile() {
        return this.sortFile;
    }

    public void setSortFile(Sort sortFile) {
        this.sortFile = sortFile;
    }

    public List<String> getQuickSearchFieldList() {
        if (this.quickSearchFieldList != null) {
            return this.quickSearchFieldList;
        }
        this.quickSearchFieldList = new ArrayList<String>();
        List<TableFieldDesc> list = this.getAllTableFieldDescList();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isQuickQuery()) continue;
            this.quickSearchFieldList.add(list.get(i).getFieldName());
        }
        return this.quickSearchFieldList;
    }

    public Map<String, TableFieldDesc> getTableFieldDescMap() {
        return this.tableFieldDescMap;
    }

    public void setTableFieldDescMap(Map<String, TableFieldDesc> tableFieldDescMap) {
        this.tableFieldDescMap = tableFieldDescMap;
    }

    public List<TableFieldDesc> getAllTableFieldDescList() {
        return this.allTableFieldDescList;
    }

    public Map<String, TableDesc> getTableDescMap() {
        return this.tableDescMap;
    }

    public void setTableDescMap(Map<String, TableDesc> tableDescMap) {
        this.tableDescMap = tableDescMap;
    }

    public void setAllTableFieldDescList(List<TableFieldDesc> allTableFieldDescList) {
        this.allTableFieldDescList = allTableFieldDescList;
    }

    public int getTableFieldSize() {
        return this.getAllFieldMap().size();
    }

    public TableFieldDesc getTableFieldDesc(String name) {
        return this.getAllFieldMap().get(name);
    }

    public List<TableDesc> getTableDescList() {
        return this.tableDescList;
    }

    public void setTableDescList(List<TableDesc> tableDescList) {
        if (this.tableFieldDescMap == null) {
            this.tableFieldDescMap = new HashMap<String, TableFieldDesc>();
        }
        if (this.allTableFieldDescList == null) {
            this.allTableFieldDescList = new ArrayList<TableFieldDesc>();
        }
        if (this.tableDescMap == null) {
            this.tableDescMap = new HashMap<String, TableDesc>();
        }
        for (int i = 0; i < tableDescList.size(); ++i) {
            List<TableFieldDesc> tableFieldDescList = tableDescList.get(i).getTableFieldDescList();
            this.allTableFieldDescList.addAll(tableFieldDescList);
            this.tableDescMap.put(tableDescList.get(i).getTableName(), tableDescList.get(i));
            for (int j = 0; j < tableFieldDescList.size(); ++j) {
                this.tableFieldDescMap.put(tableFieldDescList.get(j).getFieldName(), tableFieldDescList.get(j));
            }
        }
        this.tableDescList = tableDescList;
        this.iniSql();
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public String getRelative() {
        return this.relative;
    }

    public void setRelative(String relative) {
        this.relative = relative;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public WCMFilter getFilter() {
        return this.filter;
    }

    public void setFilter(WCMFilter filter) {
        this.filter = filter;
    }

    public String getCountSql() {
        return this.countSql;
    }

    public void setCountSql(String countSql) {
        this.countSql = countSql;
    }

    public String getSql() {
        return this.sql;
    }
}

