/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.filter.Filter;
import com.trs.components.wcm.filter.FilterOption;
import com.trs.components.wcm.filter.FilterOptionGroup;
import com.trs.components.wcm.filter.FilterOptionGroups;
import com.trs.components.wcm.filter.FilterOptions;
import com.trs.components.wcm.filter.Filters;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FilterMgr {
    private static Logger logger = Logger.getLogger(FilterMgr.class);
    private Map m_mOptionIdMapping;

    public Filters queryByChannel(Channel _channel, WCMFilter _filter) throws WCMException {
        if (_channel == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label1", "\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u7b5b\u9009\u5668\u6570\u636e\uff01"));
        }
        User oLoginUser = this.getLoginUser();
        boolean bHasViewRight = AuthServer.hasRight(oLoginUser, (CMSObj)_channel, 14);
        if (!bHasViewRight) {
            throw new WCMException(CMyString.format(I18NMessage.get(FilterMgr.class, "FilterMgr.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u680f\u76ee[{0}]\u4e0b\u7684\u7b5b\u9009\u5668\uff01"), new String[]{_channel.getDesc()}));
        }
        WCMFilter filter = new WCMFilter("", "ChannelId=?", "");
        filter.addSearchValues(_channel.getId());
        filter.mergeWith(_filter);
        return Filters.openWCMObjs(oLoginUser, filter);
    }

    public FilterOptionGroups queryGroupsByFilter(Filter _filter, WCMFilter _wcmfilter) throws WCMException {
        if (_filter == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label3", "\u7b5b\u9009\u5668\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u6b65\u9aa4\uff01"));
        }
        int nFilterId = _filter.getId();
        WCMFilter filter = new WCMFilter("", "FILTERID=?", "FORDER ASC");
        filter.addSearchValues(nFilterId);
        filter.mergeWith(_wcmfilter);
        return FilterOptionGroups.openWCMObjs(null, filter);
    }

    public FilterOptions queryFilterOptionsByGroup(FilterOptionGroup _group, WCMFilter _wcmfilter) throws WCMException {
        if (_group == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label4", "\u9009\u9879\u7ec4\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u6b65\u9aa4\uff01"));
        }
        int nGroupId = _group.getId();
        WCMFilter filter = new WCMFilter("", "GROUPID=?", "FORDER ASC");
        filter.addSearchValues(nGroupId);
        filter.mergeWith(_wcmfilter);
        return FilterOptions.openWCMObjs(null, filter);
    }

    public FilterOptions queryOptionsByFilter(Filter filter, WCMFilter _filter) throws WCMException {
        String sWhere = "exists(select 1 from xwcmfilteroptiongroup where xwcmfilteroptiongroup.filterOPTIONGROUPID = xwcmfilteroption.groupid and exists(select 1 from xwcmfilter where xwcmfilter.filterid = ? and xwcmfilter.filterid = xwcmfilteroptiongroup.filterid))";
        WCMFilter whereFilter = new WCMFilter("", sWhere, "FORDER ASC");
        whereFilter.addSearchValues(filter.getId());
        whereFilter.mergeWith(_filter);
        return FilterOptions.openWCMObjs(null, whereFilter);
    }

    public void deleteFilter(Filter _filter) throws WCMException {
        if (_filter == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label5", "\u5f85\u5220\u9664\u7684\u7b5b\u9009\u5668\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        FilterOptionGroups oFilterOptionGroups = this.queryGroupsByFilter(_filter, null);
        for (int i = oFilterOptionGroups.size() - 1; i >= 0; --i) {
            FilterOptionGroup oFilterOptionGroup = (FilterOptionGroup)oFilterOptionGroups.getAt(i);
            if (oFilterOptionGroup == null) continue;
            this.deleteFilterOptionGroup(oFilterOptionGroup);
        }
        _filter.delete();
    }

    public void deleteFilterOptionGroup(FilterOptionGroup _filterOptionGroup) throws WCMException {
        if (_filterOptionGroup == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label6", "\u5f85\u5220\u9664\u7684\u9009\u9879\u7ec4\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        FilterOptions oFilterOptions = this.queryFilterOptionsByGroup(_filterOptionGroup, null);
        for (int i = oFilterOptions.size() - 1; i >= 0; --i) {
            FilterOption oFilterOption = (FilterOption)oFilterOptions.getAt(i);
            if (oFilterOption == null) continue;
            this.deleteFilterOption(oFilterOption);
        }
        _filterOptionGroup.delete();
    }

    public void deleteFilterOption(FilterOption _option) throws WCMException {
        if (_option == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label7", "\u5f85\u5220\u9664\u7684\u9009\u9879\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        _option.delete();
    }

    public void copy(Filter _filter, Channels channels, User currUser) throws WCMException {
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.copy(_filter, channel, currUser);
        }
    }

    public void copy(Filter _filter, Channel channel, User currUser) throws WCMException {
        this.m_mOptionIdMapping = new HashMap();
        Filter filter = (Filter)_filter.cloneToNewObj();
        filter.setChannelId(channel.getId());
        filter.save(currUser);
        FilterOptionGroups groups = this.queryGroupsByFilter(_filter, null);
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            FilterOptionGroup group = (FilterOptionGroup)groups.getAt(i);
            if (group == null) continue;
            this.copy(group, filter, currUser);
        }
        this.afterFilterSave(filter);
    }

    private void afterFilterSave(Filter filter) throws WCMException {
        FilterOptions options = this.queryOptionsByFilter(filter, null);
        int nSize = options.size();
        for (int i = 0; i < nSize; ++i) {
            FilterOption option = (FilterOption)options.getAt(i);
            if (option == null) continue;
            boolean isChange = false;
            String sNotAllowOptions = option.getNotAllowedSelectOptions();
            if (!CMyString.isEmpty(sNotAllowOptions)) {
                String sNewOptions = this.getNewOptionIds(sNotAllowOptions);
                option.setNotAllowedSelectOptions(sNewOptions);
                isChange = true;
            }
            if (!isChange) continue;
            option.save(ContextHelper.getLoginUser());
        }
        String sDisabledOptions = filter.getPropertyAsString("disabledoptions");
        if (!CMyString.isEmpty(sDisabledOptions)) {
            String sNewOptions = this.getNewOptionIds(sDisabledOptions);
            filter.setPropertyWithString("disabledoptions", sNewOptions);
            filter.save(ContextHelper.getLoginUser());
        }
    }

    private void copy(FilterOptionGroup _optionGroup, Filter filter, User currUser) throws WCMException {
        FilterOptionGroup optionGroup = (FilterOptionGroup)_optionGroup.cloneToNewObj();
        optionGroup.setFilterId(filter.getId());
        optionGroup.save(currUser);
        FilterOptions options = this.queryFilterOptionsByGroup(_optionGroup, null);
        int nSize = options.size();
        for (int i = 0; i < nSize; ++i) {
            FilterOption option = (FilterOption)options.getAt(i);
            if (option == null) continue;
            this.copy(option, optionGroup, currUser);
        }
    }

    private void copy(FilterOption _option, FilterOptionGroup optionGroup, User currUser) throws WCMException {
        FilterOption option = (FilterOption)_option.cloneToNewObj();
        option.setGroupId(optionGroup.getId());
        String[] pics = new String[]{"FIRSTPIC", "SECONDPIC", "THIRDPIC"};
        for (int i = 0; i < pics.length; ++i) {
            String sPicFileName = _option.getPropertyAsString(pics[i]);
            if (CMyString.isEmpty(sPicFileName)) continue;
            FilesMan filesMan = FilesMan.getFilesMan();
            if (!filesMan.fileExists(sPicFileName)) {
                logger.error((Object)CMyString.format("\u7b5b\u9009\u5668\u56fe\u7247\u65f6\u56fe\u7247\u4e0d\u5b58\u5728[{0}]", new String[]{sPicFileName}));
                continue;
            }
            String sNewFileName = filesMan.copyWCMFile(sPicFileName, "P0");
            option.setPropertyWithString(pics[i], sNewFileName);
        }
        option.save(currUser);
        this.m_mOptionIdMapping.put(_option.getKey(), option.getKey());
    }

    private String getNewOptionIds(String sOldOptionIds) {
        if (CMyString.isEmpty(sOldOptionIds)) {
            return "";
        }
        int[] oldIds = CMyString.splitToInt(sOldOptionIds, ",");
        StringBuffer sbNewIds = new StringBuffer();
        for (int i = 0; i < oldIds.length; ++i) {
            Integer oNewId = (Integer)this.m_mOptionIdMapping.get(new Integer(oldIds[i]));
            if (oNewId == null) continue;
            sbNewIds.append(oNewId).append(",");
        }
        if (sbNewIds.length() > 0) {
            sbNewIds.setLength(sbNewIds.length() - 1);
        }
        return sbNewIds.toString();
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

