/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfigs;
import com.trs.components.common.publish.persistent.template.TempAppendixXmlConverter;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.components.common.publish.persistent.template.TemplateArguments;
import com.trs.components.common.publish.persistent.template.TemplateEmploys;
import com.trs.components.common.publish.persistent.template.TemplateXmlConverter;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ContentExtFieldXmlConverter;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.components.wcm.publish.WCMPubStatusConfigs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.List;
import org.dom4j.Element;

public class ChannelXmlConverter
extends BaseObjToXmlConverter {
    private String m_sChannelFieldList = null;
    private String m_sSiteFieldList = null;
    private boolean m_bWithChildren = false;
    private boolean m_bWithExtField = false;
    private boolean m_bWithTemp = false;
    private String m_sTempApdsPath;
    private TemplateEmployMgr m_employMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    private ContentExtFieldMgr m_extFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
    private TemplateMgr m_templateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
    private User m_currUser = User.getSystem();
    private ObjToXmlConverter m_converter;
    private ContentExtFieldXmlConverter m_extFieldConverter = new ContentExtFieldXmlConverter();

    public ChannelXmlConverter(String _sSiteFieldList, String _sChannelFieldList) {
        this.m_sChannelFieldList = _sChannelFieldList;
        this.m_sSiteFieldList = _sSiteFieldList;
    }

    @Override
    protected Element[] getChildElement(BaseObj _baseObj) throws WCMException {
        if (_baseObj == null) {
            throw new WCMException(10, I18NMessage.get(ChannelXmlConverter.class, "ChannelXmlConverter.label1", "\u65e0\u6548\u7684\u5bf9\u8c61[null]!"));
        }
        BaseChannel siteOrChnl = (BaseChannel)_baseObj;
        Element[] childEls = new Element[8];
        this.m_converter = new ObjToXmlConverter();
        childEls[1] = this.getFolderPubConfsEl(siteOrChnl);
        childEls[2] = this.getPubStatusConfsEl(siteOrChnl);
        childEls[3] = this.getChildrenEl(siteOrChnl);
        if (this.isWithExtField()) {
            childEls[4] = this.getExtFieldsEl(siteOrChnl);
        }
        if (this.isWithTemplates()) {
            childEls[0] = this.getTempEmploysEl(siteOrChnl);
            childEls[5] = this.getTemplatesEl(siteOrChnl);
            childEls[6] = this.getTempApdsEl(siteOrChnl);
        }
        childEls[7] = this.getTemplateArgs(siteOrChnl);
        return childEls;
    }

    private Element getTemplateArgs(BaseChannel siteOrChnl) throws WCMException {
        if (siteOrChnl.isSite()) {
            return null;
        }
        TemplateArguments args = new TemplateArguments(null);
        WCMFilter filter = new WCMFilter("", "employertype=? and employerid=?", "");
        filter.addSearchValues(siteOrChnl.getWCMType());
        filter.addSearchValues(siteOrChnl.getId());
        args.open(filter);
        return this.m_converter.toXmlElement(args, null);
    }

    private Element getTempEmploysEl(BaseChannel _siteOrChnl) throws WCMException {
        TemplateEmploys employs = this.m_employMgr.getEmploysOfEmployer(_siteOrChnl.getWCMType(), _siteOrChnl.getId());
        return this.m_converter.toXmlElement(employs, null);
    }

    private Element getFolderPubConfsEl(BaseChannel _siteOrChnl) throws WCMException {
        FolderPublishConfig pubConf = FolderPublishConfig.findOf(_siteOrChnl.getWCMType(), _siteOrChnl.getId());
        FolderPublishConfigs pubConfs = FolderPublishConfigs.createNewInstance(this.m_currUser);
        if (pubConf != null) {
            pubConfs.addElement(pubConf);
        }
        return this.m_converter.toXmlElement(pubConfs, null);
    }

    private Element getPubStatusConfsEl(BaseChannel _siteOrChnl) throws WCMException {
        WCMPubStatusConfig pubStatusConf = WCMPubStatusConfig.findOf(_siteOrChnl.getWCMType(), _siteOrChnl.getId());
        WCMPubStatusConfigs pubStatusConfs = WCMPubStatusConfigs.createNewInstance(this.m_currUser);
        if (pubStatusConf != null) {
            pubStatusConfs.addElement(pubStatusConf);
        }
        return this.m_converter.toXmlElement(pubStatusConfs, null);
    }

    private Element getChildrenEl(BaseChannel _siteOrChnl) throws WCMException {
        if (this.isWithChildren()) {
            List<Channel> children = _siteOrChnl.getChildren(this.m_currUser);
            return this.toXmlElement(children, null);
        }
        return this.m_converter.toXmlElement(Channels.createNewInstance(this.m_currUser), null);
    }

    private Element getExtFieldsEl(BaseChannel _siteOrChnl) throws WCMException {
        ContentExtFields extFields = null;
        extFields = this.isWithExtField() ? this.m_extFieldMgr.getExtFields(_siteOrChnl, null) : ContentExtFields.createNewInstance(this.m_currUser);
        return this.m_extFieldConverter.toXmlElement(extFields, null);
    }

    private Element getTemplatesEl(BaseChannel _siteOrChnl) throws WCMException {
        Templates templates = null;
        TemplateXmlConverter tempConverter = new TemplateXmlConverter();
        if (this.isWithTemplates()) {
            if (_siteOrChnl.isSite()) {
                IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_siteOrChnl);
                templates = this.m_templateMgr.getManagedTemplates(folder, -1, null, true);
            } else {
                templates = Templates.createNewInstance(this.m_currUser);
            }
        } else {
            return null;
        }
        return tempConverter.toXmlElement(templates, null);
    }

    private Element getTempApdsEl(BaseChannel _siteOrChnl) throws WCMException {
        if (this.isWithTemplates() && _siteOrChnl.isSite()) {
            TempAppendixes appendixes = this.m_templateMgr.getTempAppendixesInRoot(_siteOrChnl.getWCMType(), _siteOrChnl.getId(), null);
            TempAppendixXmlConverter tempApdConverter = new TempAppendixXmlConverter();
            tempApdConverter.initConverter(_siteOrChnl.getWCMType(), _siteOrChnl.getId(), this.m_sTempApdsPath);
            return tempApdConverter.toXmlElement(appendixes, null);
        }
        TempAppendixes appendixes = TempAppendixes.createNewInstance(this.m_currUser);
        return this.m_converter.toXmlElement(appendixes, null);
    }

    public boolean isWithChildren() {
        return this.m_bWithChildren;
    }

    public void setWithChildren(boolean _bWwithChildren) {
        this.m_bWithChildren = _bWwithChildren;
    }

    public boolean isWithExtField() {
        return this.m_bWithExtField;
    }

    public void setWithExtField(boolean _bWithExtField) {
        this.m_bWithExtField = _bWithExtField;
    }

    public boolean isWithTemplates() {
        return this.m_bWithTemp && this.m_sTempApdsPath != null;
    }

    public void setWithTemp(boolean _bWithTemp, String _sTempApdPath) throws WCMException {
        this.m_bWithTemp = _bWithTemp;
        if (_bWithTemp) {
            this.assertNotEmptyPath(_sTempApdPath);
            this.m_sTempApdsPath = CMyString.setStrEndWith(_sTempApdPath, File.separatorChar);
        }
    }

    private void assertNotEmptyPath(String _sPath) throws WCMException {
        if (_sPath == null || _sPath.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(ChannelXmlConverter.class, "ChannelXmlConverter.label2", "\u65e0\u6548\u7684\u8def\u5f84!"));
        }
    }

    @Override
    protected String getFieldList(BaseObj _currObj) {
        if (_currObj instanceof Channel) {
            return this.m_sChannelFieldList;
        }
        if (_currObj instanceof WebSite) {
            return this.m_sSiteFieldList;
        }
        return super.getFieldList(_currObj);
    }
}

