/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain.auth;

import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.RightHostFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.DocumentSubstanceImplBase;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;

public class DocumentRightHostImpl
extends DocumentSubstanceImplBase
implements IRightHost {
    private static final String[] RIGHT_TYPE_IDS = new String[]{"document"};
    private static final String[] RIGHT_TYPE_NAMES = new String[]{I18NMessage.get(DocumentRightHostImpl.class, "DocumentRightHostImpl.label1", "\u6587\u6863\u7c7b")};

    public DocumentRightHostImpl() {
    }

    public DocumentRightHostImpl(int _nId) throws WCMException {
        super(_nId);
    }

    public DocumentRightHostImpl(CMSObj _cmsObj) {
        super(_cmsObj);
    }

    @Override
    public void validateCanDoSetRight(User _user) throws WCMException {
        if (this.m_oCurrDocument == null) {
            throw new WCMException(I18NMessage.get(DocumentRightHostImpl.class, "DocumentRightHostImpl.label2", "\u6ca1\u6709\u6307\u5b9a\u9891\u9053\uff01"));
        }
        if (this.m_oCurrDocument.isDeleted()) {
            throw new WCMException(this.m_oCurrDocument.getTitle() + " [Document-" + this.m_oCurrDocument.getId() + I18NMessage.get(DocumentRightHostImpl.class, "DocumentRightHostImpl.label4", "]\u5df2\u7ecf\u88ab\u5220\u9664\uff01"));
        }
        int nRightIndex = 61;
        if (!DocumentAuthServer.hasRight(_user, (BaseChannel)this.m_oCurrDocument.getChannel(), this.m_oCurrDocument, nRightIndex)) {
            throw new WCMException(I18NMessage.get(DocumentRightHostImpl.class, "DocumentRightHostImpl.label5", "\u7528\u6237[") + _user.getName() + I18NMessage.get(DocumentRightHostImpl.class, "DocumentRightHostImpl.label6", "]\u5bf9\u4e8e\u6307\u5b9a\u7684\u6587\u6863[") + this.m_oCurrDocument.getTitle() + "][ID=" + this.m_oCurrDocument.getId() + I18NMessage.get(DocumentRightHostImpl.class, "DocumentRightHostImpl.label7", "]\u4e0d\u80fd\u8bbe\u7f6e\u6743\u9650\uff01"));
        }
    }

    @Override
    public IRightHost[] getChildren() {
        return null;
    }

    @Override
    public String[] getRightTypeIds() {
        return RIGHT_TYPE_IDS;
    }

    @Override
    public String[] getRightTypeNames() {
        return RIGHT_TYPE_NAMES;
    }

    @Override
    public IRightHost getParent() throws WCMException {
        return RightHostFactory.makeRightHostFrom(this.m_oCurrDocument.getChannel());
    }
}

