/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.publish.region.CellInfos;
import com.trs.components.wcm.publish.region.RegionEmployMgr;
import com.trs.components.wcm.publish.region.RegionEmploys;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.components.wcm.publish.region.RegionInfos;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import org.apache.log4j.Logger;

public class BaseChannelLCListener4Region
implements IObjectLCListenerOnDel {
    private static Logger s_logger = Logger.getLogger(BaseChannelLCListener4Region.class);

    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) {
        if (objDeleted instanceof BaseChannel) {
            RegionInfos oRegionInfos = null;
            try {
                oRegionInfos = this.getRegionInfosByObj((BaseChannel)objDeleted);
            }
            catch (WCMException e) {
                s_logger.error((Object)"\u83b7\u53d6\u5c5e\u4e8e\u5f53\u524d\u5bf9\u8c61\u4e0b\u7684\u5bfc\u8bfb\u96c6\u5408\u5931\u8d25\uff01", (Throwable)e);
            }
            if (oRegionInfos == null || oRegionInfos.size() == 0) {
                return;
            }
            int nSize = oRegionInfos.size();
            for (int i = 0; i < nSize; ++i) {
                RegionInfo oRegionInfo = (RegionInfo)oRegionInfos.getAt(i);
                if (oRegionInfo == null) continue;
                try {
                    oRegionInfo.delete();
                    this.deleteCellInfos(oRegionInfo);
                    this.deleteRegionEmploys(oRegionInfo);
                    continue;
                }
                catch (WCMException e) {
                    s_logger.error((Object)("\u5220\u9664\u6307\u5b9a\u5bfc\u8bfb\u3010" + oRegionInfo.getName() + "\u3011\u5931\u8d25\uff01"), (Throwable)e);
                }
            }
        } else {
            s_logger.error((Object)"\u5f53\u524d\u76d1\u542c\u7684\u5bf9\u8c61\u5fc5\u987b\u662f\u7ad9\u70b9\u6216\u8005\u680f\u76ee\uff01");
        }
    }

    private RegionInfos getRegionInfosByObj(BaseChannel oBaseChannel) throws WCMException {
        if (oBaseChannel == null) {
            return null;
        }
        int nObjType = oBaseChannel.getWCMType();
        int nObjId = oBaseChannel.getId();
        if (nObjType == 103) {
            return RegionInfos.findBySiteId(nObjId, null);
        }
        if (nObjType == 101) {
            return RegionInfos.findByChannelId(nObjId);
        }
        return null;
    }

    private void deleteCellInfos(RegionInfo region) throws WCMException {
        if (region == null) {
            return;
        }
        CellInfos cells = CellInfos.findCellInfos(region, null);
        if (cells != null) {
            cells.removeAll();
        }
    }

    private void deleteRegionEmploys(RegionInfo region) throws WCMException {
        RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
        RegionEmploys regionEmploys = regionEmployMgr.getRegionEmploysByRegion(region);
        if (regionEmploys != null) {
            regionEmploys.removeAll();
        }
    }
}

