/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.StringTokenizer;

public class ClassInfoMgr
implements IClassInfoMgr {
    @Override
    public void deleteClassInfo(User _currUser, ClassInfo _classInfo) throws WCMException {
        if (_classInfo == null) {
            return;
        }
        ClassInfos pChildrens = this.queryChildren(_currUser, _classInfo, null);
        int nSize = pChildrens.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo child = (ClassInfo)pChildrens.getAt(i);
            this.deleteClassInfo(_currUser, child);
        }
        _classInfo.delete(_currUser);
    }

    @Override
    public ClassInfos queryChildren(User _currUser, ClassInfo _classInfo, WCMFilter _extraFilter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ParentId=?", "ClassOrder desc");
        filter.addSearchValues(_classInfo == null ? 0 : _classInfo.getId());
        filter.mergeWith(_extraFilter);
        return ClassInfos.openWCMObjs(_currUser, filter);
    }

    @Override
    public String queryChildrenWithFirstLevel(User _currUser, ClassInfo _classInfo, WCMFilter _extraFilter) throws WCMException {
        return this.queryChildren(_currUser, _classInfo, _extraFilter).getIdListAsString();
    }

    @Override
    public String queryChildrenWithFirstLevel(User _currUser, ClassInfo _classInfo, WCMFilter _extraFilter, char _cDelim) throws WCMException {
        return this.queryChildren(_currUser, _classInfo, _extraFilter).getIdListAsString(_cDelim);
    }

    @Override
    public String queryChildrenWithAllLevel(User _currUser, ClassInfo _classInfo, WCMFilter _extraFilter) throws WCMException {
        return this.queryChildrenWithAllLevel(_currUser, _classInfo, _extraFilter, ',');
    }

    @Override
    public String queryChildrenWithAllLevel(User _currUser, ClassInfo _classInfo, WCMFilter _extraFilter, char _cDelim) throws WCMException {
        StringBuffer sb = new StringBuffer();
        int nClassInfoId = _classInfo == null ? 0 : _classInfo.getId();
        this.queryChildrenWithAllLevel(_currUser, nClassInfoId, _extraFilter, sb, _cDelim);
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public String queryChildrenWithAllLevel(User _currUser, int _nClassInfoId, WCMFilter _extraFilter) throws WCMException {
        StringBuffer sb = new StringBuffer();
        this.queryChildrenWithAllLevel(_currUser, _nClassInfoId, _extraFilter, sb, ',');
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private void queryChildrenWithAllLevel(User _currUser, int _nClassInfoId, WCMFilter _extraFilter, StringBuffer _sb, char _cDelim) throws WCMException {
        int i;
        WCMFilter filter = new WCMFilter("", "ParentId=?", "ClassOrder desc");
        filter.addSearchValues(_nClassInfoId);
        filter.mergeWith(_extraFilter);
        ClassInfos oClassInfos = ClassInfos.openWCMObjs(_currUser, filter);
        int nSize = oClassInfos.size();
        for (i = 0; i < nSize; ++i) {
            _sb.append(oClassInfos.getIdAt(i)).append(_cDelim);
        }
        nSize = oClassInfos.size();
        for (i = 0; i < nSize; ++i) {
            this.queryChildrenWithAllLevel(_currUser, oClassInfos.getIdAt(i), _extraFilter, _sb, _cDelim);
        }
    }

    @Override
    public String getPath(ClassInfos _classInfos) throws WCMException {
        if (_classInfos == null) {
            return "";
        }
        StringBuffer sbClassInfoIds = new StringBuffer(50);
        int nSize = _classInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo _classInfo = (ClassInfo)_classInfos.getAt(i);
            if (_classInfo == null) continue;
            sbClassInfoIds.append(this.getPath(_classInfo)).append(",");
        }
        if (sbClassInfoIds.length() > 0) {
            sbClassInfoIds.setLength(sbClassInfoIds.length() - 1);
        }
        return sbClassInfoIds.toString();
    }

    @Override
    public String getPath(ClassInfo _classInfo) throws WCMException {
        if (_classInfo == null) {
            return "";
        }
        StringBuffer sbClassInfoIds = new StringBuffer(50);
        sbClassInfoIds.insert(0, _classInfo.getId());
        while (!_classInfo.isRoot()) {
            int parentId = _classInfo.getParentId();
            sbClassInfoIds.insert(0, parentId + ",");
            _classInfo = ClassInfo.findById(parentId);
        }
        return sbClassInfoIds.toString();
    }

    @Override
    public ClassInfo getClassInfo(String path) throws WCMException {
        return this.getClassInfo(path, "\\");
    }

    @Override
    public ClassInfo getClassInfo(String path, String delim) throws WCMException {
        StringTokenizer st = new StringTokenizer(path, delim);
        int parentId = 0;
        ClassInfo oParentClassInfo = null;
        String sCName = null;
        User loginUser = User.findByName("admin");
        while (st.hasMoreTokens()) {
            sCName = st.nextToken();
            if (CMyString.isEmpty(sCName)) continue;
            oParentClassInfo = this.getClassInfo(parentId, sCName, loginUser);
            if (oParentClassInfo == null) break;
            parentId = oParentClassInfo.getId();
        }
        return oParentClassInfo;
    }

    private ClassInfo getClassInfo(int _nParentId, String _sCName, User _user) throws WCMException {
        WCMFilter filter = new WCMFilter("", "parentId=? and cName=?", "");
        filter.addSearchValues(_nParentId);
        filter.addSearchValues(_sCName);
        ClassInfos oClassInfos = ClassInfos.openWCMObjs(_user, filter);
        int nSize = oClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo oClassInfo = (ClassInfo)oClassInfos.getAt(i);
            if (oClassInfo == null) continue;
            return oClassInfo;
        }
        return null;
    }

    public static void main(String[] args) throws WCMException {
        ClassInfoMgr mgr = new ClassInfoMgr();
        ClassInfo oClassInfo = mgr.getClassInfo(I18NMessage.get(ClassInfoMgr.class, "ClassInfoMgr.label1", "\u4e3b\u9898\u5206\u7c7b\\\u56fd\u52a1\u9662\u7ec4\u7ec7\u673a\u6784\\\u56fd\u52a1\u9662\u529e\u516c\u5385"));
        System.out.println(oClassInfo);
        if (oClassInfo != null) {
            System.out.println("---------------" + oClassInfo);
        }
    }

    @Override
    public String getNamePath(ClassInfos _classInfos) throws WCMException {
        if (_classInfos == null) {
            return "";
        }
        StringBuffer sbClassInfoNames = new StringBuffer(200);
        int nSize = _classInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo _classInfo = (ClassInfo)_classInfos.getAt(i);
            if (_classInfo == null) continue;
            sbClassInfoNames.append(this.getNamePath(_classInfo)).append(";");
        }
        if (sbClassInfoNames.length() > 0) {
            sbClassInfoNames.setLength(sbClassInfoNames.length() - 1);
        }
        return sbClassInfoNames.toString();
    }

    @Override
    public String getNamePath(ClassInfo _classInfo) throws WCMException {
        if (_classInfo == null) {
            return "";
        }
        StringBuffer sbClassInfoNames = new StringBuffer(200);
        sbClassInfoNames.insert(0, _classInfo.getName());
        while (!_classInfo.isRoot()) {
            int parentId = _classInfo.getParentId();
            if ((_classInfo = ClassInfo.findById(parentId)) == null) continue;
            sbClassInfoNames.insert(0, _classInfo.getName() + "/");
        }
        return sbClassInfoNames.toString();
    }

    @Override
    public ClassInfos getClassInfosByName(String sClassInfoName) throws WCMException {
        WCMFilter filter = new WCMFilter("", "cName=?", "");
        filter.addSearchValues(sClassInfoName);
        return ClassInfos.openWCMObjs(null, filter);
    }

    @Override
    public ClassInfos getClassInfosByName(int nClassInfoRootId, String sClassInfoName) throws WCMException {
        WCMFilter filter = new WCMFilter("", "rootId=? and cName=?", "");
        filter.addSearchValues(nClassInfoRootId);
        filter.addSearchValues(sClassInfoName);
        return ClassInfos.openWCMObjs(null, filter);
    }

    @Override
    public boolean isAncestor(int _nAncestorId, int _nDescendantId) throws WCMException {
        ClassInfo oClassInfo = ClassInfo.findById(_nDescendantId);
        while (oClassInfo != null) {
            int parentId = oClassInfo.getParentId();
            if (_nAncestorId == parentId) {
                return true;
            }
            oClassInfo = ClassInfo.findById(parentId);
        }
        return false;
    }

    @Override
    public ClassInfos queryAnyClassInfos(User user, ClassInfo _classInfo, WCMFilter filter) throws WCMException {
        WCMFilter oFilter = new WCMFilter("", "rootId=?", "ClassOrder desc");
        oFilter.addSearchValues(_classInfo == null ? 0 : _classInfo.getId());
        oFilter.mergeWith(filter);
        return ClassInfos.openWCMObjs(user, oFilter);
    }
}

