/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyMemory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClassInfoCacheMgr
implements IClassInfoCacheMgr {
    private static Logger logger = Logger.getLogger(ClassInfoCacheMgr.class);
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");
    private final String kEY_CHILDREN_CACHE = "m_hChildrenCache";
    private final String kEY_ROOTNAME_CACHE = "m_hRootNameCache";
    private final String kEY_OTHERNAME_CACHE = "m_hOtherNameCache";

    private String getKey(String name) {
        return ClassInfoCacheMgr.class.getName() + "." + name;
    }

    @Override
    public ClassInfos getChildren(int _nParentId) throws WCMException {
        return this.getChildren(_nParentId, false);
    }

    private String getFullRootKey(int iKey) {
        return this.getKey("m_hRootNameCache") + iKey;
    }

    @Override
    public ClassInfo findClassInfoByName(String _sClassInfoName) throws WCMException {
        String sKey;
        ClassInfo classInfo;
        if (!cache.exists("m_hRootNameCache").booleanValue()) {
            this.init();
        }
        if ((classInfo = ClassInfo.findByKey(cache.get(this.getFullRootKey(sKey = _sClassInfoName.toUpperCase())))) == null) {
            classInfo = ClassInfo.findByKey(cache.get(this.getFullRootKey(sKey)));
        }
        return classInfo;
    }

    @Override
    public void clear() {
    }

    @Override
    public synchronized boolean init() throws WCMException {
        if (cache.exists(this.getKey("m_hChildrenCache")).booleanValue()) {
            return false;
        }
        cache.set(this.getKey("m_hChildrenCache"), "true");
        logger.info((Object)I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label1", "\u5206\u7c7b\u6cd5\u7f13\u51b2\u521d\u59cb\u5316\u5f00\u59cb..."));
        logger.info((Object)(I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label2", "\u5206\u7c7b\u6cd5\u7f13\u51b2\u521d\u59cb\u5316\u524d\u5185\u5b58\u4f7f\u7528\u60c5\u51b5[") + CMyMemory.toMemoryInfo() + "]"));
        WCMFilter filter = new WCMFilter("", "", "ClassOrder desc,RootId,ParentId");
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, filter);
        int nCount = classInfos.size();
        for (int i = 0; i < nCount; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            this.putToChildCache(classInfo);
            this.putToNameCache(classInfo);
        }
        classInfos.clear();
        logger.info((Object)I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label3", "\u5206\u7c7b\u6cd5\u7f13\u51b2\u521d\u59cb\u5316\u5b8c\u6210\uff01"));
        logger.info((Object)(I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label4", "\u5206\u7c7b\u6cd5\u7f13\u51b2\u521d\u59cb\u5316\u540e\u5185\u5b58\u4f7f\u7528\u60c5\u51b5[") + CMyMemory.toMemoryInfo() + "]"));
        return true;
    }

    private String getFullRootKey(String iKey) {
        return this.getKey("m_hRootNameCache") + iKey;
    }

    private String getFullOtherKey(String iKey) {
        return this.getKey("m_hOtherNameCache") + iKey;
    }

    private void putToNameCache(ClassInfo _classInfo) {
        if (_classInfo.isRoot()) {
            cache.set(this.getFullRootKey(_classInfo.getName().toUpperCase()), _classInfo.getKey());
        } else {
            cache.set(this.getFullOtherKey(_classInfo.getName().toUpperCase()), _classInfo.getKey());
        }
    }

    private void removeFromNameCache(ClassInfo _classInfo) {
        if (_classInfo.isRoot()) {
            cache.clear(this.getFullRootKey(_classInfo.getName().toUpperCase()));
        } else {
            cache.set(this.getFullOtherKey(_classInfo.getName().toUpperCase()), _classInfo.getKey());
        }
    }

    private String getFullChildKey(int iKey) {
        return this.getKey("m_hChildrenCache") + iKey;
    }

    private void putToChildCache(ClassInfo classInfo) throws WCMException {
        Integer iKey = new Integer(classInfo.getParentId());
        ArrayList<Integer> list = (ArrayList<Integer>)cache.get(this.getFullChildKey(iKey));
        if (list == null) {
            list = new ArrayList<Integer>();
        }
        list.add(classInfo.getKey());
        cache.set(this.getFullChildKey(iKey), list);
    }

    private void removeFromChildCache(ClassInfo classInfo) throws WCMException {
        List childrens = (List)cache.get(this.getFullChildKey(new Integer(classInfo.getParentId())));
        if (childrens.size() > 0) {
            for (int i = 0; i < childrens.size(); ++i) {
                if (childrens.get(i) != classInfo.getKey()) continue;
                childrens.remove(i);
            }
        }
        cache.set(this.getFullChildKey(new Integer(classInfo.getParentId())), childrens);
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (_oObjAdded.getWCMType() != 694710472) {
            return;
        }
        ClassInfo classInfo = (ClassInfo)_oObjAdded;
        this.reloadChildren(classInfo.getParentId());
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof ClassInfo)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label5", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label6", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        ClassInfo classInfo = (ClassInfo)_oObjDeleted;
        this.removeFromChildCache(classInfo);
        this.removeFromNameCache(classInfo);
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (_oObjModified.getWCMType() != 694710472) {
            return;
        }
        ClassInfo currChannel = (ClassInfo)_oObjModified;
        if (currChannel.isChangeProperty("ParentId")) {
            int nOldParentId = currChannel.getParentId();
            this.reloadChildren(nOldParentId);
            int nNewParentId = currChannel.getNewPropertyAsInt("ParentId", 0);
            this.reloadChildren(nNewParentId);
            return;
        }
        if (currChannel.isChangeProperty("ClassOrder")) {
            this.reloadChildren(currChannel.getParentId());
            return;
        }
    }

    private void reloadChildren(int _nParentId) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ParentId=?", "ClassOrder desc");
        filter.addSearchValues(_nParentId);
        ClassInfos newClassInfos = ClassInfos.openWCMObjs(User.getSystem(), filter);
        Integer iKey = new Integer(_nParentId);
        String idListAsString = newClassInfos.getIdListAsString();
        try {
            cache.set(this.getFullChildKey(iKey), Arrays.asList(idListAsString.split(",")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ClassInfos getChildren(int _nParentId, boolean _bNotMakeNewObjs) throws WCMException {
        if (!cache.exists(this.getKey("m_hChildrenCache")).booleanValue()) {
            this.init();
        }
        List list = (List)cache.get(this.getFullChildKey(new Integer(_nParentId)));
        ClassInfos classInfos = new ClassInfos(null);
        if (list != null) {
            String _sIds = StringUtils.join((Collection)list, (String)",");
            classInfos = ClassInfos.findByIds(null, _sIds);
        }
        if (_bNotMakeNewObjs) {
            return classInfos;
        }
        ClassInfos children = new ClassInfos(null);
        if (list != null) {
            children.addWith(classInfos);
        }
        return children;
    }
}

