/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.gkml.sqgk.process.engine.handlers;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.IActionHandler;
import com.trs.cms.process.engine.handlers.ActionParametersAnalyser;
import com.trs.components.gkml.sqgk.persistent.ApplyForm;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.email.CMyEmail;
import com.trs.infra.util.email.CMySMTPServer;
import com.trs.infra.util.email.TRSMailer;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ApplyFormReplyHandler
implements IActionHandler {
    private Map m_hVarValues = null;
    private static Logger logger = Logger.getLogger(ApplyFormReplyHandler.class);

    @Override
    public boolean execute(ExecuteContext _context, FlowAction _action) throws WCMException {
        String sReceiverEmail;
        ActionParametersAnalyser parameters = new ActionParametersAnalyser(_action.getParams());
        String sReceiver = parameters.getParameterValue("Receiver");
        if (sReceiver == null || (sReceiver = sReceiver.trim()).length() == 0) {
            return true;
        }
        IFlowContent flowContent = null;
        BaseObj applyForm = null;
        if (_context != null && (flowContent = _context.getFlowContent()) != null) {
            CMSObj oCMSObj = flowContent.getSubinstance();
            if (!(oCMSObj instanceof ApplyForm)) {
                return true;
            }
            applyForm = (ApplyForm)oCMSObj;
        }
        if (CMyString.isEmpty(sReceiverEmail = applyForm.getPropertyAsString(sReceiver))) {
            sReceiverEmail = sReceiver;
        }
        if (sReceiverEmail.indexOf("@") == -1) {
            return true;
        }
        this.m_hVarValues = new HashMap(5);
        this.m_hVarValues.put("CONTENTTITLE".toUpperCase(), _context.getFlowContent().getDesc());
        this.m_hVarValues.put("CurrDateTime".toUpperCase(), CMyDateTime.now().toString());
        this.m_hVarValues.put("SenderName".toUpperCase(), _context.getPostUser().getName());
        String sMsgTitle = this.doPageVariablesParse(parameters.getParameterValue("MsgTitle"), _context);
        String sMsgBody = this.doPageVariablesParse(parameters.getParameterValue("MsgTemplate"), _context);
        ApplyFormReplyHandler.sendEmail(sReceiverEmail, sMsgTitle, sMsgBody, (ApplyForm)applyForm);
        return true;
    }

    private static void sendEmail(String _sEmailAddr, String _sEmailTitle, String _sEmailBody, ApplyForm applyForm) throws WCMException {
        if (CMyString.isEmpty(_sEmailAddr)) {
            logger.error((Object)"\u90ae\u4ef6\u63a5\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        CMyEmail myEmail = new CMyEmail();
        myEmail.setMailFormat(1);
        myEmail.setFrom(ApplyFormReplyHandler.getLoginUser().getEmail());
        myEmail.setTo(_sEmailAddr);
        myEmail.setSubject(_sEmailTitle);
        String sHtmlEmailBody = _sEmailBody.replaceAll("&quot;", "\"").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
        myEmail.setBody(sHtmlEmailBody);
        WCMFilter filter = new WCMFilter("", "AppDocId=?", "");
        filter.addSearchValues(0, -applyForm.getId());
        Appendixes oAppendixes = Appendixes.openWCMObjs(null, filter);
        for (int i = 0; i < oAppendixes.size(); ++i) {
            Appendix oAppendix = (Appendix)oAppendixes.getAt(i);
            if (oAppendix.getFlag() == 40) continue;
            String sFileName = oAppendix.getFile();
            sFileName = CMyFile.extractFileName(sFileName);
            String sAbsoluteFileName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
            if (!CMyFile.fileExists(sAbsoluteFileName)) {
                logger.warn((Object)("\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230\u6587\u6863(" + applyForm + ")\u7684\u9644\u4ef6[" + sFileName + "]"));
                continue;
            }
            myEmail.setAttachedFile(sAbsoluteFileName, oAppendix.getSrcFile());
        }
        TRSMailer currMailer = new TRSMailer();
        try {
            if (!currMailer.send(myEmail, CMySMTPServer.getDefaultSMTPServer())) {
                throw new WCMException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25!" + currMailer.getMailLogString());
            }
        }
        catch (CMyException e) {
            logger.error((Object)"\u90ae\u4ef6\u53d1\u9001\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
    }

    private static User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public String doPageVariablesParse(String _sContent, ExecuteContext _context) throws WCMException {
        if (_sContent == null) {
            return null;
        }
        StringBuffer buffResult = null;
        try {
            char[] chrArray = _sContent.toCharArray();
            int nLength = chrArray.length;
            int nPos = 0;
            buffResult = new StringBuffer();
            while (nPos < chrArray.length) {
                char aChar;
                if ((aChar = chrArray[nPos++]) == '$' && nPos < nLength && chrArray[nPos] == '{') {
                    StringBuffer buffVarName = new StringBuffer(16);
                    ++nPos;
                    int iCount = 0;
                    boolean zFound = false;
                    while (iCount++ < 20 && nPos < nLength) {
                        if ((aChar = chrArray[nPos++]) == '}') {
                            zFound = true;
                            break;
                        }
                        buffVarName.append(aChar);
                    }
                    Map hVarValues = this.getVarValues();
                    if (zFound) {
                        String sKey = buffVarName.toString().toUpperCase();
                        String sVal = (String)hVarValues.get(sKey);
                        if (sVal == null) {
                            sVal = this.getSubstanceProperty(sKey, _context);
                            hVarValues.put(sKey, sVal);
                        }
                        if (sVal != null) {
                            buffResult.append(sVal);
                            continue;
                        }
                        buffResult.append("${").append(buffVarName).append('}');
                        continue;
                    }
                    buffResult.append("${").append(buffVarName);
                    continue;
                }
                buffResult.append(aChar);
            }
            return buffResult.toString();
        }
        catch (Exception ex) {
            throw new WCMException(1100, "\u89e3\u6790\u5185\u5bb9\u4e2d\u7684\u53d8\u91cf\u5931\u8d25!", ex);
        }
    }

    public Map getVarValues() {
        if (this.m_hVarValues == null) {
            this.m_hVarValues = new HashMap(5);
        }
        return this.m_hVarValues;
    }

    private String getSubstanceProperty(String _sKey, ExecuteContext _context) throws WCMException {
        if (CMyString.isEmpty(_sKey)) {
            return null;
        }
        CMSObj content = _context.getFlowContent().getSubstance();
        return content.getPropertyAsString(_sKey);
    }
}

