/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IStyleAndResourceMgr;
import com.trs.components.common.publish.widget.StyleAndResource;
import com.trs.components.common.publish.widget.StyleAndResources;
import com.trs.components.common.publish.widget.Widget;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import java.util.HashMap;

public class StyleAndResourceMgr
implements IStyleAndResourceMgr {
    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void delete(User user, StyleAndResource _styleAndResource) throws WCMException {
        if (_styleAndResource == null) {
            return;
        }
        _styleAndResource.delete();
    }

    @Override
    public ContentStyles getContentStyles(Widget _resource, WCMFilter _filter) throws WCMException {
        if (_resource == null) {
            throw new WCMException("\u4f20\u5165\u7684\u7cfb\u7edf\u8d44\u6e90\u4e3anull\uff01");
        }
        int nSystemResourceId = _resource.getId();
        WCMFilter aFilter = new WCMFilter("", "EXISTS(SELECT StyleObjId FROM XWCMSTYLEANDRESOURCE WHERE ResourceId=? AND XWCMSTYLEANDRESOURCE.StyleObjId=XWCMCONTENTSTYLE.CONTENTSTYLEID)", "CONTENTSTYLEID");
        aFilter.addSearchValues(nSystemResourceId);
        if (_filter != null) {
            aFilter.mergeWith(_filter);
        }
        return ContentStyles.openWCMObjs(this.getLoginUser(), aFilter);
    }

    @Override
    public StyleAndResource save(User user, StyleAndResource _styleAndResource) throws WCMException {
        if (_styleAndResource == null) {
            throw new WCMException("\u8981\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e3a\u7a7a!StyleAndResource=[" + _styleAndResource + "]");
        }
        if (_styleAndResource.isAddMode()) {
            _styleAndResource.insert();
        } else {
            _styleAndResource.update();
        }
        return _styleAndResource;
    }

    @Override
    public void deleteUnuseCSRItems(Widget systemResource, String _sUseingIds) throws WCMException {
        if (_sUseingIds == null || _sUseingIds.length() == 0) {
            return;
        }
        if (systemResource == null) {
            throw new WCMException(20, "\u8d44\u6e90\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u8d44\u6e90\u4e0e\u98ce\u683c\u7684\u5173\u8054\u9879\uff01");
        }
        String sDelWhere = "styleobjid not in (" + _sUseingIds + ")";
        WCMFilter apdsFilter = new WCMFilter("", sDelWhere, "", "");
        StyleAndResources delStyleAndResources = this.getContentStyleAndResource(systemResource, apdsFilter);
        for (int i = 0; i < delStyleAndResources.size(); ++i) {
            this.delete(this.getLoginUser(), (StyleAndResource)delStyleAndResources.getAt(i));
        }
    }

    public StyleAndResources getContentStyleAndResource(Widget _systemResource, WCMFilter _filter) throws WCMException {
        User loginUser = this.getLoginUser();
        if (_systemResource == null) {
            throw new WCMException("\u4f20\u5165\u7684\u8d44\u6e90\u4e3anull \uff01");
        }
        WCMFilter filter = new WCMFilter("", "ResourceId=? and STYLEOBJTYPE=?  ", "");
        filter.addSearchValues(_systemResource.getId());
        filter.addSearchValues(1791765043);
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        return StyleAndResources.openWCMObjs(loginUser, filter);
    }

    @Override
    public HashMap getContentStyleAndResourceMap(Widget _systemResource, WCMFilter _filter) throws WCMException {
        User loginUser = this.getLoginUser();
        if (_systemResource == null) {
            throw new WCMException("\u4f20\u5165\u7684\u8d44\u6e90\u4e3anull \uff01");
        }
        WCMFilter filter = new WCMFilter("", "ResourceId=? and STYLEOBJTYPE=?  ", "");
        filter.addSearchValues(_systemResource.getId());
        filter.addSearchValues(1791765043);
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        StyleAndResources styleAndResources = StyleAndResources.openWCMObjs(loginUser, filter);
        HashMap<String, StyleAndResource> map = new HashMap<String, StyleAndResource>();
        if (styleAndResources == null || styleAndResources.size() < 1) {
            return map;
        }
        for (int i = 0; i < styleAndResources.size(); ++i) {
            StyleAndResource styleAndResource = (StyleAndResource)styleAndResources.getAt(i);
            if (styleAndResource == null) continue;
            map.put(styleAndResource.getCssFlag(), styleAndResource);
        }
        return map;
    }
}

