/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.domain.tagparser.ScanContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagFormatHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import java.util.List;
import org.apache.log4j.Logger;

public class TagDocumentReader {
    public static boolean IS_DEBUG = false;
    private static final Logger logger = Logger.getLogger((String)TagDocumentReader.class.getName());
    public static final int ST_TAGNAME = 1;
    public static final int ST_TAGNAME_END = 2;
    public static final int ST_ATTRNAME = 3;
    public static final int ST_ATTRNAME_END = 4;
    public static final int ST_ATTRVALUE_HASQUOTE = 5;
    public static final int ST_ATTRVALUE_NOQUOTE = 6;
    public static final int ST_ATTRVALUE_END = 7;
    public static final int ST_STARTTAG_END = 8;
    public static final int ST_CHILD_BEGIN = 9;
    public static final int ST_CHILD_TAGITEM = 10;
    public static final int ST_CHILD_STRING = 11;
    public static final int ST_CHILD_STRING_END = 12;
    public static final int ST_ENDTAG_CHECK = 93;
    public static final int ST_SELFCLOSEDTAG_CHECK = 95;
    public static final int ST_ATTRVALUE_HASQUOTE_BEGIN = 13;
    public static final int ST_ATTRVALUE_HASQUOTE_ENDCHECK = 14;
    private static char[][][] READING_MAP = new char[][][]{new char[][]{{'\u0001'}}, new char[][]{{'\u0001'}, {' ', '\u0002'}, {'/', '\u0002'}, {'>', '\u0002'}}, new char[][]{{'\u0003'}, {'>', '\b'}, {'/', '_'}}, new char[][]{{'\u0003'}, {'=', '\u0004'}, {'/', '\u0004'}, {'>', '\u0004'}}, new char[][]{{'\u0006'}, {' ', '\u0007'}, {'/', '\u0007'}, {'>', '\u0007'}, {'\"', '\r'}, {'\'', '\r'}}, new char[][]{{'\u0005'}, {'\"', '\u000e'}, {'\'', '\u000e'}}, new char[][]{{'\u0006'}, {'/', '\u0007'}, {'>', '\u0007'}, {' ', '\u0007'}}, new char[][]{{'\u0003'}, {'>', '\b'}, {'/', '_'}}, new char[][]{{'\t'}, {'<', '/', ']'}}, new char[][]{{'\u000b'}, {'<', '/', 'T', 'R', 'S', '_', ']'}, {'<', 'T', 'R', 'S', '_', '\n'}}, new char[][]{{'\t'}}, new char[][]{{'\u000b'}, {'<', '/', 'T', 'R', 'S', '_', '\f'}, {'<', 'T', 'R', 'S', '_', '\f'}}, new char[][]{{'x'}, {'<', '/', ']'}, {'<', '\t'}}};

    private TagDocumentReader() {
    }

    public static TagDocument read(String _text) throws Exception {
        return TagDocumentReader.read(_text, null);
    }

    public static TagDocument read(String _text, Template _template) throws Exception {
        if (_text == null) {
            throw new WCMException(10, "Tag document content required.");
        }
        TagDocument aDoc = new TagDocument();
        ScanContext sCtx = new ScanContext(_text, _template);
        if (!sCtx.hasChar()) {
            return aDoc;
        }
        StringBuffer buffResult = new StringBuffer();
        int nCurrStatus = 9;
        int nCurrTagStartPos = 0;
        block7: while (sCtx.hasChar()) {
            char aChar = sCtx.getChar();
            if (IS_DEBUG) {
                System.out.print("CS=" + nCurrStatus + "; Char=" + aChar + "; nPos=" + sCtx.getOffset());
            }
            nCurrStatus = TagDocumentReader.lookupNextStatus(nCurrStatus, sCtx);
            if (IS_DEBUG) {
                System.out.println("; NS=" + nCurrStatus);
            }
            switch (nCurrStatus) {
                case 93: {
                    throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label1", "\u975e\u9884\u671f\u7684\u7ed3\u675f\u7f6e\u6807! ") + sCtx.lookAround(nCurrTagStartPos));
                }
                case 11: {
                    buffResult.append(aChar);
                    sCtx.skipChar();
                    continue block7;
                }
                case 9: {
                    continue block7;
                }
                case 10: {
                    nCurrTagStartPos = sCtx.getOffset();
                    TagItem aChild = TagDocumentReader.readItem(sCtx);
                    aDoc.addItem(aChild);
                    continue block7;
                }
                case 12: {
                    aDoc.addItem(buffResult.toString());
                    buffResult.setLength(0);
                    continue block7;
                }
            }
            throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label2", "\u672a\u77e5\u7684\u8f6c\u79fb\u72b6\u6001:") + nCurrStatus + sCtx.lookAround(nCurrTagStartPos));
        }
        if (buffResult.length() > 0) {
            aDoc.addItem(buffResult.toString());
            buffResult.setLength(0);
        }
        int nSize = aDoc.getItemCount();
        for (int i = 0; i < nSize; ++i) {
            Object item = aDoc.getItemAt(i);
            if (!(item instanceof TagItem)) continue;
            TagDocumentReader.formateItem((TagItem)item);
        }
        return aDoc;
    }

    private static void formateItem(TagItem _item) throws WCMException {
        if (_item == null) {
            return;
        }
        TagDocumentReader.standardizeTagItem(_item);
        List lChildren = _item.getChildren();
        if (lChildren == null || lChildren.isEmpty()) {
            return;
        }
        int nSize = lChildren.size();
        for (int i = 0; i < nSize; ++i) {
            Object item = lChildren.get(i);
            if (!(item instanceof TagItem)) continue;
            TagDocumentReader.formateItem((TagItem)item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String lookAround(char[] _textChars, int _nStartPos, int _nEndPos) {
        StringBuffer buff = new StringBuffer();
        try {
            int i;
            int nOffset;
            if (_nEndPos >= _textChars.length) {
                _nEndPos = _textChars.length - 1;
            }
            if ((nOffset = _nEndPos - _nStartPos) < 160) {
                for (i = _nStartPos; i <= _nEndPos; ++i) {
                    buff.append(_textChars[i]);
                }
            } else {
                int nEnd = _nStartPos + 79;
                for (i = _nStartPos; i <= nEnd; ++i) {
                    buff.append(_textChars[i]);
                }
                buff.append("...");
                for (i = _nEndPos - 79; i <= _nEndPos; ++i) {
                    buff.append(_textChars[i]);
                }
            }
            String string = buff.toString();
            return string;
        }
        finally {
            buff.setLength(0);
        }
    }

    private static TagItem readItem(ScanContext sCtx) throws Exception {
        TagItem aItem = new TagItem();
        aItem.setBeginColumn(sCtx.getColumn());
        aItem.setBeginLineNo(sCtx.getLineNo());
        if (!sCtx.hasChar()) {
            return aItem;
        }
        int nStartPos = sCtx.getOffset();
        int nCurrStatus = 1;
        sCtx.skipChar();
        char chrQuote = ' ';
        StringBuffer buffResult = new StringBuffer();
        String sAttributeName = null;
        try {
            block24: while (sCtx.hasChar()) {
                char aChar = sCtx.getChar();
                if (IS_DEBUG) {
                    System.out.print("CS=" + nCurrStatus + "; Char=" + aChar + "; nPos=" + sCtx.getOffset());
                }
                nCurrStatus = TagDocumentReader.lookupNextStatus(nCurrStatus, sCtx);
                if (IS_DEBUG) {
                    System.out.println("; NS=" + nCurrStatus);
                }
                switch (nCurrStatus) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 11: {
                        buffResult.append(aChar);
                        sCtx.skipChar();
                        continue block24;
                    }
                    case 2: {
                        if (buffResult.length() == 0) {
                            throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label3", "\u7f3a\u5c11\u7f6e\u6807\u540d\u79f0! ") + sCtx.lookAround(nStartPos));
                        }
                        aItem.setName(buffResult.toString());
                        buffResult.setLength(0);
                        while (sCtx.hasChar() && Character.isWhitespace(sCtx.getChar())) {
                            sCtx.skipChar();
                        }
                        continue block24;
                    }
                    case 4: {
                        if (aChar != '=') {
                            throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label4", "\u7f6e\u6807\u5c5e\u6027[") + buffResult.toString() + I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label5", "]\u7f3a\u5c11'='! ") + sCtx.lookAround(nStartPos));
                        }
                        if (buffResult.length() == 0) {
                            throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label6", "\u7f3a\u5c11\u7f6e\u6807\u5c5e\u6027\u540d\u79f0! ") + sCtx.lookAround(nStartPos));
                        }
                        sAttributeName = buffResult.toString().trim();
                        buffResult.setLength(0);
                        sCtx.skipChar();
                        while (sCtx.hasChar() && Character.isWhitespace(sCtx.getChar())) {
                            sCtx.skipChar();
                        }
                        continue block24;
                    }
                    case 13: {
                        chrQuote = aChar;
                        nCurrStatus = 5;
                        sCtx.skipChar();
                        continue block24;
                    }
                    case 14: {
                        if (aChar != chrQuote || sCtx.prevChar() == '\\') {
                            buffResult.append(aChar);
                            sCtx.skipChar();
                            nCurrStatus = 5;
                            continue block24;
                        }
                        nCurrStatus = 7;
                        sCtx.skipChar();
                    }
                    case 7: {
                        aItem.setAttribute(sAttributeName, buffResult.toString());
                        buffResult.setLength(0);
                        while (sCtx.hasChar() && Character.isWhitespace(sCtx.getChar())) {
                            sCtx.skipChar();
                        }
                        continue block24;
                    }
                    case 8: {
                        sCtx.skipChar();
                        continue block24;
                    }
                    case 9: {
                        continue block24;
                    }
                    case 10: {
                        TagItem aChild = TagDocumentReader.readItem(sCtx);
                        aItem.addChild(aChild);
                        aChild.setParent(aItem);
                        continue block24;
                    }
                    case 12: {
                        aItem.addChild(buffResult.toString());
                        buffResult.setLength(0);
                        continue block24;
                    }
                    case 93: {
                        sCtx.skipChar();
                        sCtx.skipChar();
                        char[] charsToMatch = (aItem.getName() + '>').toCharArray();
                        boolean bMatched = true;
                        sCtx.mark();
                        for (int nMatchedLength = 0; nMatchedLength < charsToMatch.length; ++nMatchedLength) {
                            if (!sCtx.hasChar()) {
                                throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label7", "\u7f6e\u6807 ") + aItem.getDescWithPos() + I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label8", " \u6ca1\u6709\u7ed3\u675f! ") + sCtx.lookAround(nStartPos));
                            }
                            char chr1 = sCtx.getChar();
                            sCtx.skipChar();
                            char chr2 = charsToMatch[nMatchedLength];
                            if (chr1 == chr2 || Character.toUpperCase(chr1) == chr2) continue;
                            bMatched = false;
                            break;
                        }
                        if (bMatched) {
                            aItem.setCloseColumn(sCtx.getColumn());
                            aItem.setCloseLineNo(sCtx.getLength());
                            return aItem;
                        }
                        nCurrStatus = 11;
                        buffResult.append("</");
                        sCtx.reset();
                        continue block24;
                    }
                    case 95: {
                        sCtx.skipChar();
                        if (sCtx.hasChar() && sCtx.getChar() == '>') {
                            sCtx.skipChar();
                            aItem.setCloseColumn(sCtx.getColumn());
                            aItem.setCloseLineNo(sCtx.getLength());
                            return aItem;
                        }
                        throw new WCMDatainvalidException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label7", "\u7f6e\u6807 ") + aItem.getDescWithPos() + I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label9", " \u7f3a\u5c11\u7ed3\u675f\u5b57\u7b26'>'! ") + sCtx.lookAround(nStartPos));
                    }
                }
                throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label2", "\u672a\u77e5\u7684\u8f6c\u79fb\u72b6\u6001:") + nCurrStatus + sCtx.lookAround(nStartPos));
            }
            String sError = null;
            switch (nCurrStatus) {
                case 1: {
                    aItem.setName(buffResult.toString());
                }
                case 2: {
                    sError = "close tag required. ";
                    break;
                }
                case 3: 
                case 4: {
                    sError = "value of attribute [" + sAttributeName + "] is required. ";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 14: {
                    sError = "value of attribute [" + sAttributeName + "] is not closed. ";
                    break;
                }
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    sError = I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label10", "\u7f3a\u5c11\u7ed3\u675f\u7f6e\u6807!");
                    break;
                }
                case 10: {
                    sError = "tag item child is not closed. ";
                }
            }
            if (sError != null) {
                throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label7", "\u7f6e\u6807 ") + aItem.getDescWithPos() + I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label11", " \u6709\u9519\u8bef:") + sError + sCtx.lookAround(nStartPos) + I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label12", " [\u72b6\u6001=") + nCurrStatus + "] ");
            }
            aItem.setCloseColumn(sCtx.getColumn());
            aItem.setCloseLineNo(sCtx.getLength());
            return aItem;
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to read tag item in [" + sCtx.getTemplate() + "] while parsed result is: " + aItem.toString()), (Throwable)ex);
            aItem.clear();
            buffResult.setLength(0);
            throw ex;
        }
    }

    private static void standardizeTagItem(TagItem _item) throws WCMException {
        String sId;
        if (_item.getName().equalsIgnoreCase("TRS_OUTLINE")) {
            _item.removeAttribute("TYPE");
        }
        if ((sId = _item.getAttributeTrim("ID")) != null && sId.length() > 4 && sId.substring(0, 4).equalsIgnoreCase("_TRS")) {
            _item.setName("TRS_" + sId.substring(4));
            _item.removeAttribute("ID");
        }
        _item.removeAttribute("TRS_OUTLINE_DESC");
        TagFormatHelper.standardize(_item);
    }

    public static int lookupNextStatus(int _nCurrentStatus, ScanContext sCtx) throws Exception {
        if (_nCurrentStatus >= READING_MAP.length) {
            throw new WCMException(10, "No route is found for status " + _nCurrentStatus);
        }
        char[][] map = READING_MAP[_nCurrentStatus];
        for (int nRouteIndex = 1; nRouteIndex < map.length; ++nRouteIndex) {
            int nCharIndex;
            char[] aRoute = map[nRouteIndex];
            boolean bFound = true;
            sCtx.mark();
            for (nCharIndex = 0; nCharIndex < aRoute.length - 1; ++nCharIndex) {
                if (sCtx.hasChar()) {
                    char char1 = aRoute[nCharIndex];
                    char char2 = sCtx.getChar();
                    sCtx.skipChar();
                    if (char1 == char2 || char1 == ' ' && Character.isWhitespace(char2) || char1 == Character.toUpperCase(char2)) continue;
                }
                bFound = false;
                break;
            }
            sCtx.reset();
            if (!bFound) continue;
            return aRoute[nCharIndex];
        }
        return map[0][0];
    }
}

