/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.DreamFactory;
import com.trs.cluster.ClusterConfigHelper;
import com.trs.components.common.publish.PublishConstants;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParserFactory;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.components.wcm.publish.tagparser.XWCMTagParserPageGeneration;
import com.trs.infra.I18NMessage;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.List;

public class PageDestroyer {
    private static boolean m_bInited = false;
    private static boolean m_bSlaveNode = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withdraw(IPublishFolder _folder, PublishTaskContext _taskContext) throws Exception {
        if (_folder == null) {
            return;
        }
        String sLocalPath = null;
        try {
            PublishPathCompass compass = new PublishPathCompass();
            sLocalPath = compass.getLocalPath(_folder, false);
        }
        catch (Exception e) {
            return;
        }
        PageDestroyer.initIfNeed();
        FileService local = new FileService(sLocalPath);
        if (!local.exists() || !local.isDirectory()) {
            return;
        }
        boolean ok = local.renameTo(new FileService(local.getParentFileStore(), PublishConstants.makeDeletedPathName(local.getName())));
        if (!ok) {
            throw new Exception("Failed to withdraw folder.");
        }
        FileDistributeShip ship = _taskContext == null ? new FileDistributeShip() : _taskContext.getFileDistributeShip();
        try {
            ship.withdrawFolder(_folder);
        }
        finally {
            if (_taskContext == null) {
                ship.clear();
            }
        }
    }

    private static void initIfNeed() {
        if (!m_bInited) {
            ClusterConfig conf = ClusterConfigHelper.getConfig();
            m_bSlaveNode = conf.isEnabled() && !conf.isMaster();
            m_bInited = true;
        }
    }

    public static void withdraw(IPublishContent _content, PublishTaskContext _taskContext) throws Exception {
        PageDestroyer.withdraw(_content, _taskContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withdraw(IPublishContent _content, PublishTaskContext _taskContext, boolean _bWithdrawRelateResource) throws Exception {
        FileDistributeShip ship;
        PublishPathCompass compass;
        if (_content == null) {
            return;
        }
        if (_taskContext == null) {
            compass = new PublishPathCompass();
            ship = new FileDistributeShip(compass);
        } else {
            compass = _taskContext.getPathCompass();
            ship = _taskContext.getFileDistributeShip();
        }
        try {
            Template template = _content.getDetailTemplate();
            if (template == null) {
                throw new WCMException(225, CMyString.format(I18NMessage.get(PageDestroyer.class, "PageDestroyer.label1", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u7ec6\u89c8\u6a21\u677f,\u64a4\u9500\u53d1\u5e03\u5931\u8d25."), new Object[]{_content}), null);
            }
            String sFileExt = template.getOutputFileExt();
            String sLocalPubPath = compass.getLocalPath(_content, false);
            int nPageIndex = 0;
            String sFullFileName = PublishPathCompass.makeDetailPageFileName(_content, sFileExt, nPageIndex);
            if (_content.isFile()) {
                sFullFileName = ((PublishContentDocumentImpl)_content).getRealFileName();
            }
            PageDestroyer.initIfNeed();
            do {
                CMyFile.deleteFile(sLocalPubPath + sFullFileName);
                ship.withdrawFile(sFullFileName, _content);
                sFullFileName = PublishPathCompass.makeDetailPageFileName(_content, sFileExt, ++nPageIndex);
            } while (CMyFile.fileExists(sLocalPubPath + sFullFileName));
            if (!_bWithdrawRelateResource) {
                return;
            }
            Iterator it = _content.getRelatedResources();
            if (it != null) {
                String path = compass.getLocalPath(_content, false);
                while (it.hasNext()) {
                    String fn = (String)it.next();
                    if (!CMyFile.deleteFile(path + fn)) continue;
                    ship.withdrawFile(fn, _content);
                }
            }
            TemplateParseMgr parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            TagDocument tagDoc = parseMgr.parse(template);
            PublishPageContext pageContext = new PublishPageContext(_content, _taskContext, null);
            PublishTagContext tagContext = new PublishTagContext(pageContext);
            List _items = tagDoc.getItems();
            for (int nItemIndex = 0; nItemIndex < _items.size(); ++nItemIndex) {
                TagItem tagItem;
                Object item = _items.get(nItemIndex);
                if (item instanceof String || !"TRS_PAGEGENERATE".equalsIgnoreCase((tagItem = (TagItem)item).getName())) continue;
                XWCMTagParserPageGeneration parser = (XWCMTagParserPageGeneration)TagParserFactory.createParserByName(tagItem.getName());
                tagContext.setTagItem(tagItem);
                String sFileName = parser.getFileName(tagContext);
                CMyFile.deleteFile(sLocalPubPath + sFileName);
                ship.withdrawFile(sFileName, _content);
            }
        }
        finally {
            if (_taskContext == null) {
                compass.clear();
                ship.clear();
            }
        }
    }

    public static synchronized void reinit() {
        m_bInited = false;
    }

    public static class FileFilterForContentPath
    implements FileFilter {
        private CMyDateTime m_dtStart = null;
        private CMyDateTime m_dtEnd = null;

        public FileFilterForContentPath(CMyDateTime _dtStart, CMyDateTime _dtEnd) {
            this.m_dtStart = _dtStart;
            this.m_dtEnd = _dtEnd;
        }

        @Override
        public boolean accept(File _childFile) {
            if (!_childFile.isDirectory()) {
                return false;
            }
            String sChildPathName = _childFile.getName();
            CMyDateTime dtTemp = new CMyDateTime();
            try {
                dtTemp.setDateTimeWithString(sChildPathName, PublishServerConfigMapper.getDirDividedByDateFormat(true));
            }
            catch (CMyException e) {
                return false;
            }
            return dtTemp.compareTo(this.m_dtStart) >= 0L && dtTemp.compareTo(this.m_dtEnd) <= 0L;
        }
    }
}

