/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.domain;

import com.trs.components.comment.domain.SignUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;

public class CommentUpdator {
    private int m_nTopicId;
    private String m_sRelatedDocIds;
    private boolean m_bDeleteFlag;
    private String m_sDataWithSign;

    public CommentUpdator() {
        this.m_nTopicId = 0;
        this.m_sRelatedDocIds = null;
        this.m_bDeleteFlag = true;
        this.m_sDataWithSign = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommentUpdator(String s) throws Exception {
        ByteArrayInputStream bis = null;
        FilterInputStream is = null;
        try {
            byte[] buff = s.getBytes("ISO8859_1");
            SignUtil su = SignUtil.getVerify();
            buff = su.decodeRadix64(buff);
            bis = new ByteArrayInputStream(buff);
            is = new DataInputStream(bis);
            this.m_nTopicId = ((DataInputStream)is).readInt();
            this.m_sRelatedDocIds = ((DataInputStream)is).readUTF();
            this.m_bDeleteFlag = ((DataInputStream)is).readBoolean();
            if (!su.verify(buff, ((DataInputStream)is).readInt())) {
                throw new Exception("sign error");
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataWithSign() throws Exception {
        if (this.m_sDataWithSign == null) {
            if (this.m_sRelatedDocIds == null) {
                this.m_sRelatedDocIds = "";
            }
            SignUtil su = SignUtil.getSign();
            ByteArrayOutputStream bos = null;
            FilterOutputStream dos = null;
            try {
                bos = new ByteArrayOutputStream(512);
                dos = new DataOutputStream(bos);
                ((DataOutputStream)dos).writeInt(this.m_nTopicId);
                ((DataOutputStream)dos).writeUTF(this.m_sRelatedDocIds);
                ((DataOutputStream)dos).writeBoolean(this.m_bDeleteFlag);
                ((DataOutputStream)dos).flush();
                byte[] buff = su.sign(bos.toByteArray());
                ((DataOutputStream)dos).writeInt(buff.length);
                dos.write(buff);
                ((DataOutputStream)dos).flush();
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (Exception exception) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.m_sDataWithSign = su.encodeRadix64(bos.toByteArray());
        }
        return this.m_sDataWithSign;
    }

    public static void main(String[] args) {
        try {
            CommentUpdator nc = new CommentUpdator();
            nc.setTopicId(1);
            nc.setRelatedDocIds("655,658,659");
            nc.setDeleteFlag(false);
            String s = nc.getDataWithSign();
            System.out.println("signed string:" + s);
            System.out.println("-------------------");
            CommentUpdator nc2 = new CommentUpdator(s);
            System.out.println("unsigned info:" + nc);
            System.out.println("designed info:" + nc2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("TopicID:");
        sb.append(this.m_nTopicId);
        sb.append(",RelatedDocs:");
        sb.append(this.m_sRelatedDocIds);
        sb.append(",IsTopicDelete?:");
        sb.append(this.m_bDeleteFlag);
        return sb.toString();
    }

    public int getTopicId() {
        return this.m_nTopicId;
    }

    public void setTopicId(int topicId) {
        this.m_nTopicId = topicId;
    }

    public String getRelatedDocIds() {
        return this.m_sRelatedDocIds;
    }

    public void setRelatedDocIds(String topicTitle) {
        this.m_sRelatedDocIds = topicTitle;
    }

    public boolean isDeleteFlag() {
        return this.m_bDeleteFlag;
    }

    public void setDeleteFlag(boolean deleteFlag) {
        this.m_bDeleteFlag = deleteFlag;
    }
}

