/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.GroupUser;
import com.trs.cms.auth.persistent.GroupUsers;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.IdFilterSqlUtil;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class GroupMgr {
    private static final Logger m_oLogger = Logger.getLogger((String)GroupMgr.class.getName());

    public boolean addUser(User _userToAdd, Group _theGroup) throws WCMException {
        if (_userToAdd == null || !_userToAdd.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label1", "\u8981\u52a0\u5165\u7ec4\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Group.addUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label2", "\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Group.addUser\uff09"));
        }
        if (_theGroup == null || !_theGroup.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label3", "\u6307\u5b9a\u7684\u7ec4\u7ec7\u65e0\u6548!"));
        }
        int nUserId = _userToAdd.getId();
        int nGroupId = _theGroup.getId();
        try {
            GroupUser newGrpUser = this.getGroupUser(_theGroup, _userToAdd);
            if (newGrpUser != null) {
                return false;
            }
            newGrpUser = GroupUser.createNewInstance();
            newGrpUser.setUserId(nUserId);
            newGrpUser.setGroupId(nGroupId);
            newGrpUser.setIsAdministrator(0);
            newGrpUser.insert(ContextHelper.getLoginUser());
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(GroupMgr.class, "GroupMgr.label4", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u7ec4\u65f6\u51fa\u9519\uff08Group.addUser\uff09"), ex);
        }
        return true;
    }

    public boolean removeUser(User _dstUser, Group _theGroup) throws WCMException {
        if (_dstUser == null || !_dstUser.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(GroupMgr.class, "GroupMgr.label5", "\u8981\u4ece\u7ec4\u4e2d\u5220\u9664\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Group.removeUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(GroupMgr.class, "GroupMgr.label6", "\u6267\u884c\u5220\u9664\u64cd\u4f5c\u7684\u7528\u6237\u65e0\u6548\uff08Group.removeUser\uff09"));
        }
        if (_theGroup == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label7", "\u5f53\u524d\u64cd\u4f5c\u7684\u7ec4\u7ec7\u65e0\u6548!"));
        }
        try {
            GroupUser aGroupUser = this.getGroupUser(_theGroup, _dstUser);
            if (aGroupUser == null) {
                return false;
            }
            aGroupUser.delete(ContextHelper.getLoginUser());
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(GroupMgr.class, "GroupMgr.label8", "\u4ece\u7ec4\u4e2d\u5220\u9664\u6307\u5b9a\u7528\u6237\u65f6\u5931\u8d25\uff08Group.removeUser\uff09"), ex);
        }
        return true;
    }

    public boolean setGroupManager(User _dstUser, Group _theGroup, boolean _isAdministrator) throws WCMException {
        if (_dstUser == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label9", "\u65e0\u6548\u7684\u7528\u6237,\u5fc5\u987b\u6307\u5b9a\u4e00\u4e2a\u6709\u6548\u7684\u7528\u6237\u4f5c\u4e3a\u7ba1\u7406\u5458!"));
        }
        if (_isAdministrator && (_dstUser.isForbidden() || _dstUser.isDeleted())) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label10", "\u8be5\u7528\u6237\u4e3a\u7a7a\u6216\u88ab\u505c\u7528\u3001\u88ab\u5220\u9664,\u5fc5\u987b\u6307\u5b9a\u4e00\u4e2a\u6709\u6548\u7684\u7528\u6237\u4f5c\u4e3a\u7ba1\u7406\u5458!"));
        }
        if (_theGroup == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label11", "\u65e0\u6548\u7684\u7ec4\u7ec7\u5bf9\u8c61"));
        }
        GroupUser aGroupUser = this.getGroupUser(_theGroup, _dstUser);
        if (aGroupUser == null) {
            return false;
        }
        aGroupUser.canEdit(ContextHelper.getLoginUser());
        aGroupUser.setIsAdministrator(_isAdministrator ? 1 : 0);
        aGroupUser.update(ContextHelper.getLoginUser());
        return true;
    }

    public Users getUsers(Group _theGroup, WCMFilter _filter) throws WCMException {
        if (_theGroup == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label12", "\u65e0\u6548\u7684\u7fa4\u7ec4\u5bf9\u8c61,\u65e0\u6cd5\u53d6\u5f97\u8be5\u7ec4\u5185\u7684\u7528\u6237"));
        }
        WCMFilter aFilter = new WCMFilter("", "EXISTS(SELECT GroupId FROM WCMGrpUser WHERE GroupID=" + _theGroup.getId() + " AND WCMGrpUser.UserId=WCMUser.UserId)", "UserId");
        aFilter.mergeWith(_filter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Groups getChildren(Group _parentGroup) throws WCMException {
        WCMFilter aFilter = null;
        aFilter = _parentGroup == null ? new WCMFilter("", "ParentId=0", "GROUPORDER ASC") : new WCMFilter("", "ParentId=" + _parentGroup.getId(), "GROUPORDER ASC");
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Groups getChildren(Group _parentGroup, WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = null;
        aFilter = _parentGroup == null ? new WCMFilter("", "ParentId=0", "") : new WCMFilter("", "ParentId=" + _parentGroup.getId(), "");
        aFilter.mergeWith(_filter);
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Users getAdmins(Group _dstGroup) throws WCMException {
        if (_dstGroup == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label13", "\u65e0\u6548\u7684\u7ec4\u7ec7,\u65e0\u6cd5\u83b7\u7ec4\u7ec7\u7684\u7ba1\u7406\u5458!"));
        }
        WCMFilter aFilter = new WCMFilter("", "isAdministrator=1", "", "UserId");
        GroupUsers aGroupUsers = this.getGroupUsers(_dstGroup, aFilter);
        Users aUsers = Users.createNewInstance(ContextHelper.getLoginUser());
        GroupUser aGroupUser = null;
        User aUser = null;
        for (int i = 0; i < aGroupUsers.size(); ++i) {
            aGroupUser = (GroupUser)aGroupUsers.getAt(i);
            if (aGroupUser == null || (aUser = User.findById(aGroupUser.getUserId())) == null) continue;
            aUsers.addElement(aUser);
        }
        return aUsers;
    }

    public boolean moveUser(User _dstUser, Group _srcGroup, Group _dstGroup) throws WCMException {
        if (_srcGroup == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label14", "\u6307\u5b9a\u7684\u7528\u6237\u539f\u6240\u5c5e\u7ec4\u7ec7\u65e0\u6548!"));
        }
        if (_dstGroup == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label15", "\u6307\u5b9a\u7684\u76ee\u6807\u7ec4\u7ec7\u65e0\u6548!"));
        }
        if (_srcGroup.getId() == _dstGroup.getId()) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label16", "\u6307\u5b9a\u7684\u539f\u7ec4\u7ec7\u4e0e\u76ee\u6807\u7ec4\u7ec7\u662f\u540c\u4e00\u4e2a\u7ec4\u7ec7,\u65e0\u6cd5\u5b8c\u6210\u64cd\u4f5c!"));
        }
        GroupUser aGroupUser = this.getGroupUser(_srcGroup, _dstUser);
        GroupUser bGroupUser = this.getGroupUser(_dstGroup, _dstUser);
        if (aGroupUser != null) {
            if (bGroupUser == null) {
                aGroupUser.canEdit(ContextHelper.getLoginUser());
                aGroupUser.setGroupId(_dstGroup.getId());
                aGroupUser.update(ContextHelper.getLoginUser());
            } else {
                aGroupUser.delete(ContextHelper.getLoginUser());
            }
            return true;
        }
        return false;
    }

    public Group save(Group _dstGroup) throws WCMException {
        m_oLogger.debug((Object)I18NMessage.get(GroupMgr.class, "GroupMgr.label17", "\u3010LOG\u3011\u5f00\u59cb\u4fdd\u5b58\u7ec4\u7ec7\uff1aGroupMgr.save"));
        this.validate(_dstGroup);
        this.prepareSave(_dstGroup);
        _dstGroup.save(ContextHelper.getLoginUser());
        return _dstGroup;
    }

    private void validate(Group _dstGroup) throws WCMException {
        if (_dstGroup == null) {
            throw new WCMException(20, I18NMessage.get(GroupMgr.class, "GroupMgr.label18", "\u7ec4\u7ec7\u4e3a\u7a7a\uff01"));
        }
        if (_dstGroup.getName() == null || _dstGroup.getName().trim().length() == 0) {
            throw new WCMException(20, I18NMessage.get(GroupMgr.class, "GroupMgr.label19", "\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a\uff01"));
        }
        if (_dstGroup.isAddMode() && this.isNameExist(_dstGroup)) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label20", "\u7ec4\u7ec7\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        if (_dstGroup.getParentId() != 0 && _dstGroup.getParent() == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label21", "\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01"));
        }
    }

    private Group prepareSave(Group _dstGroup) throws WCMException {
        Group parentGroup = null;
        parentGroup = _dstGroup.isChangeProperty("ParentId") ? Group.findById(_dstGroup.getNewPropertyAsInt("ParentId", 0)) : _dstGroup.getParent();
        if (parentGroup == null) {
            _dstGroup.setParent(0);
        }
        return _dstGroup;
    }

    public boolean delete(Group _dstGroup) throws WCMException {
        if (_dstGroup == null) {
            throw new WCMException(20, I18NMessage.get(GroupMgr.class, "GroupMgr.label22", "\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        m_oLogger.debug((Object)(I18NMessage.get(GroupMgr.class, "GroupMgr.label23", "\u5220\u9664\u7ec4\u7ec7\uff1aGroupMgr.delete\uff0cId\uff1a") + _dstGroup.getId() + "\uff0c" + _dstGroup.getName()));
        Groups childGroups = this.getChildren(_dstGroup);
        if (childGroups != null && !childGroups.isEmpty()) {
            for (int i = 0; i < childGroups.size(); ++i) {
                this.delete((Group)childGroups.getAt(i));
            }
        }
        WCMFilter aFilter = new WCMFilter("WCMGRPUSER", "GroupId=" + _dstGroup.getId(), "");
        GroupUsers aGroupUsers = GroupUsers.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        aGroupUsers.removeAll();
        _dstGroup.delete(ContextHelper.getLoginUser());
        return true;
    }

    private boolean isNameExist(Group _dstGroup) throws WCMException {
        if (_dstGroup == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label18", "\u7ec4\u7ec7\u4e3a\u7a7a\uff01"));
        }
        String sGroupName = _dstGroup.getName();
        WCMFilter aFilter = new WCMFilter("WCMGROUP", "GNAME='" + CMyString.filterForSQL(sGroupName) + "' AND PARENTID=" + _dstGroup.getParentId(), "", "GroupId", 1);
        Groups aGroups = Groups.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        if (aGroups.isEmpty()) {
            return false;
        }
        aGroups.clear();
        return true;
    }

    private GroupUser getGroupUser(Group _theGroup, User _dstUser) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "UserId=" + _dstUser.getId(), "", "", 1);
        GroupUsers aGroupUsers = this.getGroupUsers(_theGroup, aFilter);
        if (aGroupUsers.isEmpty()) {
            return null;
        }
        return (GroupUser)aGroupUsers.getAt(0);
    }

    public GroupUsers getGroupUsers(Group _theGroup, WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMGRPUSER", "GroupId=" + _theGroup.getId(), "");
        aFilter.mergeWith(_filter);
        return GroupUsers.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Groups getOffspringGroups(Group _theGroup, boolean _bContainSelf, WCMFilter _filter) throws WCMException {
        if (_theGroup == null) {
            return Groups.openWCMObjs(ContextHelper.getLoginUser(), _filter);
        }
        String sGroupIds = this.getOffspringGroupIds(String.valueOf(_theGroup.getId()), _bContainSelf);
        if (CMyString.isEmpty(sGroupIds)) {
            return null;
        }
        WCMFilter aFilter = new WCMFilter("", "", "");
        IdFilterSqlUtil.RangeSQL sql = IdFilterSqlUtil.make("GROUPID", sGroupIds);
        aFilter.setWhere(sql.getSql());
        int[] values = sql.getValues();
        if (values != null) {
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                aFilter.addSearchValues(values[i]);
            }
        }
        aFilter.mergeWith(_filter);
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public String getOffspringGroupIds(String _sGroupIds, boolean _bContainSelf) throws WCMException {
        if (CMyString.isEmpty(_sGroupIds)) {
            return null;
        }
        StringBuffer sbAllGroupIds = new StringBuffer();
        if (_bContainSelf) {
            sbAllGroupIds.append(_sGroupIds);
        }
        String sTmpGroupIds = _sGroupIds;
        String sWhere = "";
        while (true) {
            sWhere = IdFilterSqlUtil.makeAsString("ParentId", sTmpGroupIds);
            WCMFilter aFilter = new WCMFilter("", sWhere, "", "GroupId");
            Groups oChildGroups = Groups.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
            if (oChildGroups.size() == 0) break;
            sTmpGroupIds = oChildGroups.getIdListAsString();
            if (sbAllGroupIds.length() > 0) {
                sbAllGroupIds.append(",");
            }
            sbAllGroupIds.append(sTmpGroupIds);
        }
        return sbAllGroupIds.toString();
    }

    public Users getUsers(Group _theGroup, WCMFilter _filter, boolean _bContainsChildGrp) throws WCMException {
        if (!_bContainsChildGrp) {
            return this.getUsers(_theGroup, _filter);
        }
        if (_theGroup == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label12", "\u65e0\u6548\u7684\u7fa4\u7ec4\u5bf9\u8c61,\u65e0\u6cd5\u53d6\u5f97\u8be5\u7ec4\u5185\u7684\u7528\u6237"));
        }
        String sGroupIds = this.getOffspringGroupIds(String.valueOf(_theGroup.getId()), true);
        IdFilterSqlUtil.RangeSQL sql = IdFilterSqlUtil.make("GROUPID", sGroupIds);
        WCMFilter aFilter = new WCMFilter("", "EXISTS(SELECT GroupId FROM WCMGrpUser WHERE " + sql.getSql() + " AND WCMGrpUser.UserId=WCMUser.UserId)", "UserId");
        int[] v = sql.getValues();
        if (v != null) {
            int len = v.length;
            for (int i = 0; i < len; ++i) {
                aFilter.addSearchValues(v[i]);
            }
        }
        aFilter.mergeWith(_filter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Groups getGroups(User _user, WCMFilter _filter) throws WCMException {
        if (_user == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u8be5\u7528\u6237\u80fd\u591f\u7ba1\u7406\u7684\u89d2\u8272!");
        }
        String sWhere = "GroupId in (select GroupId from WCMGrpUser where isAdministrator=1 and UserId=?)";
        WCMFilter filter = new WCMFilter(null, sWhere, null);
        filter.addSearchValues(_user.getId());
        filter.mergeWith(_filter);
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), filter);
    }

    public Groups getOffspringGroups(User _user, WCMFilter _filter) throws WCMException {
        if (_user == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u8be5\u7528\u6237\u80fd\u591f\u7ba1\u7406\u7684\u89d2\u8272!");
        }
        String sWhere = "GroupId in (select GroupId from WCMGrpUser where isAdministrator=1 and UserId=?)";
        WCMFilter filter = new WCMFilter(null, sWhere, null);
        filter.addSearchValues(_user.getId());
        filter.mergeWith(_filter);
        Groups groups = Groups.openWCMObjs(ContextHelper.getLoginUser(), filter);
        Groups resultGroups = Groups.createNewInstance(null);
        this.addGroups(resultGroups, groups);
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            Groups offspringGroups = this.getOffspringGroups(group, false, null);
            this.addGroups(resultGroups, offspringGroups);
        }
        return resultGroups;
    }

    private Groups addGroups(Groups srcGroups, Groups groupsAdded) throws WCMException {
        if (groupsAdded == null) {
            return srcGroups;
        }
        int nSize = groupsAdded.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groupsAdded.getAt(i);
            if (group == null || srcGroups.indexOf(group) >= 0) continue;
            srcGroups.addElement(group);
        }
        return srcGroups;
    }

    public boolean isAdministrator(Group _group, User _user, boolean _bContainAncestor) throws WCMException {
        if (_user == null || _group == null) {
            return false;
        }
        if (!_bContainAncestor) {
            return _group.isAdministrator(_user);
        }
        while (_group != null) {
            if (_group.isAdministrator(_user)) {
                return true;
            }
            _group = _group.getParent();
        }
        return false;
    }
}

