/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.ext.wcm;

import com.trs.DreamFactory;
import com.trs.cluster.ext.wcm.ClusterProxyFilter;
import com.trs.cluster.ext.wcm.ClusterStateChangeFactory;
import com.trs.cluster.ext.wcm.ClusterWatchDog;
import com.trs.cluster.ext.wcm.IClusterStateChangeListener;
import com.trs.cluster.ext.wcm.MemberServiceChecker;
import com.trs.components.common.job.JobScheduleServer;
import com.trs.components.common.publish.domain.publisher.PageDestroyer;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskDispatcher;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.TokenEvent;
import com.trs.infra.cluster.TokenListener;
import com.trs.infra.cluster.locks.tokenevent.TokenDuplicatedEvent;
import com.trs.infra.cluster.locks.tokenevent.TokenOwnedEvent;
import com.trs.infra.cluster.locks.tokenevent.TokenReceivedEvent;
import com.trs.infra.cluster.locks.tokenevent.TokenSuspectEvent;
import com.trs.infra.common.WCMException;
import java.util.List;
import org.apache.log4j.Logger;

public class MasterTokenListener
implements TokenListener {
    private static final Logger LOG = Logger.getLogger(MasterTokenListener.class);

    public boolean actionPerformed(TokenEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("performe token action: " + event));
        }
        if (event instanceof TokenSuspectEvent) {
            return this.doSuspect((TokenSuspectEvent)event);
        }
        if (event instanceof TokenOwnedEvent) {
            return this.doOwned((TokenOwnedEvent)event);
        }
        if (event instanceof TokenReceivedEvent) {
            return this.doReceived(event);
        }
        if (event instanceof TokenDuplicatedEvent) {
            return this.doDuplicated((TokenDuplicatedEvent)event);
        }
        return true;
    }

    private boolean doReceived(TokenEvent event) {
        ClusterProxyFilter.setMasterProxy(event.getSource());
        return true;
    }

    private boolean doSuspect(TokenSuspectEvent event) {
        Member source = event.getSource();
        boolean zAlive = MemberServiceChecker.isAlive(source);
        return !zAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOwned(TokenOwnedEvent event) {
        JobScheduleServer jobScheduleServer;
        event.getContext().getConfig().setMaster(true);
        IPublishTaskDispatcher taskDispatcher = (IPublishTaskDispatcher)DreamFactory.createObjectById("IPublishTaskDispatcher");
        try {
            taskDispatcher.startup();
        }
        catch (WCMException e) {
            LOG.error((Object)"master token owned faield.", (Throwable)e);
            return false;
        }
        JobScheduleServer jobScheduleServer2 = jobScheduleServer = (JobScheduleServer)DreamFactory.createObjectById("JobScheduleServer");
        synchronized (jobScheduleServer2) {
            if (!jobScheduleServer.isStarted()) {
                if (!jobScheduleServer.startup()) {
                    return false;
                }
            } else if (!jobScheduleServer.restart()) {
                return false;
            }
            LOG.info((Object)"\u8ba1\u5212\u8c03\u5ea6\u670d\u52a1\u5668\u542f\u52a8\u5b8c\u6210.");
        }
        PageDestroyer.reinit();
        ClusterProxyFilter.setMasterProxy(null);
        List oClusterStateChangeListenerList = ClusterStateChangeFactory.getInstance().getClusterStateChangeListeners();
        if (null != oClusterStateChangeListenerList && oClusterStateChangeListenerList.size() > 0) {
            for (int i = 0; i < oClusterStateChangeListenerList.size(); ++i) {
                IClusterStateChangeListener oClusterStateChangeListener = (IClusterStateChangeListener)oClusterStateChangeListenerList.get(i);
                oClusterStateChangeListener.doOwned(event);
            }
        }
        LOG.info((Object)"Master token owned success.");
        return true;
    }

    private boolean doDuplicated(TokenDuplicatedEvent event) {
        String current = event.getSource().getTCPAddress().getHostAddress();
        ClusterWatchDog dog = new ClusterWatchDog(current);
        boolean ok = dog.barkOnTokenDuplicated();
        return ok;
    }
}

