/*
 * Decompiled with CFR 0.152.
 */
package com.trs.bigfile;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class FileHierarchy {
    private static final char CHAR_TAB = '\t';
    private static final String CONF = "/bigfile_hierarchy.properties";
    private static final FileHierarchy INSTANCE = new FileHierarchy();
    private static final String ENCODING = "utf-8";
    private List items = new ArrayList(32);

    private FileHierarchy() {
    }

    public static FileHierarchy getInstance() {
        return INSTANCE;
    }

    public List items() throws Exception {
        this.ensureDataLoaded();
        return this.items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDataLoaded() throws Exception {
        if (this.items.isEmpty()) {
            List list = this.items;
            synchronized (list) {
                this.loadData();
            }
        }
    }

    public String toTreeHtml() throws Exception {
        this.ensureDataLoaded();
        StringBuffer buff = new StringBuffer(512);
        boolean zFirstNode = true;
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            boolean zTopLevel;
            Item item = (Item)this.items.get(i);
            boolean bl = zTopLevel = item.getLevel() == 1;
            if (zTopLevel && i > 0) {
                buff.append("</ul>");
            }
            if (zFirstNode && !zTopLevel) {
                zFirstNode = false;
                buff.append("<div id='firstnode' style='display:none'></div>");
            }
            buff.append("<div id='");
            buff.append(item.getName()).append('_').append(item.getLevel());
            buff.append("' _value='");
            buff.append(item.getName());
            buff.append("' class='");
            if (zTopLevel) {
                buff.append("treeNodeOpen");
            } else {
                buff.append("treeNodePage");
            }
            buff.append("'>");
            buff.append(item.getDesc());
            buff.append("</div>");
            if (zTopLevel) {
                buff.append("<ul>");
                continue;
            }
            if (i != size - 1) continue;
            buff.append("</ul>");
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() throws Exception {
        InputStream ins = null;
        InputStreamReader insr = null;
        BufferedReader reader = null;
        Class<FileHierarchy> clazz = FileHierarchy.class;
        try {
            ins = clazz.getResourceAsStream(CONF);
            if (ins == null) {
                ins = clazz.getResourceAsStream(CONF.substring(1));
            }
            insr = new InputStreamReader(ins, ENCODING);
            reader = new BufferedReader(insr);
            String line = null;
            ArrayList<Item> data = new ArrayList<Item>(32);
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0 || line.trim().charAt(0) == '#') continue;
                int level = 1;
                if (line.charAt(0) == '\t') {
                    line = line.trim();
                    level = 2;
                }
                String[] parts = line.split("=");
                Item item = new Item(parts[0], parts[1], level);
                data.add(item);
            }
            this.items.addAll(data);
            data.clear();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(FileHierarchy.getInstance().items());
            System.out.println(FileHierarchy.getInstance().toTreeHtml());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Item {
        private final String name;
        private final String desc;
        private final int level;
        private int hashCode = 0;

        public Item(String name, String desc, int level) {
            this.name = name;
            this.desc = desc;
            this.level = level;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 23;
                int prime = 37;
                result = result * 37 + this.name.hashCode();
                this.hashCode = result = result * 37 + this.level;
            }
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Item)) {
                return false;
            }
            Item compared = (Item)other;
            return this.name.equals(compared.getName()) && this.level == compared.getLevel();
        }

        public final String getName() {
            return this.name;
        }

        public final String getDesc() {
            return this.desc;
        }

        public final int getLevel() {
            return this.level;
        }

        public String toString() {
            return this.name + "," + this.level;
        }
    }
}

