/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.filter;

import com.trs.ajaxservice.ChannelServiceProvider;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.webframework.config.ServiceFilterConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IServiceFilter;

public class ChannelInheritFilter
implements IServiceFilter {
    @Override
    public boolean doFilter(ServiceFilterConfig _oFilterConfig, MethodContext _oMethodContext) {
        try {
            int nObjectId = _oMethodContext.getObjectId();
            if (nObjectId != 0) {
                return true;
            }
            BaseChannel parent = this.getParentChannelOrSite(_oMethodContext);
            int inherit = 0;
            if (parent instanceof Channel) {
                inherit = parent.getPropertyAsInt("INHERIT", 0);
            }
            _oMethodContext.setValue("INHERIT", inherit);
            _oMethodContext.setValue("PARENTCHANNEL", parent);
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        return true;
    }

    private BaseChannel getParentChannelOrSite(MethodContext _methodContext) throws WCMException {
        BaseChannel parent;
        int nParentId = _methodContext.getValue("ParentId", 0);
        if (nParentId == 0) {
            int nSiteId = _methodContext.getValue("SiteId", 0);
            if (nSiteId <= 0) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label6", "\u6ca1\u6709\u6307\u5b9aParentId\u6216\u8005SiteId    "));
            }
            parent = WebSite.findById(nSiteId);
            if (parent == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nSiteId), WCMTypes.getLowerObjName(103)}));
            }
        } else {
            parent = Channel.findById(nParentId);
            if (parent == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nParentId), WCMTypes.getLowerObjName(101)}));
            }
        }
        return parent;
    }
}

