/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.DebugTimer;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class WebSiteHelper {
    private static Logger logger = Logger.getLogger(WebSiteHelper.class);

    public static WebSites getWebSitesByType(User _loginUser, int _nSiteType, WCMFilter queryFilter) throws WCMException {
        String sWhere = "Status>=0 and SiteType=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _nSiteType);
        filter.mergeWith(queryFilter);
        WebSites sites = WebSites.openWCMObjs(_loginUser, filter);
        if (_loginUser.isAdministrator()) {
            return sites;
        }
        for (int i = sites.size() - 1; i >= 0; --i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site == null || WebSiteHelper.isVisible(_loginUser, site)) continue;
            sites.removeAt(i, false);
        }
        return sites;
    }

    public static WebSites getWebSitesByTypeWithIndividual(User _loginUser, int _nSiteType, WCMFilter queryFilter, Hashtable customSiteIdHt, boolean _bForIndividual) throws WCMException {
        DebugTimer timer = new DebugTimer();
        timer.start();
        String sWhere = "Status>=0 and SiteType=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _nSiteType);
        filter.mergeWith(queryFilter);
        WebSites sites = WebSites.openWCMObjs(_loginUser, filter);
        if (_loginUser.isAdministrator() && !_bForIndividual) {
            timer.stop();
            logger.debug((Object)("get sites of [" + _loginUser + "] use [" + timer.getTime() + "]ms!"));
            return sites;
        }
        String isStartSeparate = ConfigServer.getServer().getInitProperty("SEPARATION_OF_THREE_POWERS");
        if ("true".equalsIgnoreCase(isStartSeparate) && (_loginUser.isSecurityAdmin() || _loginUser.isAuditAdmin())) {
            return WebSites.createNewInstance(_loginUser);
        }
        for (int i = sites.size() - 1; i >= 0; --i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site == null) continue;
            if (!WebSiteHelper.isVisible(_loginUser, site)) {
                sites.removeAt(i, false);
                continue;
            }
            if (!_bForIndividual || customSiteIdHt == null || customSiteIdHt.size() <= 0 || customSiteIdHt.get(String.valueOf(site.getId())) != null) continue;
            sites.removeAt(i, false);
        }
        timer.stop();
        logger.debug((Object)("get sites of [" + _loginUser + "] use [" + timer.getTime() + "]ms!"));
        return sites;
    }

    public static boolean isVisible(User _loginUser, WebSite _site) throws WCMException {
        return AuthServer.hasRight(_loginUser, (CMSObj)_site, 64);
    }

    public static WebSites getWebSitesByRightIndex(User _loginUser, int _nRightIndex, WCMFilter extraFilter, Hashtable customSiteIdHt, boolean _bForIndividual) throws WCMException {
        DebugTimer timer = new DebugTimer();
        timer.start();
        WebSites sites = WebSites.openWCMObjs(_loginUser, extraFilter);
        if (_loginUser.isAdministrator() && !_bForIndividual) {
            timer.stop();
            logger.debug((Object)("get sites of [" + _loginUser + "] use [" + timer.getTime() + "]ms!"));
            return sites;
        }
        for (int i = sites.size() - 1; i >= 0; --i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site == null) continue;
            if (!AuthServer.hasRight(_loginUser, (CMSObj)site, _nRightIndex)) {
                sites.removeAt(i, false);
                continue;
            }
            if (!_bForIndividual || customSiteIdHt == null || customSiteIdHt.size() <= 0 || customSiteIdHt.get(String.valueOf(site.getId())) != null) continue;
            sites.removeAt(i, false);
        }
        timer.stop();
        logger.debug((Object)("get sites of [" + _loginUser + "] use [" + timer.getTime() + "]ms!"));
        return sites;
    }

    public static void removeNoRightSite(User _loginUser, WebSites _sites, int _nRightIndex) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return;
        }
        for (int i = _sites.size() - 1; i >= 0; --i) {
            Channel site = (Channel)_sites.getAt(i);
            if (site == null || AuthServer.hasRight(_loginUser, (CMSObj)site, _nRightIndex)) continue;
            _sites.removeAt(i, false);
        }
    }
}

