/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.system.Const;
import com.trs.idm.util.StringHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringValidator {
    public static boolean basicValidate(String str) {
        return StringValidator.basicValidate(str, 255);
    }

    public static boolean basicValidate(String str, int maxLength) {
        if (str == null) {
            return false;
        }
        if ("".equals(str.trim())) {
            return false;
        }
        return str.length() <= maxLength;
    }

    public static boolean basicValidate(String str, int minLength, int maxLength) {
        if (str == null) {
            return false;
        }
        if ("".equals(str.trim()) && minLength != 0) {
            return false;
        }
        if (str.length() < minLength) {
            return false;
        }
        return str.length() <= maxLength;
    }

    public static boolean isValidMobile(String str, String validateMobileRules) {
        if (StringHelper.isEmpty(str)) {
            return false;
        }
        if (StringHelper.isEmpty(validateMobileRules)) {
            return StringValidator.isNumeric(str);
        }
        return StringValidator.isMatch(str, "^(" + validateMobileRules + ")\\d{8}$");
    }

    public static boolean isMatch(String str, String regex) {
        Pattern pattern = null;
        if (StringHelper.isEmpty(regex)) {
            return true;
        }
        if (StringHelper.isEmpty(str)) {
            return false;
        }
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static boolean isValidCNMobile(String str) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        if (!StringValidator.isNumeric(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static boolean isValidPhone(String str) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        Pattern pattern = Pattern.compile("^([0-9+\\-(\\))(\\()]{1,255})$");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static boolean isValidEmail(String str) {
        if (StringHelper.isEmpty(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[\\w-_]+(\\.[\\w-_]+)*@([\\w-_]+\\.)+[\\w]{2,}$");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static boolean isValidMultiEmails(String str) {
        if (StringHelper.isEmpty(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^([\\w-_]+(\\.[\\w-_]+)*@[\\w-]+(\\.[\\w-_]+)+;)+([\\w-_]+(\\.[\\w-_]+)*@[\\w-]+(\\.[\\w-_]+)+)$");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static boolean basicValidateAllowEmpty(String str, int maxLength) {
        if (str == null) {
            return false;
        }
        return str.length() <= maxLength;
    }

    public static boolean isInAllowLength(String str, int maxLength) {
        if (str == null) {
            return true;
        }
        return str.length() < maxLength;
    }

    public static boolean isValidUserName(String str) {
        if (StringValidator.isEmpty(str)) {
            return false;
        }
        if (str.length() > 255) {
            return false;
        }
        int i = 0;
        while (i < Const.RESERVER_USERNAMES.length) {
            if (Const.RESERVER_USERNAMES[i].equalsIgnoreCase(str)) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < Const.ILLEGAL_CHARS.length) {
            if (str.indexOf(Const.ILLEGAL_CHARS[i]) >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWithLetter(String str) {
        if (StringValidator.isEmpty(str)) {
            return false;
        }
        return Character.isLetter(str.charAt(0));
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isIncludeChinese(String str) {
        if (StringHelper.isEmpty(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\s*\\S*[\\u0391-\\uFFE5]+\\s*\\S*$");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static boolean hasFullAngleSpecialCharacter(String str) {
        char[] charArray = str.toCharArray();
        int index = 0;
        while (index < charArray.length) {
            if (charArray[index] < '\u4e00' || charArray[index] > '\u9fbb') {
                if (charArray[index] == '\u3000') {
                    return true;
                }
                if (charArray[index] > '\uff00' && charArray[index] < '\uff5f') {
                    return true;
                }
            }
            ++index;
        }
        return false;
    }

    public static boolean validateUrl(String url) {
        if (url == null) {
            return false;
        }
        String regEx = "^(http(s?)://)((((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5]))|localhost|(([a-zA-Z-]{1,62}(\\d*))(\\.[a-zA-Z0-9-]{1,62})+))(:\\d{1,5})?(/\\w+)*(/?|(/\\w+\\.?\\w+))?)$";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(url.trim());
        return m.find();
    }

    public static boolean validateCreditID(String creditID) {
        if (creditID == null) {
            return false;
        }
        String regEx18 = "^[1-9]\\d{5}((19\\d{2})|(200\\d))((0\\d)|(1[0-2]))(([0-2]\\d)|(3[0-1]))\\d{3}(\\d|X|x)$";
        Pattern p18 = Pattern.compile(regEx18);
        Matcher m18 = p18.matcher(creditID.trim());
        String regEx15 = "^[1-9]\\d{5}\\d{2}((0\\d)|(1[0-2]))(([0-2]\\d)|(3[0-1]))\\d{3}$";
        Pattern p15 = Pattern.compile(regEx15);
        Matcher m15 = p15.matcher(creditID.trim());
        return m18.find() || m15.find();
    }

    public static boolean isValidPost(String post) {
        if (!StringValidator.isNumeric(post)) {
            return false;
        }
        return post.length() == 6;
    }

    public static boolean isNumeric(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\d+$");
        return pattern.matcher(input).matches();
    }

    public static boolean isFax(String fax) {
        if (StringHelper.isEmpty(fax)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^(((\\+|0)[0-9]{2,3})-)?((0[0-9]{2,3})-)?([0-9]{8})(-([0-9]{3,4}))?$");
        return pattern.matcher(fax).matches();
    }
}

