/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.interact.impl.simple.request;

import com.trs.idm.exception.ServiceProviderException;
import com.trs.idm.saml.interact.IResponse;
import com.trs.idm.saml.interact.RequestBase;
import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.saml.sp.transporter.ITransporter;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SimpleSSOLogoutRedirectRequest
extends RequestBase {
    private static final Logger LOG = Logger.getLogger(SimpleSSOLogoutRedirectRequest.class);

    public SimpleSSOLogoutRedirectRequest(IServiceProvider sp, HttpServletRequest request) {
        this.requestType = "SimpleSSOLogoutRedirectRequest";
        this.serviceProvider = sp;
        LOG.info((Object)"create requestSimpleSSOLogoutRedirectRequest;");
    }

    @Override
    public IResponse doRequest(HttpServletRequest request, HttpServletResponse response) throws ServiceProviderException {
        ITransporter transporter = this.serviceProvider.getTransporterManager().getTransporter("httpClient");
        if (transporter == null) {
            LOG.error((Object)"can not find Transporter by name: httpClient");
            return null;
        }
        transporter.doTransport(this, request, response);
        String redirectUrl = RequestUtil.getParameterAndTrim(request, "afterLogoutOK.gotoUrl");
        if (StringHelper.isEmpty(redirectUrl)) {
            LOG.info((Object)"there is not afterLogoutOK.gotoUrl parameter in HttpRequest, get it from configFile");
            redirectUrl = this.serviceProvider.getConfig().getConfig("afterLogoutOK.gotoUrl");
        }
        if (StringHelper.isEmpty(redirectUrl)) {
            LOG.info((Object)"there is not afterLogoutOK.gotoUrl parameter in configFile, set context root as redirectUrl");
            redirectUrl = RequestUtil.getContextRoot(request);
        }
        LOG.info((Object)("redirectUrl is: " + redirectUrl + ", about to redirect."));
        try {
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            LOG.error((Object)("error while doSSoLougou and redirect back to: " + redirectUrl), (Throwable)e);
            throw new ServiceProviderException("\u5355\u70b9\u767b\u51fa\u540e\uff0c\u91cd\u5b9a\u5411\u5230\uff1a " + redirectUrl + "\u53d1\u751f\u9519\u8bef\uff01", e);
        }
        return null;
    }

    @Override
    public IServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }
}

