/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.interact;

import com.trs.idm.exception.ServiceProviderException;
import com.trs.idm.saml.common.SPConfig;
import com.trs.idm.saml.interact.IRequest;
import com.trs.idm.saml.interact.IResponse;
import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.StringHelper;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class RequestBase
implements IRequest {
    private static final Logger LOG = Logger.getLogger(RequestBase.class);
    protected String requestType;
    protected String requestCode;
    protected String requestBody;
    protected String base64RequestBody;
    protected IServiceProvider serviceProvider;
    protected Map nameValuePairs = new HashMap();
    protected boolean isDebug;

    @Override
    public String getRequestType() {
        return this.requestType;
    }

    @Override
    public boolean validate() {
        return false;
    }

    @Override
    public void addNameValue(String name, Object value) {
        this.nameValuePairs.put(name, value);
    }

    @Override
    public String getRequestBody() {
        return this.requestBody;
    }

    @Override
    public Object getNameValue(String name) {
        return this.nameValuePairs.get(name);
    }

    @Override
    public abstract IResponse doRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServiceProviderException;

    @Override
    public String getBase64RequestBody() {
        return Base64Util.encode(this.requestBody);
    }

    public String getIssuser() {
        return this.serviceProvider.getConfig().getConfig(SPConfig.SSO_SAML2_CONFIG_ISSUER, "Issuer is not configured!");
    }

    @Override
    public Map getOriginalParamAsMap(HttpServletRequest request) {
        return new HashMap();
    }

    protected String getAferLoginOkUrl(HttpServletRequest request) {
        String afterLoginOKUrl = this.serviceProvider.getConfig().getConfig("afterLoginOK.gotoUrl");
        LOG.debug((Object)("afterLoginOKUrl in config: " + afterLoginOKUrl));
        if (StringHelper.isEmpty(afterLoginOKUrl)) {
            LOG.info((Object)"has not config afterLoginOk.goToUrl, return index.jsp");
            return "index.jsp";
        }
        return afterLoginOKUrl;
    }

    protected String getAferLoginFailUrl(HttpServletRequest request) {
        String afterLoginFailUrl = this.serviceProvider.getConfig().getConfig("afterLoginFail.gotoUrl");
        LOG.debug((Object)("afterLoginFailUrl in config: " + afterLoginFailUrl));
        if (StringHelper.isEmpty(afterLoginFailUrl)) {
            LOG.info((Object)"has not config afterLoginOk.goToUrl, return null");
            return "index.jsp";
        }
        return afterLoginFailUrl;
    }
}

