/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.IdentityServer;
import com.trs.idm.data.bo.CoApp;
import com.trs.idm.data.bo.User;
import com.trs.idm.model.permission.IPermissionServer;
import com.trs.idm.model.service.user.IUserService;
import com.trs.idm.ui.Operation;
import com.trs.idm.util.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class MenuUtil {
    public static List getAllowedOpers(IdentityServer idmServer, User user, List operations, String groupName) {
        ArrayList<Operation> allowedOperations = new ArrayList<Operation>();
        if (user == null || idmServer == null) {
            return allowedOperations;
        }
        IPermissionServer permissionServer = idmServer.getModelService().getPermissionServer();
        String userName = user.getUserName();
        for (Operation oper : operations) {
            String uri;
            if (!permissionServer.havePermission(userName, uri.substring(0, (uri = oper.getLink()).indexOf(63) < 0 ? uri.length() : uri.indexOf(63)), groupName)) continue;
            allowedOperations.add(oper);
        }
        return allowedOperations;
    }

    public static String createOperHtmlWithoutCheckPrms(List operations, String contextPath, String[] parameters) {
        if (operations == null || operations.isEmpty()) {
            return "";
        }
        StringBuffer html = new StringBuffer();
        html.append("<ul id=\"sddm\">");
        int i = 0;
        boolean hasMoreAction = false;
        while (i < operations.size()) {
            Operation oper = (Operation)operations.get(i);
            if (!StringHelper.isEmpty(oper.getIcon())) {
                String click = StringHelper.isEmpty(oper.getClickEvent()) ? "window.location.href='" + contextPath + oper.getLink() + "';" : oper.getClickEvent().replaceAll("this.href", "'" + contextPath + oper.getLink() + "'");
                html.append("<li><img width=\"16\" height=\"16\" style=\"cursor: pointer;\" title=\"").append(oper.getName()).append("\" src=\"").append(contextPath).append(oper.getIcon()).append("\" onclick=\"").append(click).append("\"/>");
            } else {
                hasMoreAction = true;
            }
            ++i;
        }
        if (hasMoreAction) {
            String index = String.valueOf(Math.random()).replaceAll("\\.", "_");
            html.append("<li><a href=\"#\" onclick=\"return false;\" onmouseover=\"mopen('m_more_action" + index + "')\" onmouseout=\"mclosetime()\">\u66f4\u591a\u64cd\u4f5c...</a>").append("<div id=\"m_more_action" + index + "\" onmouseover=\"mcancelclosetime()\" onmouseout=\"mclosetime()\">");
            int k = 0;
            while (k < operations.size()) {
                Operation oper = (Operation)operations.get(k);
                if (StringHelper.isEmpty(oper.getIcon())) {
                    html.append("<a href=\"").append(String.valueOf(contextPath) + oper.getLink()).append("\"").append(" onclick = \"").append(StringHelper.isEmpty(oper.getClickEvent()) ? "window.location.href=this.href;" : oper.getClickEvent()).append("\"").append(">").append(oper.getName()).append("</a>");
                }
                ++k;
            }
            html.append("</div></li>");
            html.append("</ul><div style=\"clear:both\"></div>");
        }
        if (parameters != null && parameters.length > 0) {
            int j = 0;
            while (j < parameters.length) {
                String para = "{" + (j + 1) + "}";
                int fromIndex = 0;
                int paraIndex = html.indexOf(para, fromIndex);
                while (paraIndex >= 0) {
                    html.replace(paraIndex, paraIndex + para.length(), parameters[j]);
                    fromIndex = paraIndex;
                    paraIndex = html.indexOf(para, fromIndex);
                }
                ++j;
            }
        }
        return html.toString();
    }

    public static String createOperHtmlWithCheckPrms(IdentityServer idmServer, User user, List operations, String groupName, String contextPath, String[] parameters) {
        return MenuUtil.createOperHtmlWithoutCheckPrms(MenuUtil.getAllowedOpers(idmServer, user, operations, groupName), contextPath, parameters);
    }

    public static String createMenuHtmlWithRole(IdentityServer idmServer, User user) {
        if (user == null) {
            return "";
        }
        IUserService userService = idmServer.getModelService().getServiceContext().getUserService();
        IPermissionServer permissionServer = idmServer.getModelService().getPermissionServer();
        try {
            if (userService.isSuperAdmin(user)) {
                return MenuUtil.creatMenuHtmlForSuperAdmin(idmServer, permissionServer, user);
            }
            if (idmServer.getModelService().getPermissionServer().getRoleService().isUserHasRole(user.getUserName())) {
                return MenuUtil.creatMenuHtmlForOtherRoles(idmServer, permissionServer, user);
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String creatMenuHtmlForSuperAdmin(IdentityServer idmServer, IPermissionServer permissionServer, User user) {
        StringBuffer menuBuffer = new StringBuffer();
        String rootName_label = idmServer.getModelService().getGlobalConfigMgr().getConfigValue("sys.group.rootName", "\u673a\u6784");
        menuBuffer.append("<ul id=\"navigation\" style=\"z-index:10;\" >");
        menuBuffer.append("<li><a href=\"guide.jsp\" target=\"content\">\u9996\u9875</a></li>");
        menuBuffer.append("<li ><a href=\"group/main.jsp\" target=\"content\"> " + rootName_label + "\u4e0e\u4eba\u5458 </a></li>");
        menuBuffer.append("<li ><a href=\"coapp/list.jsp?coAppStatus=" + CoApp.COAPP_STATUS_AUDITED + "\" target=\"content\"> \u5e94\u7528</a></li>");
        menuBuffer.append("<li><a href=\"permission/main.jsp\" target=\"content\"> \u7ba1\u7406\u53f0\u6743\u9650 </a></li>");
        menuBuffer.append("<li>");
        menuBuffer.append("<a href=\"statistic/index.jsp\" target=\"content\">\u7edf\u8ba1</a>");
        menuBuffer.append("</li>");
        menuBuffer.append("<li>");
        menuBuffer.append("<a href=\"log/main.jsp\" target=\"content\">\u5ba1\u8ba1</a>");
        menuBuffer.append("</li>");
        boolean isOpenDomain = idmServer.supportDomain();
        if (isOpenDomain) {
            String domainMetaDataName = idmServer.getModelService().getServiceContext().getDomainService().getDomainMetaName();
            menuBuffer.append("<li>");
            menuBuffer.append("<a href=\"domain/list.jsp\" target=\"content\">" + domainMetaDataName + "</a>");
            menuBuffer.append("</li>");
        }
        menuBuffer.append("<li>");
        menuBuffer.append("<a href=\"useroperation/index.jsp\" target=\"content\">\u7528\u6237\u884c\u4e3a\u5206\u6790</a>");
        menuBuffer.append("</li>");
        menuBuffer.append("<li>");
        menuBuffer.append("<a href=\"payment/main.jsp\" target=\"content\">\u652f\u4ed8\u4e0e\u7ed3\u7b97</a>");
        menuBuffer.append("</li>");
        menuBuffer.append("<li >");
        menuBuffer.append("<a href=\"sys/main.jsp\" target=\"content\">\u7cfb\u7edf </a>");
        menuBuffer.append("</li>");
        menuBuffer.append("</ul>");
        return menuBuffer.toString();
    }

    private static String creatMenuHtmlForOtherRoles(IdentityServer idmServer, IPermissionServer permissionServer, User user) {
        boolean isOpenDomain;
        StringBuffer menuBuffer = new StringBuffer();
        String rootName_label = idmServer.getModelService().getGlobalConfigMgr().getConfigValue("sys.group.rootName", "\u673a\u6784");
        menuBuffer.append("<ul id=\"navigation\" style=\"z-index:10;\" >");
        if (permissionServer.havePermission(user.getUserName(), "/admin/guide.jsp", null)) {
            menuBuffer.append("<li><a href=\"guide.jsp\" target=\"content\">\u9996\u9875</a></li>");
        }
        if (permissionServer.havePermission(user.getUserName(), "/admin/group/main.jsp", null)) {
            menuBuffer.append("<li ><a href=\"group/main.jsp\" target=\"content\"> " + rootName_label + "\u4e0e\u4eba\u5458 </a></li>");
        }
        if (permissionServer.havePermission(user.getUserName(), "/admin/coapp/list.jsp", null)) {
            menuBuffer.append("<li ><a href=\"coapp/list.jsp?coAppStatus=audited\" target=\"content\"> \u5e94\u7528</a></li>");
        }
        if (permissionServer.havePermission(user.getUserName(), "/admin/permission/main.jsp", null)) {
            menuBuffer.append("<li><a href=\"permission/main.jsp\" target=\"content\"> \u7ba1\u7406\u53f0\u6743\u9650 </a></li>");
        }
        if (permissionServer.havePermission(user.getUserName(), "/admin/statistic/index.jsp", null)) {
            menuBuffer.append("<li><a href=\"statistic/index.jsp\" target=\"content\">\u7edf\u8ba1</a></li>");
        }
        if (permissionServer.havePermission(user.getUserName(), "/admin/log/main.jsp", null)) {
            menuBuffer.append("<li><a href=\"log/main.jsp\" target=\"content\">\u5ba1\u8ba1</a></li>");
        }
        if (isOpenDomain = idmServer.supportDomain()) {
            String domainMetaDataName = idmServer.getModelService().getServiceContext().getDomainService().getDomainMetaName();
            if (permissionServer.havePermission(user.getUserName(), "/admin/domain/list.jsp", null)) {
                menuBuffer.append("<li ><a href=\"domain/list.jsp\" target=\"content\" >" + domainMetaDataName + "</a></li>");
            }
        }
        if (permissionServer.havePermission(user.getUserName(), "/admin/useroperation/index.jsp", null)) {
            menuBuffer.append("<li>");
            menuBuffer.append("<a href=\"useroperation/index.jsp\" target=\"content\">\u7528\u6237\u884c\u4e3a\u5206\u6790</a>");
            menuBuffer.append("</li>");
        }
        if (permissionServer.havePermission(user.getUserName(), "/admin/payment/main.jsp", null)) {
            menuBuffer.append("<li>");
            menuBuffer.append("<a href=\"payment/main.jsp\" target=\"content\">\u652f\u4ed8\u4e0e\u7ed3\u7b97</a>");
            menuBuffer.append("</li>");
        }
        if (permissionServer.havePermission(user.getUserName(), "/admin/sys/main.jsp", null)) {
            menuBuffer.append("<li ><a href=\"sys/main.jsp\" target=\"content\" > \u7cfb\u7edf</a></li>");
        }
        menuBuffer.append("</ul>");
        return menuBuffer.toString();
    }
}

