/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.SQLStatementParser;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class JDBCHelper {
    private static final Logger LOG = Logger.getLogger(JDBCHelper.class);
    private String jdbcDriver;
    private String jdbcUrl;
    private String userName;
    private String passWord;

    public JDBCHelper(Map connectionInfo) {
        this.jdbcDriver = (String)connectionInfo.get("jdbcDriver");
        this.jdbcUrl = (String)connectionInfo.get("jdbcUrl");
        this.userName = (String)connectionInfo.get("userName");
        this.passWord = (String)connectionInfo.get("password");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("jdbcDriver:" + this.jdbcDriver + ",jdbcUrl:" + this.jdbcUrl + ",userName:" + this.userName + ",password:" + this.passWord));
        }
        if (this.jdbcDriver == null || this.jdbcUrl == null || this.userName == null || this.passWord == null) {
            throw new IllegalArgumentException("jdbcDriver:" + this.jdbcDriver + ",jdbcUrl:" + this.jdbcUrl + ",userName:" + this.userName + ",passWord:" + this.passWord);
        }
    }

    public boolean executeCommands(String statement, String userName, Map properties, Map parameterNames) throws ClassNotFoundException, SQLException {
        Connection connection = this.getConnection();
        boolean executed = true;
        try {
            try {
                connection.setAutoCommit(false);
                String[] statements = this.parseStatement(statement);
                int i = 0;
                while (i < statements.length) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("synchroniz... user(" + userName + ") by statement(" + statements[i] + ")."));
                    }
                    SQLStatementParser parser = new SQLStatementParser(statements[i]);
                    PreparedStatement actionStatement = connection.prepareStatement(parser.getPreparedStatement());
                    this.buildProperties(actionStatement, parser.getParameterNames(), properties, parameterNames);
                    executed &= actionStatement.execute();
                    ++i;
                }
                connection.commit();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {}
            }
        }
        return executed;
    }

    private void buildProperties(PreparedStatement actionStatement, String[] parameters, Map properties, Map parameterNames) throws SQLException {
        int i = 0;
        while (i < parameters.length) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Name:" + parameters[i] + ",Value:" + properties.get(parameters[i])));
                }
                actionStatement.setObject(i + 1, properties.get(parameters[i]));
                parameterNames.put(parameters[i], parameters[i]);
            }
            catch (SecurityException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            ++i;
        }
    }

    private String[] parseStatement(String statement) {
        StringTokenizer st = new StringTokenizer(statement, ";");
        String[] statements = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            statements[i] = st.nextToken();
            ++i;
        }
        return statements;
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("jdbcDriver:" + this.jdbcDriver + ",jdbcUrl:" + this.jdbcUrl + ",userName:" + this.userName + ",password:" + this.passWord));
        }
        Class.forName(this.jdbcDriver);
        return DriverManager.getConnection(this.jdbcUrl, this.userName, this.passWord);
    }
}

