/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.protocol;

import org.apache.log4j.Logger;

public abstract class ProtocolPacket {
    protected short bodyLength;
    protected short packetId;
    protected byte encryptAlgo;
    protected byte reversed1;
    protected byte reversed2;
    protected byte processCmd;
    protected byte[] bodyDatas;
    protected String[] bodyStrs;
    private static final Logger logger = Logger.getLogger(ProtocolPacket.class);
    private byte majorVersion = 0;

    protected ProtocolPacket() {
    }

    public String getData(byte index) {
        if (this.bodyStrs == null || index < 0 || index >= this.getDataCountAsInt()) {
            logger.warn((Object)("get bodyStrs[" + this.bodyStrs + "], index[" + index + "], getDataCount[" + this.getDataCount() + "], bodyLength[" + this.bodyLength + "], return null!"));
            return null;
        }
        String data = null;
        try {
            data = this.bodyStrs[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.error((Object)("run error while get data by bodyStrs[" + this.bodyStrs + "], index[" + index + "], return null directly!"), (Throwable)e);
            return null;
        }
        return data;
    }

    public String getData(int index) {
        if (this.bodyStrs == null || index < 0 || index >= this.getDataCountAsInt()) {
            logger.warn((Object)("get bodyStrs[" + this.bodyStrs + "], index[" + index + "], getDataCount[" + this.getDataCount() + "], bodyLength[" + this.bodyLength + "], return null!"));
            return null;
        }
        return this.bodyStrs[index];
    }

    public int getDataCountAsInt() {
        if (this.bodyStrs != null) {
            return this.bodyStrs.length;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get bodyStrs[" + this.bodyStrs + "] is null with bodyDatas[" + this.bodyDatas + "], so return dataCount as 0"));
        }
        return 0;
    }

    public byte getDataCount() {
        if (this.bodyStrs != null) {
            return (byte)this.bodyStrs.length;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get bodyStrs[" + this.bodyStrs + "] is null with bodyDatas[" + this.bodyDatas + "], so return dataCount as 0"));
        }
        return 0;
    }

    public String[] getAllData() {
        return this.bodyStrs;
    }

    public short getPacketId() {
        return this.packetId;
    }

    public String getSenderId() {
        return this.bodyStrs[0];
    }

    public short getBodyLength() {
        return this.bodyLength;
    }

    public byte getMajorVersion() {
        if (this.majorVersion == 0) {
            return 2;
        }
        return this.majorVersion;
    }

    public byte getMinorVersion() {
        return 0;
    }

    public abstract byte getPacketType();

    public abstract byte[] toBytes();

    public short getLength() {
        return 0;
    }

    public void setMajorVersion(byte majorVersion) {
        this.majorVersion = majorVersion;
    }
}

