/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.actor;

import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.util.CAUtil;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class SSOUser {
    private String userName;
    private String encryptedUserPwd;
    private String mail;
    private String nickName;
    private String trueName;
    private X509Certificate certificate;
    private List ssoGroups = new ArrayList();
    private Properties props;
    private String lastLoginDate;
    private String lastLoginIP;

    public SSOUser(Properties props) throws IllegalArgumentException {
        if (props == null) {
            throw new IllegalArgumentException("props is null!");
        }
        this.props = props;
        this.userName = props.getProperty("userName", "");
        if (this.userName == null || this.userName.trim().length() == 0) {
            throw new IllegalArgumentException("userName: [" + this.userName + "] is empty!");
        }
        this.nickName = props.getProperty("nickName", "");
        this.encryptedUserPwd = props.getProperty("encryptedUserPwd", "");
        this.mail = props.getProperty("email", "");
        this.trueName = props.getProperty("trueName", "");
        this.lastLoginDate = props.getProperty("lastLoginDate", "");
        this.lastLoginIP = props.getProperty("lastLoginIP", "");
        String pureCAPem = props.getProperty("caPem");
        if (pureCAPem != null) {
            String caPem = "-----BEGIN CERTIFICATE-----\n" + pureCAPem + "\n-----END CERTIFICATE-----";
            props.setProperty("caPem", caPem);
            try {
                props.put("x509ca", CAUtil.generateCertificate(caPem));
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
        }
        this.certificate = (X509Certificate)props.get("x509ca");
        this.buildSSOGroups(props);
    }

    void buildSSOGroups(Properties userProps) {
        SSOGroup group = new SSOGroup(userProps);
        this.ssoGroups.add(group);
    }

    public String getProperty(String propName) {
        return this.props.getProperty(propName, "");
    }

    public Set propertyNames() {
        return this.props.keySet();
    }

    public int totalPropertyKeys() {
        return this.props.size();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "; props: " + this.props;
    }

    Properties getProperties() {
        return this.props;
    }

    public String getEncryptedUserPwd() {
        return this.encryptedUserPwd;
    }

    public String getMail() {
        return this.mail;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getTrueName() {
        return this.trueName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setLastLoginDate(String lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public String getLastLoginIP() {
        return this.lastLoginIP;
    }

    public void setLastLoginIP(String lastLoginIP) {
        this.lastLoginIP = lastLoginIP;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public SSOGroup getSSOGroup() {
        if (this.ssoGroups.size() > 0) {
            return (SSOGroup)this.ssoGroups.get(0);
        }
        return null;
    }

    public List getSSOGroups() {
        return this.ssoGroups;
    }
}

