/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util.dbcp.impl;

import com.trs.util.dbcp.impl.DebugTimer;
import com.trs.util.dbcp.impl.Tracer;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class ImplPreparedStatement
implements PreparedStatement {
    private PreparedStatement statement;
    private String relSQL;
    private Map params;
    private DebugTimer timer;

    ImplPreparedStatement(PreparedStatement statement, String sql) {
        this.statement = statement;
        this.relSQL = sql;
        this.params = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                String key1 = (String)o1;
                String key2 = (String)o2;
                int k1 = Integer.parseInt(key1.substring(key1.lastIndexOf(45) + 1));
                int k2 = Integer.parseInt(key2.substring(key2.lastIndexOf(45) + 1));
                return k1 - k2;
            }
        });
        this.timer = new DebugTimer();
    }

    public void addBatch() throws SQLException {
        this.statement.addBatch();
    }

    public void addBatch(String sql) throws SQLException {
        this.statement.addBatch(sql);
    }

    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    public void clearParameters() throws SQLException {
        this.statement.clearParameters();
    }

    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    public void close() throws SQLException {
        this.statement.close();
    }

    public boolean execute() throws SQLException {
        this.timer.start();
        try {
            boolean bl = this.statement.execute();
            return bl;
        }
        finally {
            Tracer.trace(this.relSQL, this.timer.time(), this.params);
        }
    }

    public boolean execute(String sql) throws SQLException {
        this.timer.start();
        try {
            boolean bl = this.statement.execute(sql);
            return bl;
        }
        finally {
            Tracer.trace(sql, this.timer.time(), this.params);
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.timer.start();
        try {
            boolean bl = this.statement.execute(sql, autoGeneratedKeys);
            return bl;
        }
        finally {
            Tracer.trace(sql, this.timer.time(), this.params);
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.timer.start();
        try {
            boolean bl = this.statement.execute(sql, columnIndexes);
            return bl;
        }
        finally {
            Tracer.trace(sql, this.timer.time(), this.params);
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.timer.start();
        try {
            boolean bl = this.statement.execute(sql, columnNames);
            return bl;
        }
        finally {
            Tracer.trace(sql, this.timer.time(), this.params);
        }
    }

    public int[] executeBatch() throws SQLException {
        this.timer.start();
        try {
            int[] nArray = this.statement.executeBatch();
            return nArray;
        }
        finally {
            Tracer.trace(this.relSQL, this.timer.time(), this.params);
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.timer.start();
        try {
            ResultSet resultSet = this.statement.executeQuery();
            return resultSet;
        }
        finally {
            Tracer.trace(this.relSQL, this.timer.time(), this.params);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.timer.start();
        try {
            ResultSet resultSet = this.statement.executeQuery(sql);
            return resultSet;
        }
        finally {
            Tracer.trace(sql, this.timer.time(), this.params);
        }
    }

    public int executeUpdate() throws SQLException {
        this.timer.start();
        try {
            int n = this.statement.executeUpdate();
            return n;
        }
        finally {
            Tracer.trace(this.relSQL, this.timer.time(), this.params);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        this.timer.start();
        try {
            int n = this.statement.executeUpdate(sql);
            return n;
        }
        finally {
            Tracer.trace(sql, this.timer.time(), this.params);
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.timer.start();
        try {
            int n = this.statement.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        finally {
            Tracer.trace(sql, this.timer.time(), this.params);
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.timer.start();
        try {
            int n = this.statement.executeUpdate(sql, columnIndexes);
            return n;
        }
        finally {
            Tracer.trace(sql, this.timer.time(), this.params);
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.timer.start();
        try {
            int n = this.statement.executeUpdate(sql, columnNames);
            return n;
        }
        finally {
            Tracer.trace(sql, this.timer.time(), this.params);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.statement.getMetaData();
    }

    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.statement.getMoreResults(current);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.statement.getParameterMetaData();
    }

    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    public void setArray(int i, Array x) throws SQLException {
        this.statement.setArray(i, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.statement.setAsciiStream(parameterIndex, x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.statement.setBigDecimal(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.statement.setBinaryStream(parameterIndex, x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.statement.setBlob(i, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.statement.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.statement.setByte(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.statement.setBytes(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.statement.setCharacterStream(parameterIndex, reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.statement.setClob(i, x);
    }

    public void setCursorName(String name) throws SQLException {
        this.statement.setCursorName(name);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.statement.setDate(parameterIndex, x, cal);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.statement.setDate(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.statement.setDouble(parameterIndex, x);
        this.params.put("setDouble-" + parameterIndex, String.valueOf(x));
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.statement.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.statement.setFetchSize(rows);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.statement.setFloat(parameterIndex, x);
        this.params.put("setFloat-" + parameterIndex, String.valueOf(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.statement.setInt(parameterIndex, x);
        this.params.put("setInt-" + parameterIndex, String.valueOf(x));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.statement.setLong(parameterIndex, x);
        this.params.put("setLong-" + parameterIndex, String.valueOf(x));
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.statement.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.statement.setMaxRows(max);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.statement.setNull(paramIndex, sqlType, typeName);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.statement.setNull(parameterIndex, sqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.statement.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.statement.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.statement.setObject(parameterIndex, x);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement.setQueryTimeout(seconds);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.statement.setRef(i, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.statement.setShort(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.statement.setString(parameterIndex, x);
        this.params.put("setString-" + parameterIndex, String.valueOf(x));
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.statement.setTime(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.statement.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.statement.setTimestamp(parameterIndex, x, cal);
        this.params.put(cal + "-setTimestamp-" + parameterIndex, String.valueOf(x));
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.statement.setTimestamp(parameterIndex, x);
        this.params.put("setTimestamp-" + parameterIndex, String.valueOf(x));
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.statement.setUnicodeStream(parameterIndex, x, length);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.statement.setURL(parameterIndex, x);
    }
}

