/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class CollectionUtilTest
extends TestCase {
    public void testFilterList() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("b");
        List resultList = CollectionUtil.filterList(list);
        CollectionUtilTest.assertEquals((int)2, (int)resultList.size());
        CollectionUtilTest.assertTrue((boolean)resultList.contains("a"));
        CollectionUtilTest.assertTrue((boolean)resultList.contains("b"));
        resultList = CollectionUtil.filterList(null);
        CollectionUtilTest.assertNotNull((Object)resultList);
        CollectionUtilTest.assertTrue((boolean)resultList.isEmpty());
    }

    public void testFilterSet() throws Exception {
        HashSet<String> set1 = new HashSet<String>();
        set1.add("a");
        set1.add("b");
        set1.add("b");
        Set resultSet = CollectionUtil.filterSet(set1);
        CollectionUtilTest.assertEquals((int)2, (int)resultSet.size());
        CollectionUtilTest.assertTrue((boolean)resultSet.contains("a"));
        CollectionUtilTest.assertTrue((boolean)resultSet.contains("b"));
        resultSet = CollectionUtil.filterSet(null);
        CollectionUtilTest.assertNotNull((Object)resultSet);
        CollectionUtilTest.assertTrue((boolean)resultSet.isEmpty());
    }

    public void testIntersectList() throws Exception {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("b");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("b");
        list2.add("c");
        List resultList = CollectionUtil.intersectList(list1, list2);
        CollectionUtilTest.assertEquals((int)1, (int)resultList.size());
        CollectionUtilTest.assertFalse((boolean)resultList.contains("a"));
        CollectionUtilTest.assertTrue((boolean)resultList.contains("b"));
        list1.clear();
        list1.add("a");
        list2.clear();
        list2.add("b");
        resultList = CollectionUtil.intersectList(list1, list2);
        CollectionUtilTest.assertNotNull((Object)resultList);
        CollectionUtilTest.assertTrue((boolean)resultList.isEmpty());
    }

    public void testIntersectSet() throws Exception {
        HashSet<String> set1 = new HashSet<String>();
        set1.add("a");
        set1.add("b");
        set1.add("b");
        HashSet<String> set2 = new HashSet<String>();
        set2.add("b");
        set2.add("c");
        Set resultSet = CollectionUtil.intersectSet(set1, set2);
        CollectionUtilTest.assertEquals((int)1, (int)resultSet.size());
        CollectionUtilTest.assertFalse((boolean)resultSet.contains("a"));
        CollectionUtilTest.assertTrue((boolean)resultSet.contains("b"));
        set1.clear();
        set1.add("a");
        set2.clear();
        set2.add("b");
        resultSet = CollectionUtil.intersectSet(set1, set2);
        CollectionUtilTest.assertNotNull((Object)resultSet);
        CollectionUtilTest.assertTrue((boolean)resultSet.isEmpty());
    }

    public void testUnionList() throws Exception {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("b");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("b");
        list2.add("c");
        List resultList = CollectionUtil.unionList(list1, list2);
        CollectionUtilTest.assertEquals((int)3, (int)resultList.size());
        CollectionUtilTest.assertTrue((boolean)resultList.contains("a"));
        CollectionUtilTest.assertTrue((boolean)resultList.contains("b"));
        CollectionUtilTest.assertTrue((boolean)resultList.contains("c"));
    }

    public void testUnionSet() throws Exception {
        HashSet<String> set1 = new HashSet<String>();
        set1.add("a");
        set1.add("b");
        set1.add("b");
        HashSet<String> set2 = new HashSet<String>();
        set2.add("b");
        set2.add("c");
        Set resultSet = CollectionUtil.unionSet(set1, set2);
        CollectionUtilTest.assertEquals((int)3, (int)resultSet.size());
        CollectionUtilTest.assertTrue((boolean)resultSet.contains("a"));
        CollectionUtilTest.assertTrue((boolean)resultSet.contains("b"));
        CollectionUtilTest.assertTrue((boolean)resultSet.contains("c"));
    }

    public void testToArray() throws Exception {
        Object[] items = new Object[]{new Integer(1), "abcd", new Long(19820000L)};
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(items[0]);
        list.add(items[1]);
        list.add(items[2]);
        Object[] array = CollectionUtil.toArray(list);
        int i = 0;
        while (i < array.length) {
            CollectionUtilTest.assertEquals((Object)items[i], (Object)array[i]);
            ++i;
        }
    }
}

