/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class PropertiesUtil {
    public static void saveProperties(String filepath, Properties properties) throws IOException {
        PropertiesUtil.saveProperties(new File(filepath), properties);
    }

    public static void saveProperties(File file, Properties properties) throws IOException {
        boolean isxml = FileUtil.getFileExtendName(file.getName()).equalsIgnoreCase("xml");
        FileOutputStream os = new FileOutputStream(file);
        String comment = null;
        if (isxml) {
            properties.storeToXML(os, comment);
        } else {
            properties.store(os, comment);
        }
        ((OutputStream)os).close();
    }

    public static String loadProperty(File file, String key, String defaultValue) {
        try {
            Properties properties = PropertiesUtil.loadProperties(file);
            return properties.getProperty(key, defaultValue);
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    public static Properties loadProperties(File file) throws IOException {
        boolean isxml = FileUtil.getFileExtendName(file.getName()).equalsIgnoreCase("xml");
        Properties properties = new Properties();
        FileInputStream is = new FileInputStream(file);
        if (isxml) {
            properties.loadFromXML(is);
        } else {
            properties.load(is);
        }
        ((InputStream)is).close();
        return properties;
    }

    public static String loadProperty(String filepath, String key, String defaultValue) {
        return PropertiesUtil.loadProperty(new File(filepath), key, defaultValue);
    }

    public static Properties loadProperties(String filepath) throws IOException {
        return PropertiesUtil.loadProperties(new File(filepath));
    }

    public static String getProperty(Properties props, String key, String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        return (strValue = strValue.trim()).length() == 0 ? defaultValue : strValue;
    }

    public static long getPropertyAsLong(Properties props, String key, long defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(strValue.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getPropertyAsBool(Properties props, String key, boolean defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null || "".equals(strValue)) {
            return defaultValue;
        }
        try {
            return strValue.trim().equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getPropertyAsInt(Properties props, String key, int defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(strValue.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static float getPropertyAsFloat(Properties props, String key, float defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(strValue.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String[] getPropertyAsStrAry(Properties props, String key, String token) {
        if (props == null) {
            return null;
        }
        String value = props.getProperty(key);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value.split(token);
    }
}

