/*
 * Decompiled with CFR 0.152.
 */
package com.trs.jdbc.broker;

import com.trs.jdbc.broker.BrokerConnection;
import com.trs.jdbc.broker.BrokerResultSet;
import com.trs.jdbc.broker.access.BrokerProcess;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class BrokerPreparedStatement
implements PreparedStatement {
    BrokerConnection m_oConnection;
    BrokerResultSet m_oResultSet;

    BrokerPreparedStatement(BrokerConnection conn, String sSql) {
        this.m_oConnection = conn;
        this.setBrokerParameter(8, sSql);
    }

    public int executeUpdate() throws SQLException {
        return 0;
    }

    public void addBatch() throws SQLException {
    }

    public void clearParameters() throws SQLException {
        this.m_oConnection.m_oBrokerProcess.clearParameters();
    }

    public boolean execute() throws SQLException {
        return false;
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setBrokerParameter(parameterIndex, new Integer(x));
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setBrokerParameter(parameterIndex, null);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setBrokerParameter(parameterIndex, new Integer((int)x));
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setBrokerParameter(parameterIndex, new Integer(x));
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setBrokerParameter(parameterIndex, new Boolean(x));
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.setBrokerParameter(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
    }

    public void setArray(int i, Array x) throws SQLException {
    }

    public void setBlob(int i, Blob x) throws SQLException {
    }

    public void setClob(int i, Clob x) throws SQLException {
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    public void setRef(int i, Ref x) throws SQLException {
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.m_oConnection.isClosed()) {
            throw new SQLException("Attempted to use Connection after closed() was called.");
        }
        BrokerProcess process = this.m_oConnection.m_oBrokerProcess;
        process.newQuery();
        this.m_oResultSet = new BrokerResultSet(this);
        this.m_oResultSet.setColumnList();
        this.m_oResultSet.loadResultSet();
        return this.m_oResultSet;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.m_oResultSet != null) {
            return this.m_oResultSet.getMetaData();
        }
        return null;
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 0;
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    public int getMaxRows() throws SQLException {
        return 0;
    }

    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    public int getResultSetType() throws SQLException {
        return 0;
    }

    public int getUpdateCount() throws SQLException {
        return 0;
    }

    public void cancel() throws SQLException {
    }

    public void clearBatch() throws SQLException {
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        if (this.m_oResultSet != null) {
            this.m_oResultSet.close();
            this.m_oResultSet = null;
        }
    }

    public boolean getMoreResults() throws SQLException {
        return false;
    }

    public int[] executeBatch() throws SQLException {
        return null;
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public void setFetchSize(int rows) throws SQLException {
    }

    public void setMaxFieldSize(int max) throws SQLException {
    }

    public void setMaxRows(int max) throws SQLException {
    }

    public void setQueryTimeout(int seconds) throws SQLException {
    }

    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    public int executeUpdate(String sql) throws SQLException {
        return 0;
    }

    public void addBatch(String sql) throws SQLException {
    }

    public void setCursorName(String name) throws SQLException {
    }

    public boolean execute(String sql) throws SQLException {
        return false;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    public Connection getConnection() throws SQLException {
        return this.m_oConnection;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.m_oResultSet;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return null;
    }

    private void setBrokerParameter(int i, Object obj) {
        this.m_oConnection.m_oBrokerProcess.setParameter(i, obj);
    }
}

