/*
 * Decompiled with CFR 0.152.
 */
package t4j.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import t4j.TBlogException;
import t4j.TBlogResponse;
import t4j.data.PagableResponseList;
import t4j.data.SimpleStatus;
import t4j.http.Response;
import t4j.org.json.JSONArray;
import t4j.org.json.JSONException;
import t4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends TBlogResponse {
    private String name;
    private String location;
    private long id;
    private String description;
    private String profile_image_url;
    private String screen_name;
    private int gender;
    private String url;
    private Date created_at;
    private int followers_count;
    private int friends_count;
    private int favourites_count;
    private int statuses_count;
    private boolean geoEnable;
    private String[] sysTag;
    private String[] userTag;
    private String darenRec;
    private SimpleStatus status;
    private String reason;

    public User(Response res) throws TBlogException {
        this.init(res.asJSONObject());
    }

    public User(JSONObject json) throws TBlogException {
        this.init(json);
    }

    private void init(JSONObject json) throws TBlogException {
        try {
            int i;
            this.name = json.getString("name");
            this.location = json.getString("location");
            this.id = json.getLong("id");
            this.description = json.getString("description");
            this.profile_image_url = json.getString("profile_image_url");
            this.screen_name = json.getString("screen_name");
            this.gender = json.getInt("gender");
            this.url = json.getString("url");
            this.created_at = User.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.followers_count = json.getInt("followers_count");
            this.friends_count = json.getInt("friends_count");
            this.favourites_count = json.getInt("favourites_count");
            this.statuses_count = json.getInt("statuses_count");
            this.geoEnable = json.getBoolean("geo_enable");
            this.reason = json.getString("reason");
            this.darenRec = json.getString("darenRec");
            if (!json.isNull("status")) {
                this.status = new SimpleStatus(json.getJSONObject("status"));
            }
            if (!json.isNull("sysTag")) {
                JSONArray sys_tags = json.getJSONArray("sysTag");
                this.sysTag = new String[sys_tags.length()];
                i = 0;
                while (i < sys_tags.length()) {
                    this.sysTag[i] = sys_tags.getString(i);
                    ++i;
                }
            }
            if (!json.isNull("userTag")) {
                JSONArray user_tags = json.getJSONArray("userTag");
                this.userTag = new String[user_tags.length()];
                i = 0;
                while (i < user_tags.length()) {
                    this.userTag[i] = user_tags.getString(i);
                    ++i;
                }
            }
        }
        catch (JSONException je) {
            throw new TBlogException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProfileImageURL() {
        return this.profile_image_url;
    }

    public void setProfileImageURL(String profile_image_url) {
        this.profile_image_url = profile_image_url;
    }

    public String getScreenName() {
        return this.screen_name;
    }

    public void setScreenName(String screen_name) {
        this.screen_name = screen_name;
    }

    public int getGender() {
        return this.gender;
    }

    public void setGender(int gender) {
        this.gender = gender;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getCreatedAt() {
        return this.created_at;
    }

    public void setCreatedAt(Date created_at) {
        this.created_at = created_at;
    }

    public int getFollowersCount() {
        return this.followers_count;
    }

    public void setFollowersCount(int followers_count) {
        this.followers_count = followers_count;
    }

    public int getFriendsCount() {
        return this.friends_count;
    }

    public void setFriendsCount(int friends_count) {
        this.friends_count = friends_count;
    }

    public int getFavouritesCount() {
        return this.favourites_count;
    }

    public void setFavouritesCount(int favourites_count) {
        this.favourites_count = favourites_count;
    }

    public boolean isGeoEnable() {
        return this.geoEnable;
    }

    public void setGeoEnable(boolean geoEnable) {
        this.geoEnable = geoEnable;
    }

    public int getStatusesCount() {
        return this.statuses_count;
    }

    public void setStatusesCount(int statuses_count) {
        this.statuses_count = statuses_count;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public SimpleStatus getStatus() {
        return this.status;
    }

    public void setStatus(SimpleStatus status) {
        this.status = status;
    }

    public String getDarenRec() {
        return this.darenRec;
    }

    public void setDarenRec(String darenRec) {
        this.darenRec = darenRec;
    }

    public String[] getSysTag() {
        return this.sysTag;
    }

    public void setSysTag(String[] sysTag) {
        this.sysTag = sysTag;
    }

    public String[] getUserTag() {
        return this.userTag;
    }

    public void setUserTag(String[] userTag) {
        this.userTag = userTag;
    }

    public static PagableResponseList<User> createPagableUserList(Response res) throws TBlogException {
        try {
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("users");
            int size = list.length();
            PagableResponseList<User> users = new PagableResponseList<User>(size, json, res);
            int i = 0;
            while (i < size) {
                users.add(new User(list.getJSONObject(i)));
                ++i;
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new TBlogException(jsone);
        }
        catch (TBlogException te) {
            throw te;
        }
    }

    public static List<User> createUserList(JSONArray array) throws TBlogException {
        try {
            ArrayList<User> users = new ArrayList<User>();
            int i = 0;
            while (i < array.length()) {
                users.add(new User(array.getJSONObject(i)));
                ++i;
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new TBlogException(jsone);
        }
    }

    public static List<User> createUserList(Response res) throws TBlogException {
        try {
            JSONArray list = res.asJSONArray();
            ArrayList<User> users = new ArrayList<User>();
            int i = 0;
            while (i < list.length()) {
                users.add(new User(list.getJSONObject(i)));
                ++i;
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new TBlogException(jsone);
        }
    }
}

