/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.aop.target.AbstractPrototypeBasedTargetSource;
import org.springframework.aop.target.ThreadLocalTargetSourceStats;
import org.springframework.beans.factory.DisposableBean;

public final class ThreadLocalTargetSource
extends AbstractPrototypeBasedTargetSource
implements ThreadLocalTargetSourceStats,
DisposableBean {
    private ThreadLocal targetInThread = new ThreadLocal();
    private Set targetSet = new HashSet();
    private int invocations;
    private int hits;
    static /* synthetic */ Class class$org$springframework$aop$target$ThreadLocalTargetSourceStats;

    public Object getTarget() {
        ++this.invocations;
        Object target = this.targetInThread.get();
        if (target == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No target for apartment prototype '" + this.getTargetBeanName() + "' found in thread: creating one and binding it to thread '" + Thread.currentThread().getName() + "'"));
            }
            target = this.newPrototypeInstance();
            this.targetInThread.set(target);
            this.targetSet.add(target);
        } else {
            ++this.hits;
        }
        return target;
    }

    public void releaseTarget(Object o) {
    }

    public void destroy() {
        this.logger.info((Object)"Destroying ThreadLocal bindings");
        Iterator it = this.targetSet.iterator();
        while (it.hasNext()) {
            Object target = it.next();
            if (!(target instanceof DisposableBean)) continue;
            try {
                ((DisposableBean)target).destroy();
            }
            catch (Exception ex) {
                this.logger.warn((Object)("Thread-bound target of class '" + target.getClass() + "' threw exception from destroy() method"), (Throwable)ex);
            }
        }
        this.targetSet.clear();
        this.targetInThread = null;
    }

    public int getInvocations() {
        return this.invocations;
    }

    public int getHits() {
        return this.hits;
    }

    public int getObjects() {
        return this.targetSet.size();
    }

    public IntroductionAdvisor getStatsMixin() {
        DelegatingIntroductionInterceptor dii = new DelegatingIntroductionInterceptor(this);
        return new DefaultIntroductionAdvisor(dii, class$org$springframework$aop$target$ThreadLocalTargetSourceStats == null ? (class$org$springframework$aop$target$ThreadLocalTargetSourceStats = ThreadLocalTargetSource.class$("org.springframework.aop.target.ThreadLocalTargetSourceStats")) : class$org$springframework$aop$target$ThreadLocalTargetSourceStats);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

