/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.PartialList;
import org.jdom.ProcessingInstruction;

public class Document
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Document.java,v $ $Revision: 1.44 $ $Date: 2001/06/28 00:25:31 $ $Name: jdom_1_0_b7_rc4 $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected List content = new ArrayList(5);
    protected DocType docType;

    protected Document() {
    }

    public Document(List content) {
        this(content, null);
    }

    public Document(List content, DocType docType) {
        this.setContent(content);
        this.setDocType(docType);
    }

    public Document(Element rootElement) {
        this(rootElement, null);
    }

    public Document(Element rootElement, DocType docType) {
        this.setRootElement(rootElement);
        this.setDocType(docType);
    }

    public Document addContent(Comment comment) {
        if (comment.getParent() != null) {
            throw new IllegalAddException(this, comment, "The comment already has an existing parent \"" + comment.getParent().getQualifiedName() + "\"");
        }
        if (comment.getDocument() != null) {
            throw new IllegalAddException(this, comment, "The element already has an existing parent (the document root)");
        }
        this.content.add(comment);
        comment.setDocument(this);
        return this;
    }

    public Document addContent(ProcessingInstruction pi) {
        if (pi.getParent() != null) {
            throw new IllegalAddException(this, pi, "The PI already has an existing parent \"" + pi.getParent().getQualifiedName() + "\"");
        }
        if (pi.getDocument() != null) {
            throw new IllegalAddException(this, pi, "The PI already has an existing parent (the document root)");
        }
        this.content.add(pi);
        pi.setDocument(this);
        return this;
    }

    public Object clone() {
        Document doc = null;
        try {
            doc = (Document)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        doc.content = new ArrayList(5);
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Element) {
                doc.setRootElement((Element)((Element)obj).clone());
                continue;
            }
            if (obj instanceof Comment) {
                doc.addContent((Comment)((Comment)obj).clone());
                continue;
            }
            if (!(obj instanceof ProcessingInstruction)) continue;
            doc.addContent((ProcessingInstruction)((ProcessingInstruction)obj).clone());
        }
        if (this.docType != null) {
            doc.docType = (DocType)this.docType.clone();
        }
        return doc;
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public List getContent() {
        return this.content;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public List getMixedContent() {
        return this.getContent();
    }

    public ProcessingInstruction getProcessingInstruction(String target) {
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof ProcessingInstruction) || !((ProcessingInstruction)obj).getTarget().equals(target)) continue;
            return (ProcessingInstruction)obj;
        }
        return null;
    }

    public List getProcessingInstructions() {
        PartialList pis = new PartialList(this.content);
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof ProcessingInstruction)) continue;
            pis.addPartial(obj);
        }
        return pis;
    }

    public List getProcessingInstructions(String target) {
        PartialList pis = new PartialList(this.content);
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof ProcessingInstruction) || !((ProcessingInstruction)obj).getTarget().equals(target)) continue;
            pis.addPartial(obj);
        }
        return pis;
    }

    public Element getRootElement() {
        Iterator itr = this.content.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof Element)) continue;
            return (Element)obj;
        }
        return null;
    }

    public final String getSerializedForm() {
        throw new RuntimeException("Document.getSerializedForm() is not yet implemented");
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public boolean removeContent(Comment comment) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(comment)) {
            comment.setDocument(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(ProcessingInstruction pi) {
        if (this.content == null) {
            return false;
        }
        return this.content.remove(pi);
    }

    public boolean removeProcessingInstruction(String target) {
        ProcessingInstruction pi = this.getProcessingInstruction(target);
        if (pi == null) {
            return false;
        }
        return this.removeContent(pi);
    }

    public boolean removeProcessingInstructions(String target) {
        boolean deletedSome = false;
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            ProcessingInstruction pi;
            Object obj = i.next();
            if (!(obj instanceof ProcessingInstruction) || !(pi = (ProcessingInstruction)obj).getTarget().equals(target)) continue;
            deletedSome = true;
            i.remove();
            pi.setDocument(null);
        }
        return deletedSome;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document setContent(List newContent) {
        List oldContent;
        block28: {
            Iterator itr2;
            int itemsAdded;
            RuntimeException ex;
            block30: {
                Object obj;
                block29: {
                    if (newContent == null) {
                        return this;
                    }
                    Element oldRoot = this.getRootElement();
                    oldContent = this.content;
                    this.content = new ArrayList(5);
                    ex = null;
                    boolean didRoot = false;
                    itemsAdded = 0;
                    try {
                        try {
                            Iterator i = newContent.iterator();
                            while (true) {
                                if (!i.hasNext()) {
                                    if (didRoot) break;
                                    throw new IllegalAddException("A Document must contain a root element");
                                }
                                obj = i.next();
                                if (obj instanceof Element) {
                                    if (didRoot) throw new IllegalAddException("A Document may contain only one root element");
                                    this.setRootElement((Element)obj);
                                    if (oldRoot != null) {
                                        oldRoot.setDocument(null);
                                    }
                                    didRoot = true;
                                } else if (obj instanceof Comment) {
                                    this.addContent((Comment)obj);
                                } else if (obj instanceof ProcessingInstruction) {
                                    this.addContent((ProcessingInstruction)obj);
                                } else {
                                    String string;
                                    StringBuffer stringBuffer = new StringBuffer("A Document may directly contain only objects of type Element, Comment, and ProcessingInstruction: ");
                                    if (obj == null) {
                                        string = "null";
                                        throw new IllegalAddException(stringBuffer.append(string).append(" is not allowed").toString());
                                    }
                                    string = obj.getClass().getName();
                                    throw new IllegalAddException(stringBuffer.append(string).append(" is not allowed").toString());
                                }
                                ++itemsAdded;
                            }
                        }
                        catch (RuntimeException e) {
                            ex = e;
                        }
                        Object var8_12 = null;
                        if (ex == null) break block28;
                        this.content = oldContent;
                        if (oldRoot == null) break block29;
                        oldRoot.setDocument(this);
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        if (ex == null) throw throwable;
                        this.content = oldContent;
                        if (oldRoot != null) {
                            oldRoot.setDocument(this);
                        }
                        itr2 = newContent.iterator();
                        break block30;
                    }
                }
                Iterator itr2 = newContent.iterator();
                while (true) {
                    if (itemsAdded-- <= 0) {
                        throw ex;
                    }
                    obj = itr2.next();
                    if (obj instanceof Element) {
                        ((Element)obj).setDocument(null);
                        continue;
                    }
                    if (obj instanceof Comment) {
                        ((Comment)obj).setDocument(null);
                        continue;
                    }
                    if (!(obj instanceof ProcessingInstruction)) continue;
                    ((ProcessingInstruction)obj).setDocument(null);
                }
            }
            while (true) {
                if (itemsAdded-- <= 0) {
                    throw ex;
                }
                Object obj = itr2.next();
                if (obj instanceof Element) {
                    ((Element)obj).setDocument(null);
                    continue;
                }
                if (obj instanceof Comment) {
                    ((Comment)obj).setDocument(null);
                    continue;
                }
                if (!(obj instanceof ProcessingInstruction)) continue;
                ((ProcessingInstruction)obj).setDocument(null);
            }
        }
        Iterator itr = oldContent.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj instanceof Element) {
                ((Element)obj).setDocument(null);
                continue;
            }
            if (obj instanceof Comment) {
                ((Comment)obj).setDocument(null);
                continue;
            }
            if (!(obj instanceof ProcessingInstruction)) continue;
            ((ProcessingInstruction)obj).setDocument(null);
        }
        return this;
    }

    public Document setDocType(DocType docType) {
        if (docType != null && docType.getDocument() != null) {
            throw new IllegalAddException(this, docType, "The docType already is attached to a document");
        }
        if (docType != null) {
            docType.setDocument(this);
        }
        this.docType = docType;
        return this;
    }

    public Document setMixedContent(List mixedContent) {
        return this.setContent(mixedContent);
    }

    public Document setProcessingInstructions(List pis) {
        List current = this.getProcessingInstructions();
        Iterator i = current.iterator();
        while (i.hasNext()) {
            i.remove();
        }
        this.content.addAll(pis);
        return this;
    }

    public Document setRootElement(Element rootElement) {
        if (rootElement == null) {
            return this;
        }
        if (rootElement.isRootElement()) {
            throw new IllegalAddException(this, rootElement, "The element already has an existing parent (the document root)");
        }
        if (rootElement.getParent() != null) {
            throw new IllegalAddException(this, rootElement, "The element already has an existing parent \"" + rootElement.getParent().getQualifiedName() + "\"");
        }
        boolean hadRoot = false;
        ListIterator<Element> itr = this.content.listIterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof Element)) continue;
            Element departingRoot = (Element)obj;
            departingRoot.setDocument(null);
            itr.set(rootElement);
            hadRoot = true;
        }
        if (!hadRoot) {
            itr.add(rootElement);
        }
        rootElement.setDocument(this);
        return this;
    }

    public String toString() {
        StringBuffer stringForm = new StringBuffer().append("[Document: ");
        if (this.docType != null) {
            stringForm.append(this.docType.toString()).append(", ");
        } else {
            stringForm.append(" No DOCTYPE declaration, ");
        }
        Element rootElement = this.getRootElement();
        if (rootElement != null) {
            stringForm.append("Root is ").append(rootElement.toString());
        } else {
            stringForm.append(" No root element");
        }
        stringForm.append("]");
        return stringForm.toString();
    }
}

