/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybResultSet;
import com.sybase.jdbc2.tds.TdsEventContext;
import com.sybase.jdbcx.SybEventHandler;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class EventThread
implements Runnable {
    protected boolean _threadState;
    private TdsEventContext _tec;
    private SybEventHandler _hdlr;
    private String _procName;
    protected int _eventCount;
    private SybResultSet _params;

    protected EventThread(TdsEventContext tdsEventContext) {
        this._tec = tdsEventContext;
        this._eventCount = 0;
    }

    public void run() {
        while (true) {
            EventThread eventThread;
            Object object = this;
            synchronized (object) {
                if (this._eventCount == 0) {
                    this._threadState = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        eventThread = null;
                        continue;
                    }
                    this._threadState = false;
                }
            }
            this._procName = null;
            this._params = null;
            this._hdlr = null;
            try {
                this._tec.beginRequest();
                this._procName = this._tec.getProcName();
                this._params = this._tec.getParams();
                this._hdlr = this._tec.getHandler(this._procName);
            }
            catch (SQLException sQLException) {
                this._tec.chainException(sQLException);
            }
            if (this._hdlr == null) {
                this._tec._conn.chainWarnings(this._tec._chainedSqe);
                this._tec._chainedSqe = null;
                object = this;
                synchronized (object) {
                    --this._eventCount;
                }
            }
            if (this._params == null) {
                this._params = this._tec.makeEmptyParams();
            }
            object = SybConnection.convertToWarnings(this._tec._chainedSqe);
            if (this._tec._trs._warning == null) {
                this._tec._trs._warning = object;
            } else {
                this._tec._trs._warning.setNextWarning((SQLWarning)object);
            }
            this._hdlr.event(this._procName, this._params);
            try {
                this._params.close();
            }
            catch (SQLException sQLException) {}
            eventThread = this;
            synchronized (eventThread) {
                --this._eventCount;
            }
        }
    }
}

