/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.LoaderConnection;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class DynamicClassLoader
extends ClassLoader
implements com.sybase.jdbcx.DynamicClassLoader {
    private LoaderConnection _connection;

    public DynamicClassLoader(LoaderConnection loaderConnection) throws SecurityException {
        this._connection = loaderConnection;
    }

    public DynamicClassLoader(String string, Properties properties) throws SecurityException {
        this(new LoaderConnection(string, properties));
    }

    public void closeConnection() throws SQLException {
        this._connection.kill();
    }

    public Class findClass(String string) {
        byte[] byArray = null;
        try {
            byArray = this.loadClassData(string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    public Connection getConnection() {
        return this._connection.getConnection();
    }

    public boolean getKeepConnectionAlive() {
        return this._connection.getKeepAlive();
    }

    public boolean hasClassBeenLoaded(String string) {
        boolean bl = false;
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            bl = true;
        }
        return bl;
    }

    private byte[] loadClassData(String string) throws SQLException, IOException {
        byte[] byArray = this._connection.fetchClass(string);
        return byArray;
    }

    public void openConnection() throws SQLException {
        this._connection.open();
    }

    private void preloadAJar(String string) throws IOException, SQLException {
        boolean bl = false;
        Enumeration enumeration = this._connection.allClassesInJar(string);
        while (enumeration.hasMoreElements()) {
            bl = true;
            LoaderConnection.ClassData classData = (LoaderConnection.ClassData)enumeration.nextElement();
            if (classData == null) continue;
            byte[] byArray = classData._data;
            String string2 = classData._name;
            Class<?> clazz = this.findLoadedClass(string2);
            if (clazz == null) {
                clazz = this.defineClass(string2, byArray, 0, byArray.length);
            }
            this.resolveClass(clazz);
        }
        if (!bl) {
            ErrorMessage.raiseWarning("010PF");
        }
    }

    public synchronized void preloadJars(String[] stringArray) throws SQLException {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            try {
                this.preloadAJar(string);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            ++n;
        }
    }

    public void setKeepConnectionAlive(boolean bl) {
        this._connection.setKeepAlive(bl);
    }
}

